/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.examine.circular.local.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mdm.business.customer.retailer.sdk.service.CustomerRetailerVoService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.UuidCrmUtil;
import com.biz.crm.mn.third.system.sd.sdk.dto.AuditCostPostingCallbackDataDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.AuditCostPostingCallbackDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.FeePoolQueryDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.FeePoolQuerySonCompanyDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.SonAuditCostPostingCallbackDataDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.SonAuditCostPostingCallbackDto;
import com.biz.crm.mn.third.system.sd.sdk.service.SapSdApiService;
import com.biz.crm.mn.third.system.sd.sdk.vo.FeePoolQuerySonCompanyVo;
import com.biz.crm.mn.third.system.sd.sdk.vo.FeePoolQueryVo;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComBudgetForecastDetailDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.service.SubComBudgetForecastService;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComBudgetForecastVo;
import com.biz.crm.tpm.business.daily.sales.data.sdk.dto.TpmSapDaySalesExamineCircularSearchDto;
import com.biz.crm.tpm.business.daily.sales.data.sdk.service.TpmSapDaySalesService;
import com.biz.crm.tpm.business.daily.sales.data.sdk.vo.TpmSapDaySalesExamineCircularSearchVo;
import com.biz.crm.tpm.business.examine.circular.local.entity.TpmExamineCircularEntity;
import com.biz.crm.tpm.business.examine.circular.local.entity.TpmExamineCircularProductSplitEntity;
import com.biz.crm.tpm.business.examine.circular.local.enums.CommitStatusEnum;
import com.biz.crm.tpm.business.examine.circular.local.enums.SucessOrFailEnum;
import com.biz.crm.tpm.business.examine.circular.local.mapper.TpmExamineCircularEntityMapper;
import com.biz.crm.tpm.business.examine.circular.local.mapper.TpmExamineCircularProductSplitEntityMapper;
import com.biz.crm.tpm.business.examine.circular.local.repository.TpmExamineCircularEntityRepository;
import com.biz.crm.tpm.business.examine.circular.local.repository.TpmExamineCircularProductSplitEntityRepository;
import com.biz.crm.tpm.business.examine.circular.local.service.TpmExamineCircularPushService;
import com.biz.crm.tpm.business.examine.circular.local.util.TpmExamineCircularUtil;
import com.biz.crm.tpm.business.examine.circular.sdk.constant.TpmExamineCircularRelationTypeEnum;
import com.biz.crm.tpm.business.examine.circular.sdk.dto.CustomerCostAssessedAmountStatisticsDto;
import com.biz.crm.tpm.business.examine.circular.sdk.dto.SurplusFeePoolBalanceAssessedAmountStatisticsDto;
import com.biz.crm.tpm.business.examine.circular.sdk.dto.TpmExamineCircularDto;
import com.biz.crm.tpm.business.examine.circular.sdk.dto.TpmExamineCircularLogDto;
import com.biz.crm.tpm.business.examine.circular.sdk.dto.TpmExamineCircularProcessSubmitDto;
import com.biz.crm.tpm.business.examine.circular.sdk.dto.TpmExamineCircularProductSplitDto;
import com.biz.crm.tpm.business.examine.circular.sdk.event.TpmExamineCircularLogEventListener;
import com.biz.crm.tpm.business.examine.circular.sdk.service.TpmExamineCircularService;
import com.biz.crm.tpm.business.examine.circular.sdk.vo.CostPoolAuditReportVo;
import com.biz.crm.tpm.business.examine.circular.sdk.vo.CustomerCostAssessedAmountStatisticsVo;
import com.biz.crm.tpm.business.examine.circular.sdk.vo.MobileExamineCircularApprovedVo;
import com.biz.crm.tpm.business.examine.circular.sdk.vo.SurplusFeePoolBalanceAssessedAmountStatisticsVo;
import com.biz.crm.tpm.business.examine.circular.sdk.vo.TpmExamineCircularProductSplitCalRespVo;
import com.biz.crm.tpm.business.examine.circular.sdk.vo.TpmExamineCircularProductSplitRespVo;
import com.biz.crm.tpm.business.examine.circular.sdk.vo.TpmExamineCircularRelationFeePoolHandleImportVo;
import com.biz.crm.tpm.business.examine.circular.sdk.vo.TpmExamineCircularRespVo;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.dto.MainOnedaySalesDataDto;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.service.MainOnedaySaleDataService;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.vo.MainOnedaySalesDataVo;
import com.biz.crm.tpm.business.month.budget.sdk.dto.OperateMonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.BudgetOperationTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetLockService;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.service.SubComMonthBudgetLockService;
import com.biz.crm.tpm.business.month.budget.sdk.service.SubComMonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.SubComMonthBudgetVo;
import com.biz.crm.tpm.business.third.system.sdk.dto.Ce1ExamineCircularSearchDto;
import com.biz.crm.tpm.business.third.system.sdk.service.Ce1MnjtSdkService;
import com.biz.crm.tpm.business.third.system.sdk.vo.Ce1ExamineCircularSearchVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBatchBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.venus.sdk.service.file.FileHandleService;
import com.bizunited.nebula.venus.sdk.vo.OrdinaryFileVo;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class TpmExamineCircularServiceImpl
implements TpmExamineCircularService {
    private static final Logger log = LoggerFactory.getLogger(TpmExamineCircularServiceImpl.class);
    @Autowired(required=false)
    private TpmExamineCircularEntityMapper tpmExamineCircularEntityMapper;
    @Autowired(required=false)
    private TpmExamineCircularProductSplitEntityMapper tpmExamineCircularProductSplitEntityMapper;
    @Autowired(required=false)
    private TpmExamineCircularProductSplitEntityRepository tpmExamineCircularProductSplitEntityRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private TpmExamineCircularLogEventListener tpmExamineCircularLogEventListener;
    @Autowired(required=false)
    private FileHandleService fileHandleService;
    @Autowired(required=false)
    private TpmExamineCircularEntityRepository tpmExamineCircularEntityRepository;
    @Autowired(required=false)
    private ProcessBatchBusinessService processBatchBusinessService;
    @Autowired(required=false)
    private SubComMonthBudgetService subComMonthBudgetService;
    @Autowired(required=false)
    private SubComMonthBudgetLockService subComMonthBudgetLockService;
    @Autowired(required=false)
    private MonthBudgetService monthBudgetService;
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private SapSdApiService sapSdApiService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private TpmExamineCircularUtil tpmExamineCircularUtil;
    @Autowired(required=false)
    private ActivityFormService activityFormService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private TpmSapDaySalesService tpmSapDaySalesService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private CustomerRetailerVoService customerRetailerVoService;
    @Autowired(required=false)
    private MainOnedaySaleDataService mainOnedaySaleDataService;
    @Autowired(required=false)
    private Ce1MnjtSdkService ce1MnjtSdkService;
    @Autowired(required=false)
    private SubComBudgetForecastService subComBudgetForecastService;
    @Autowired(required=false)
    private TpmExamineCircularPushService tpmExamineCircularPushService;
    @Autowired(required=false)
    private MonthBudgetLockService monthBudgetLockService;

    public Page<TpmExamineCircularRespVo> findByConditions(Pageable pageable, TpmExamineCircularDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (dto == null) {
            dto = new TpmExamineCircularDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.tpmExamineCircularEntityMapper.findByConditions((Page<TpmExamineCircularRespVo>)page, dto);
    }

    public TpmExamineCircularRespVo findById(String id) {
        TpmExamineCircularRespVo respVo = this.tpmExamineCircularEntityMapper.findByIdAndTenantCode(id, TenantUtils.getTenantCode());
        Validate.notNull((Object)respVo, (String)"\u6570\u636e\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        if (TpmExamineCircularRelationTypeEnum.FEE_POOL_RELATION.getCode().equals(respVo.getRelationType()) || TpmExamineCircularRelationTypeEnum.FEE_POOL_RELATION_AND_BUDGET.getCode().equals(respVo.getRelationType())) {
            List<TpmExamineCircularProductSplitRespVo> productSplitRespVoList = this.tpmExamineCircularProductSplitEntityMapper.findByExamineCircularCode(respVo.getExamineCircularCode());
            respVo.setProductSplitList(productSplitRespVoList);
        }
        if (StringUtils.isEmpty((CharSequence)respVo.getProtocols())) {
            return respVo;
        }
        List<String> list = Arrays.asList(respVo.getProtocols().split(","));
        if (CollectionUtil.isEmpty(list)) {
            return respVo;
        }
        respVo.setProtocolList(this.fileHandleService.findByIds(list));
        return respVo;
    }

    public TpmExamineCircularRespVo findByProcessNo(String processNo) {
        List<TpmExamineCircularEntity> examineCircularEntities = this.tpmExamineCircularEntityRepository.findByProcessNo(processNo);
        Validate.notEmpty(examineCircularEntities, (String)"\u6570\u636e\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        TpmExamineCircularRespVo respVo = (TpmExamineCircularRespVo)this.nebulaToolkitService.copyObjectByBlankList((Object)examineCircularEntities.get(0), TpmExamineCircularRespVo.class, null, null, new String[0]);
        if (TpmExamineCircularRelationTypeEnum.FEE_POOL_RELATION.getCode().equals(respVo.getRelationType())) {
            List<TpmExamineCircularProductSplitRespVo> productSplitRespVoList = this.tpmExamineCircularProductSplitEntityMapper.findByExamineCircularCode(respVo.getExamineCircularCode());
            respVo.setProductSplitList(productSplitRespVoList);
        }
        if (!StringUtils.isEmpty((CharSequence)respVo.getProtocols())) {
            String[] protocolIdList;
            ArrayList<OrdinaryFileVo> files = new ArrayList<OrdinaryFileVo>();
            for (String protocolId : protocolIdList = (String[])respVo.getProtocols().split(",").clone()) {
                OrdinaryFileVo fileVo = this.fileHandleService.findById(protocolId);
                files.add(fileVo);
            }
            respVo.setProtocolList(files);
        }
        return respVo;
    }

    @Transactional(rollbackFor={Exception.class})
    public TpmExamineCircularRespVo create(TpmExamineCircularDto dto) {
        TpmExamineCircularEntity entity;
        TpmExamineCircularRespVo respVo = new TpmExamineCircularRespVo();
        if (dto.validate()) {
            Date date = new Date();
            FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
            dto.setTenantCode(TenantUtils.getTenantCode());
            entity = (TpmExamineCircularEntity)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, TpmExamineCircularEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            entity.setExamineCircularCode((String)this.generateCodeService.generateCode("K", 1, Integer.valueOf(9), 0L, TimeUnit.DAYS).get(0));
            entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            entity.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
            entity.setApplyTime(date);
            entity.setApplyUserAccount(loginDetails.getUsername());
            entity.setApplyUserName(loginDetails.getRealName());
            entity.setOrgCode(loginDetails.getOrgCode());
            entity.setOrgName(loginDetails.getOrgName());
            if (StringUtils.isEmpty((CharSequence)dto.getIsSplit()) && StringUtils.equals((CharSequence)BusinessUnitEnum.SON_COMPANY.getCode(), (CharSequence)dto.getBusinessUnitCode())) {
                entity.setIsSplit(BooleanEnum.FALSE.getCapital());
                dto.setIsSplit(BooleanEnum.FALSE.getCapital());
            }
            if ((StringUtils.equals((CharSequence)TpmExamineCircularRelationTypeEnum.FEE_POOL_RELATION.getCode(), (CharSequence)dto.getRelationType()) || StringUtils.equals((CharSequence)TpmExamineCircularRelationTypeEnum.FEE_POOL_RELATION_AND_BUDGET.getCode(), (CharSequence)dto.getRelationType())) && (StringUtils.isEmpty((CharSequence)dto.getIsSplit()) || StringUtils.equals((CharSequence)BusinessUnitEnum.ONLINE.getCode(), (CharSequence)dto.getBusinessUnitCode()) || StringUtils.equals((CharSequence)BusinessUnitEnum.VERTICAL.getCode(), (CharSequence)dto.getBusinessUnitCode()))) {
                entity.setIsSplit(BooleanEnum.TRUE.getCapital());
                dto.setIsSplit(BooleanEnum.TRUE.getCapital());
            }
            if (!StringUtils.equals((CharSequence)BusinessUnitEnum.ONLINE.getCode(), (CharSequence)dto.getBusinessUnitCode()) && (StringUtils.equals((CharSequence)TpmExamineCircularRelationTypeEnum.FEE_POOL_RELATION.getCode(), (CharSequence)dto.getRelationType()) || StringUtils.equals((CharSequence)TpmExamineCircularRelationTypeEnum.FEE_POOL_RELATION_AND_BUDGET.getCode(), (CharSequence)dto.getRelationType()))) {
                entity.setIsUpAccount(BooleanEnum.TRUE.getCapital());
            }
            if (TpmExamineCircularRelationTypeEnum.FEE_POOL_RELATION.getCode().equals(dto.getRelationType()) || TpmExamineCircularRelationTypeEnum.FEE_POOL_RELATION_AND_BUDGET.getCode().equals(dto.getRelationType())) {
                if (StringUtils.equals((CharSequence)BooleanEnum.TRUE.getCapital(), (CharSequence)dto.getIsUpAccount())) {
                    ArrayList<TpmExamineCircularRespVo> list2 = new ArrayList<TpmExamineCircularRespVo>();
                    TpmExamineCircularRespVo tpmExamineCircularRespVo = (TpmExamineCircularRespVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, TpmExamineCircularRespVo.class, HashSet.class, ArrayList.class, new String[0]);
                    list2.add(tpmExamineCircularRespVo);
                    this.feelPoolBalanceValidate(list2, respVo);
                }
                if (StringUtils.equals((CharSequence)BooleanEnum.TRUE.getCapital(), (CharSequence)dto.getIsSplit())) {
                    if (CollectionUtils.isEmpty((Collection)dto.getProductSplitList())) {
                        throw new UnsupportedOperationException("\u7f3a\u5c11\u4ea7\u54c1\u5206\u644a\u6570\u636e");
                    }
                    Map<String, Object> salesProductAmount = this.tpmExamineCircularUtil.getSalesProductAmount(dto.getCacheKey());
                    ArrayList<TpmExamineCircularProductSplitEntity> splitEntityList = new ArrayList<TpmExamineCircularProductSplitEntity>();
                    for (TpmExamineCircularProductSplitDto splitDto : dto.getProductSplitList()) {
                        TpmExamineCircularProductSplitEntity splitEntity = (TpmExamineCircularProductSplitEntity)this.nebulaToolkitService.copyObjectByWhiteList((Object)splitDto, TpmExamineCircularProductSplitEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                        splitEntity.setId(UuidCrmUtil.general());
                        splitEntity.setExamineCircularCode(entity.getExamineCircularCode());
                        splitEntity.setCreateAccount(loginDetails.getUsername());
                        splitEntity.setCreateName(loginDetails.getRealName());
                        splitEntity.setModifyAccount(loginDetails.getUsername());
                        splitEntity.setModifyName(loginDetails.getRealName());
                        splitEntity.setCreateTime(date);
                        splitEntity.setModifyTime(date);
                        splitEntity.setTenantCode(TenantUtils.getTenantCode());
                        splitEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                        splitEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                        if (salesProductAmount.containsKey(splitEntity.getProductCode())) {
                            splitEntity.setSalesAmount(new BigDecimal(salesProductAmount.get(splitEntity.getProductCode()).toString()));
                        }
                        String splitDetailCode = (String)this.generateCodeService.generateCode("KM", 1, Integer.valueOf(8), 0L, TimeUnit.DAYS).get(0);
                        splitEntity.setSplitDetailCode(splitDetailCode);
                        splitEntityList.add(splitEntity);
                    }
                    int pageSize = 500;
                    Lists.partition(splitEntityList, (int)pageSize).forEach(list -> this.tpmExamineCircularProductSplitEntityMapper.insertList((List<TpmExamineCircularProductSplitEntity>)list));
                }
            }
            if (CollectionUtil.isNotEmpty((Collection)dto.getProtocolList())) {
                List protocolList = dto.getProtocolList();
                List protocolIds = protocolList.stream().map(OrdinaryFileVo::getId).collect(Collectors.toList());
                String protocols = Joiner.on((String)",").join(protocolIds);
                entity.setProtocols(protocols);
            }
        } else {
            throw new UnsupportedOperationException("\u7f3a\u5c11\u5fc5\u586b\u6570\u636e");
        }
        this.tpmExamineCircularEntityMapper.insert(entity);
        respVo.setId(entity.getId());
        TpmExamineCircularLogDto logDto = new TpmExamineCircularLogDto();
        TpmExamineCircularDto newest = (TpmExamineCircularDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, TpmExamineCircularDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        logDto.setNewest(newest);
        this.tpmExamineCircularLogEventListener.onCreate(logDto);
        return respVo;
    }

    @Transactional(rollbackFor={Exception.class})
    public TpmExamineCircularRespVo edit(TpmExamineCircularDto dto) {
        TpmExamineCircularEntity entity;
        TpmExamineCircularEntity original;
        TpmExamineCircularRespVo respVo = new TpmExamineCircularRespVo();
        if (StringUtils.isNotEmpty((CharSequence)dto.getId()) && dto.validate()) {
            dto.setTenantCode(TenantUtils.getTenantCode());
            original = this.tpmExamineCircularEntityRepository.findById(dto.getId());
            if (ProcessStatusEnum.PASS.getDictCode().equals(original.getProcessStatus())) {
                throw new UnsupportedOperationException("\u4e0d\u53ef\u7f16\u8f91\u5ba1\u6279\u901a\u8fc7\u6570\u636e");
            }
            if (ProcessStatusEnum.COMMIT.getDictCode().equals(original.getProcessStatus())) {
                throw new UnsupportedOperationException("\u4e0d\u53ef\u7f16\u8f91\u5ba1\u6279\u4e2d\u6570\u636e");
            }
            entity = (TpmExamineCircularEntity)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, TpmExamineCircularEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            if (CollectionUtils.isEmpty((Collection)dto.getProtocolList())) {
                entity.setProtocols("");
            } else {
                entity.setProtocols(dto.getProtocolList().stream().map(OrdinaryFileVo::getId).collect(Collectors.joining(",")));
            }
            if ((StringUtils.equals((CharSequence)BusinessUnitEnum.SON_COMPANY.getCode(), (CharSequence)dto.getBusinessUnitCode()) || BusinessUnitEnum.isDefaultBusinessUnit((String)dto.getBusinessUnitCode()) || StringUtils.equals((CharSequence)BusinessUnitEnum.VERTICAL.getCode(), (CharSequence)dto.getBusinessUnitCode())) && (StringUtils.equals((CharSequence)TpmExamineCircularRelationTypeEnum.FEE_POOL_RELATION.getCode(), (CharSequence)dto.getRelationType()) || StringUtils.equals((CharSequence)TpmExamineCircularRelationTypeEnum.FEE_POOL_RELATION_AND_BUDGET.getCode(), (CharSequence)dto.getRelationType())) && StringUtils.isEmpty((CharSequence)dto.getIsSplit())) {
                entity.setIsSplit(BooleanEnum.TRUE.getCapital());
                dto.setIsSplit(BooleanEnum.TRUE.getCapital());
            }
            if (TpmExamineCircularRelationTypeEnum.FEE_POOL_RELATION.getCode().equals(dto.getRelationType()) || TpmExamineCircularRelationTypeEnum.FEE_POOL_RELATION_AND_BUDGET.getCode().equals(dto.getRelationType())) {
                if (StringUtils.equals((CharSequence)BooleanEnum.TRUE.getCapital(), (CharSequence)dto.getIsUpAccount())) {
                    ArrayList<TpmExamineCircularRespVo> list2 = new ArrayList<TpmExamineCircularRespVo>();
                    TpmExamineCircularRespVo tpmExamineCircularRespVo = (TpmExamineCircularRespVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, TpmExamineCircularRespVo.class, HashSet.class, ArrayList.class, new String[0]);
                    list2.add(tpmExamineCircularRespVo);
                    this.feelPoolBalanceValidate(list2, respVo);
                }
                if (StringUtils.equals((CharSequence)BooleanEnum.TRUE.getCapital(), (CharSequence)dto.getIsSplit())) {
                    if (CollectionUtils.isEmpty((Collection)dto.getProductSplitList())) {
                        throw new UnsupportedOperationException("\u7f3a\u5c11\u4ea7\u54c1\u5206\u644a\u6570\u636e");
                    }
                    this.tpmExamineCircularProductSplitEntityMapper.deleteByExamineCircularCode(original.getExamineCircularCode());
                    Map<String, Object> salesProductAmount = this.tpmExamineCircularUtil.getSalesProductAmount(dto.getCacheKey());
                    ArrayList<TpmExamineCircularProductSplitEntity> splitEntityList = new ArrayList<TpmExamineCircularProductSplitEntity>();
                    for (TpmExamineCircularProductSplitDto splitDto : dto.getProductSplitList()) {
                        TpmExamineCircularProductSplitEntity splitEntity = (TpmExamineCircularProductSplitEntity)this.nebulaToolkitService.copyObjectByWhiteList((Object)splitDto, TpmExamineCircularProductSplitEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                        FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
                        Date date = new Date();
                        splitEntity.setId(UUID.randomUUID().toString().replaceAll("-", ""));
                        splitEntity.setExamineCircularCode(original.getExamineCircularCode());
                        splitEntity.setCreateAccount(loginDetails.getUsername());
                        splitEntity.setCreateName(loginDetails.getRealName());
                        splitEntity.setModifyAccount(loginDetails.getUsername());
                        splitEntity.setModifyName(loginDetails.getRealName());
                        splitEntity.setCreateTime(date);
                        splitEntity.setModifyTime(date);
                        splitEntity.setTenantCode(loginDetails.getTenantCode());
                        splitEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                        splitEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                        if (salesProductAmount.containsKey(splitEntity.getProductCode())) {
                            splitEntity.setSalesAmount(new BigDecimal(salesProductAmount.get(splitEntity.getProductCode()).toString()));
                        }
                        String splitDetailCode = (String)this.generateCodeService.generateCode("KM", 1, Integer.valueOf(8), 0L, TimeUnit.DAYS).get(0);
                        splitEntity.setSplitDetailCode(splitDetailCode);
                        splitEntityList.add(splitEntity);
                    }
                    int pageSize = 500;
                    Lists.partition(splitEntityList, (int)pageSize).forEach(list -> this.tpmExamineCircularProductSplitEntityMapper.insertList((List<TpmExamineCircularProductSplitEntity>)list));
                }
            }
        } else {
            throw new UnsupportedOperationException("\u7f3a\u5c11\u5fc5\u586b\u6570\u636e");
        }
        this.tpmExamineCircularEntityMapper.updateById(entity);
        TpmExamineCircularLogDto logDto = new TpmExamineCircularLogDto();
        TpmExamineCircularDto newest = (TpmExamineCircularDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, TpmExamineCircularDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        logDto.setNewest(newest);
        TpmExamineCircularDto originalDto = (TpmExamineCircularDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)original, TpmExamineCircularDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        logDto.setOriginal(originalDto);
        this.tpmExamineCircularLogEventListener.onUpdate(logDto);
        return respVo;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByIdList(List<String> ids) {
        List<TpmExamineCircularEntity> entityList = this.tpmExamineCircularEntityMapper.findByIdListAndTenantCode(ids, TenantUtils.getTenantCode());
        for (TpmExamineCircularEntity entity : entityList) {
            if (ProcessStatusEnum.PASS.getDictCode().equals(entity.getProcessStatus())) {
                throw new UnsupportedOperationException("\u4e0d\u53ef\u5220\u9664\u5ba1\u6279\u901a\u8fc7\u6570\u636e");
            }
            if (!ProcessStatusEnum.COMMIT.getDictCode().equals(entity.getProcessStatus())) continue;
            throw new UnsupportedOperationException("\u4e0d\u53ef\u5220\u9664\u5ba1\u6279\u4e2d\u6570\u636e");
        }
        this.tpmExamineCircularProductSplitEntityMapper.deleteByExamineCircularIdListAndTenantCode(ids, TenantUtils.getTenantCode());
        this.tpmExamineCircularEntityMapper.deleteByIdListAndTenantCode(ids, TenantUtils.getTenantCode());
        for (TpmExamineCircularEntity entity : entityList) {
            TpmExamineCircularLogDto logDto = new TpmExamineCircularLogDto();
            TpmExamineCircularDto newest = (TpmExamineCircularDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, TpmExamineCircularDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            newest.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            newest.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            logDto.setNewest(newest);
            TpmExamineCircularDto originalDto = (TpmExamineCircularDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, TpmExamineCircularDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            logDto.setOriginal(originalDto);
            this.tpmExamineCircularLogEventListener.onDelete(logDto);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void enable(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u8bf7\u9009\u62e9\u6570\u636e!");
        this.tpmExamineCircularProductSplitEntityMapper.enableByExamineCircularIdListAndTenantCode(ids, TenantUtils.getTenantCode());
        this.tpmExamineCircularEntityMapper.enableByIdListAndTenantCode(ids, TenantUtils.getTenantCode());
    }

    @Transactional(rollbackFor={Exception.class})
    public void disable(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u8bf7\u9009\u62e9\u6570\u636e!");
        List<TpmExamineCircularEntity> entityList = this.tpmExamineCircularEntityMapper.findByIdListAndTenantCode(ids, TenantUtils.getTenantCode());
        for (TpmExamineCircularEntity entity : entityList) {
            if (ProcessStatusEnum.PASS.getDictCode().equals(entity.getProcessStatus())) {
                throw new UnsupportedOperationException("\u4e0d\u53ef\u7981\u7528\u5ba1\u6279\u901a\u8fc7\u6570\u636e");
            }
            if (!ProcessStatusEnum.COMMIT.getDictCode().equals(entity.getProcessStatus())) continue;
            throw new UnsupportedOperationException("\u4e0d\u53ef\u7981\u7528\u5ba1\u6279\u4e2d\u6570\u636e");
        }
        this.tpmExamineCircularProductSplitEntityMapper.disableByExamineCircularIdListAndTenantCode(ids, TenantUtils.getTenantCode());
        this.tpmExamineCircularEntityMapper.disableByIdListAndTenantCode(ids, TenantUtils.getTenantCode());
    }

    public List<CustomerCostAssessedAmountStatisticsVo> listAssessedAmountByOrgCusCodes(CustomerCostAssessedAmountStatisticsDto dto) {
        return this.tpmExamineCircularEntityRepository.listAssessedAmountByOrgCusCodes(dto);
    }

    @Transactional(rollbackFor={Exception.class})
    public TpmExamineCircularRespVo submitApproval(TpmExamineCircularProcessSubmitDto submitDto) {
        Validate.notNull((Object)submitDto, (String)"\u6d41\u7a0b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)submitDto.getProcessBusiness(), (String)"\u6d41\u7a0b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((Collection)submitDto.getIds(), (String)"\u63d0\u4ea4\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<TpmExamineCircularEntity> entities = this.tpmExamineCircularEntityMapper.findByIdList(submitDto.getIds(), TenantUtils.getTenantCode());
        Validate.notEmpty(entities, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8003\u6838\u901a\u62a5", (Object[])new Object[0]);
        TpmExamineCircularRespVo respVo = new TpmExamineCircularRespVo();
        List feePoolEntities = entities.stream().filter(o -> TpmExamineCircularRelationTypeEnum.FEE_POOL_RELATION.getCode().equals(o.getRelationType()) && StringUtils.equals((CharSequence)BooleanEnum.TRUE.getCapital(), (CharSequence)o.getIsUpAccount())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(feePoolEntities)) {
            Collection examineCircularRespVos = this.nebulaToolkitService.copyCollectionByWhiteList(feePoolEntities, TpmExamineCircularEntity.class, TpmExamineCircularRespVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.feelPoolBalanceValidate(new ArrayList<TpmExamineCircularRespVo>(examineCircularRespVos), respVo);
        }
        for (TpmExamineCircularEntity entity : entities) {
            Map<String, SubComBudgetForecastVo> budgetVoMap;
            boolean checkBudget;
            if (ProcessStatusEnum.PASS.getDictCode().equals(entity.getProcessStatus()) || ProcessStatusEnum.COMMIT.getDictCode().equals(entity.getProcessStatus())) {
                throw new UnsupportedOperationException("\u5b58\u5728\u5ba1\u6279\u4e2d\u6216\u5ba1\u6279\u901a\u8fc7\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
            }
            boolean subtract = false;
            if (BigDecimal.ZERO.compareTo(entity.getExamineCircularAmount()) < 0) {
                subtract = true;
            }
            boolean bl = checkBudget = StringUtils.equals((CharSequence)TpmExamineCircularRelationTypeEnum.BUDGET_RELATION.getCode(), (CharSequence)entity.getRelationType()) || StringUtils.equals((CharSequence)TpmExamineCircularRelationTypeEnum.FEE_POOL_RELATION_AND_BUDGET.getCode(), (CharSequence)entity.getRelationType()) && StringUtils.equals((CharSequence)BooleanEnum.TRUE.getCapital(), (CharSequence)entity.getIsUpAccount());
            if (!subtract || !checkBudget) continue;
            if (StringUtils.equals((CharSequence)entity.getBusinessUnitCode(), (CharSequence)BusinessUnitEnum.SON_COMPANY.getCode())) {
                List subComBudgetForecastVos = this.subComBudgetForecastService.listByBudgetForecastCodeList((List)Lists.newArrayList((Iterable)Lists.newArrayList((Object[])new String[]{entity.getBudgetCode()})));
                budgetVoMap = subComBudgetForecastVos.stream().collect(Collectors.toMap(SubComBudgetForecastVo::getBudgetForecastCode, v -> v));
                Validate.isTrue((boolean)budgetVoMap.containsKey(entity.getBudgetCode()), (String)"\u5206\u5b50\u9884\u7b97\u9884\u6d4b[%s]\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u9884\u7b97\u9884\u6d4b\u662f\u5426\u542f\u7528\u6216\u662f\u5426\u5b58\u5728\uff01", (Object[])new Object[]{entity.getBudgetCode()});
                BigDecimal remainderAmount = budgetVoMap.get(entity.getBudgetCode()).getRemainderAmount();
                if (!Objects.isNull(remainderAmount)) continue;
                remainderAmount = BigDecimal.ZERO;
                continue;
            }
            List monthBudgetVos = this.monthBudgetService.listByCodes((List)Lists.newArrayList((Iterable)Lists.newArrayList((Object[])new String[]{entity.getBudgetCode()})));
            budgetVoMap = monthBudgetVos.stream().collect(Collectors.toMap(MonthBudgetVo::getMonthBudgetCode, v -> v));
            Validate.isTrue((boolean)budgetVoMap.containsKey(entity.getBudgetCode()), (String)"\u6708\u5ea6\u9884\u7b97[%s]\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u9884\u7b97\u662f\u5426\u542f\u7528\u6216\u662f\u5426\u5b58\u5728\uff01", (Object[])new Object[]{entity.getBudgetCode()});
            BigDecimal accumulatedAvailableBalance = ((MonthBudgetVo)budgetVoMap.get(entity.getBudgetCode())).getAccumulatedAvailableBalance();
            if (Objects.isNull(accumulatedAvailableBalance)) {
                accumulatedAvailableBalance = BigDecimal.ZERO;
            }
            Validate.isTrue((entity.getExamineCircularAmount().abs().compareTo(accumulatedAvailableBalance) <= 0 ? 1 : 0) != 0, (String)"[%s]\u8003\u6838\u6263\u6b3e\u91d1\u989d[%s]\u5927\u4e8e\u5f53\u524d\u9884\u7b97\u7d2f\u8ba1\u53ef\u7528\u4f59\u989d[%s]\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[]{entity.getBudgetCode(), entity.getExamineCircularAmount().abs(), accumulatedAvailableBalance});
        }
        List<String> ids = entities.stream().map(UuidEntity::getId).collect(Collectors.toList());
        ProcessBusinessDto processBusiness = submitDto.getProcessBusiness();
        processBusiness.setBusinessFormJson(JsonUtils.obj2JsonString((Object)submitDto));
        processBusiness.setBusinessCode("examine_circular_process");
        processBusiness.setBusinessNoList(ids);
        processBusiness.setBusinessNo(UUID.randomUUID().toString().replace("-", ""));
        ProcessBusinessVo processBusinessVo = this.processBatchBusinessService.processStart(processBusiness);
        this.tpmExamineCircularEntityRepository.updateProcessStatusBatchByIds(ids, ProcessStatusEnum.COMMIT, processBusinessVo.getProcessNo(), processBusinessVo.getProcessTitle());
        return respVo;
    }

    @Transactional(rollbackFor={Exception.class})
    public void onProcessComplete(ProcessStatusDto dto) {
        List<TpmExamineCircularEntity> originalList = this.tpmExamineCircularEntityMapper.findByIdList(dto.getBusinessNoList(), TenantUtils.getTenantCode());
        log.info("\u8003\u6838\u5ba1\u6279\u56de\u8c03\uff1a\u5165\u53c2===\u300b{}\uff0c\u67e5\u8be2\u6570\u636e\u6570\u91cf\uff1a{}", (Object)JSONObject.toJSONString((Object)dto), (Object)originalList.size());
        List invalidList = originalList.stream().filter(o -> DelFlagStatusEnum.DELETE.getCode().equals(o.getDelFlag()) || EnableStatusEnum.DISABLE.getCode().equals(o.getEnableStatus())).collect(Collectors.toList());
        log.info("\u8003\u6838\u5ba1\u6279\u56de\u8c03\uff1a\u8fc7\u6ee4\u540e\u6570\u91cf\uff1a{}", (Object)invalidList.size());
        if (!CollectionUtils.isEmpty(invalidList)) {
            throw new UnsupportedOperationException("\u5b58\u5728\u5df2\u5220\u9664\u6216\u5df2\u7981\u7528\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
        }
        String processStatus = dto.getProcessStatus();
        this.tpmExamineCircularEntityMapper.updateProcessStatusByCode(processStatus, dto.getBusinessNoList(), new Date());
        Collection tpmExamineCircularRespVos = this.nebulaToolkitService.copyCollectionByWhiteList(originalList, TpmExamineCircularEntity.class, TpmExamineCircularRespVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.budgetChange(Lists.newArrayList((Iterable)tpmExamineCircularRespVos));
    }

    public Map<String, TpmExamineCircularProductSplitCalRespVo> calSplitMap(TpmExamineCircularDto dto, String cacheKey) {
        Validate.notBlank((CharSequence)cacheKey, (String)"\u9875\u9762\u7f13\u5b58[cacheKey]\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        cacheKey = "TPM:EXAMINE_SALES_DATE_SPLIT:" + cacheKey;
        if (CollectionUtils.isEmpty((Collection)dto.getProductSplitList())) {
            return Maps.newHashMap();
        }
        HashMap<String, TpmExamineCircularProductSplitCalRespVo> resultMap = new HashMap<String, TpmExamineCircularProductSplitCalRespVo>();
        int index = 1;
        HashSet<String> productCodeSet = new HashSet<String>();
        for (TpmExamineCircularProductSplitDto v3 : dto.getProductSplitList()) {
            Validate.notBlank((CharSequence)v3.getProductCode(), (String)"\u7b2c%s\u884c\uff0c\u4ea7\u54c1\u7f16\u7801\u4e3a\u7a7a\uff01", (Object[])new Object[]{index++});
            productCodeSet.add(v3.getProductCode());
            resultMap.put(v3.getProductCode(), (TpmExamineCircularProductSplitCalRespVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)v3, TpmExamineCircularProductSplitCalRespVo.class, HashSet.class, ArrayList.class, new String[0]));
        }
        BigDecimal examineCircularAmount = dto.getExamineCircularAmount();
        if (Objects.isNull(examineCircularAmount) || BigDecimal.ZERO.compareTo(examineCircularAmount) == 0) {
            resultMap.values().forEach(v -> v.setSplitAmount(BigDecimal.ZERO));
            return resultMap;
        }
        Object o = this.redisService.get(cacheKey);
        if (Objects.isNull(o) && StringUtils.isNotEmpty((CharSequence)dto.getExamineCircularCode())) {
            o = this.tpmExamineCircularUtil.buildCacheById(dto.getExamineCircularCode(), dto.getCacheKey());
        }
        Validate.notNull((Object)o, (String)"\u8bf7\u9009\u62e9\u9500\u91cf\u5206\u644a\u6570\u636e\uff01", (Object[])new Object[0]);
        Map cacheMap = (Map)JSONObject.parseObject((String)o.toString(), HashMap.class);
        ArrayList filterList = Lists.newArrayList();
        cacheMap.forEach((k, v) -> {
            if (!productCodeSet.contains(k)) {
                return;
            }
            TpmExamineCircularProductSplitCalRespVo respVo = new TpmExamineCircularProductSplitCalRespVo();
            respVo.setProductCode(k);
            if (Objects.nonNull(v)) {
                respVo.setSplitAmount(new BigDecimal(v.toString()));
            } else {
                respVo.setSplitAmount(BigDecimal.ZERO);
            }
            filterList.add(respVo);
        });
        BigDecimal totalAmount = filterList.stream().map(TpmExamineCircularProductSplitCalRespVo::getSplitAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (BigDecimal.ZERO.compareTo(totalAmount) == 0) {
            return resultMap;
        }
        BigDecimal maxRate = BigDecimal.ZERO;
        int maxIndex = 0;
        index = 0;
        for (TpmExamineCircularProductSplitCalRespVo v4 : filterList) {
            if (Objects.isNull(v4.getSplitAmount())) {
                v4.setRate(BigDecimal.ZERO);
            } else {
                v4.setRate(v4.getSplitAmount().divide(totalAmount, 4, 1));
            }
            if (maxRate.compareTo(v4.getRate()) < 0) {
                maxRate = v4.getRate();
                maxIndex = index;
            }
            v4.setSplitAmount(examineCircularAmount.multiply(v4.getRate()).setScale(2, 1));
            ++index;
        }
        BigDecimal splitTotalAmount = filterList.stream().map(TpmExamineCircularProductSplitCalRespVo::getSplitAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        ((TpmExamineCircularProductSplitCalRespVo)filterList.get(maxIndex)).setSplitAmount(((TpmExamineCircularProductSplitCalRespVo)filterList.get(maxIndex)).getSplitAmount().add(examineCircularAmount.subtract(splitTotalAmount)));
        Map<String, BigDecimal> amountMap = filterList.stream().collect(Collectors.toMap(TpmExamineCircularProductSplitCalRespVo::getProductCode, TpmExamineCircularProductSplitCalRespVo::getSplitAmount, (v1, v2) -> v2));
        resultMap.forEach((k, v) -> v.setSplitAmount(amountMap.getOrDefault(k, BigDecimal.ZERO)));
        return resultMap;
    }

    public FeePoolQueryVo feePoolQueryMain(List<TpmExamineCircularRespVo> auditCustomerDetailCollectionList, Map<String, CustomerVo> customerVoMap) {
        ArrayList<FeePoolQueryDto.Item1> item1List = new ArrayList<FeePoolQueryDto.Item1>();
        for (TpmExamineCircularRespVo auditCustomerDetailCollection : auditCustomerDetailCollectionList) {
            CustomerVo customerVo = customerVoMap.get(auditCustomerDetailCollection.getCustomerCode());
            if (customerVo == null) continue;
            FeePoolQueryDto.Item1 item1 = new FeePoolQueryDto.Item1();
            item1.setKUNNR(customerVo.getErpCode());
            item1.setSPART(auditCustomerDetailCollection.getBusinessFormatCode());
            item1.setVTWEG(customerVo.getCustomerChannelCode());
            item1.setVKBUR(customerVo.getSalesRegionErpCode());
            item1.setVKORG(customerVo.getSalesInstitutionErpCode());
            item1List.add(item1);
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(item1List)) {
            return null;
        }
        FeePoolQueryDto feePoolQueryDto = new FeePoolQueryDto();
        FeePoolQueryDto.MessageHeader messageHeader = new FeePoolQueryDto.MessageHeader();
        messageHeader.setMESSAGEID(UuidCrmUtil.general());
        messageHeader.setINTERFACE("SI_TPM90_POOLCHECK_HQ_SYN_OUT");
        messageHeader.setSENDER("TPM");
        messageHeader.setSENDTIME(String.valueOf(System.currentTimeMillis()));
        messageHeader.setRECEIVER("ECC");
        feePoolQueryDto.setMessageHeader(messageHeader);
        feePoolQueryDto.setITEM1(item1List);
        FeePoolQueryVo feePoolQueryVo = this.sapSdApiService.feePoolQuery(feePoolQueryDto);
        return feePoolQueryVo;
    }

    public FeePoolQuerySonCompanyVo feePoolSonCompany(List<TpmExamineCircularRespVo> auditCustomerDetailCollectionList, Map<String, CustomerVo> customerVoMap) {
        FeePoolQuerySonCompanyDto feePoolQuerySonCompanyDto = new FeePoolQuerySonCompanyDto();
        ArrayList<FeePoolQuerySonCompanyDto.Item1> item1List = new ArrayList<FeePoolQuerySonCompanyDto.Item1>();
        for (TpmExamineCircularRespVo one : auditCustomerDetailCollectionList) {
            CustomerVo customerVo = customerVoMap.get(one.getCustomerCode());
            if (customerVo == null) continue;
            FeePoolQuerySonCompanyDto.Item1 item1 = new FeePoolQuerySonCompanyDto.Item1();
            item1.setKUNNR(customerVo.getErpCode());
            item1.setSPART(one.getBusinessFormatCode());
            item1.setVTWEG(customerVo.getCustomerChannelCode());
            item1.setVKBUR(customerVo.getSalesRegionErpCode());
            item1.setVKORG(customerVo.getSalesInstitutionErpCode());
            item1List.add(item1);
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(item1List)) {
            return null;
        }
        FeePoolQuerySonCompanyDto.MessageHeader messageHeader = new FeePoolQuerySonCompanyDto.MessageHeader();
        messageHeader.setMESSAGEID(UuidCrmUtil.general());
        messageHeader.setINTERFACE("SI_TPM100_FYCYECX_FGS_SYN_OUT");
        messageHeader.setRECEIVER("ECC");
        messageHeader.setSENDER("TPM");
        messageHeader.setSENDTIME(String.valueOf(System.currentTimeMillis()));
        feePoolQuerySonCompanyDto.setMessageHeader(messageHeader);
        feePoolQuerySonCompanyDto.setITEM1(item1List);
        log.info("\u5206\u5b50\u516c\u53f8\u67e5\u8be2\u8d39\u7528\u6c60\u5f00\u59cb \u53c2\u6570\u3010{}\u3011", (Object)JSON.toJSONString((Object)feePoolQuerySonCompanyDto));
        FeePoolQuerySonCompanyVo feePoolQuerySonCompanyVo = this.sapSdApiService.feePoolQuerySonCompany(feePoolQuerySonCompanyDto);
        log.info("\u5206\u5b50\u516c\u53f8\u67e5\u8be2\u8d39\u7528\u6c60\u7ed3\u675f \u54cd\u5e94 \u3010{}\u3011", (Object)JSON.toJSONString((Object)feePoolQuerySonCompanyVo));
        return feePoolQuerySonCompanyVo;
    }

    public void feelPoolBalanceValidate(List<TpmExamineCircularRespVo> tpmExamineCircularRespVos, TpmExamineCircularRespVo respVo) {
        String businessUnitCode;
        log.info("\u8003\u6838\u6263\u6b3e\u8d39\u7528\u6c60\u4f59\u989d\u6821\u9a8c\u3010{}\u3011", (Object)JSON.toJSONString(tpmExamineCircularRespVos));
        Set customerCodes = tpmExamineCircularRespVos.stream().map(TpmExamineCircularRespVo::getCustomerCode).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
        HashMap<String, CustomerVo> customerVoMap = new HashMap();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(customerCodes)) {
            List customerVoList = this.customerVoService.findBaseByCustomerCodes(new ArrayList(customerCodes));
            customerVoMap = customerVoList.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
        }
        if (BusinessUnitEnum.isDefaultBusinessUnit((String)(businessUnitCode = tpmExamineCircularRespVos.get(0).getBusinessUnitCode()))) {
            businessUnitCode = BusinessUnitEnum.HEADQUARTERS.getCode();
        }
        BusinessUnitEnum businessUnitEnum = BusinessUnitEnum.codeToEnum((String)businessUnitCode);
        switch (businessUnitEnum) {
            case HEADQUARTERS: 
            case ONLINE: {
                FeePoolQueryVo feePoolQueryVo = this.feePoolQueryMain(tpmExamineCircularRespVos, customerVoMap);
                log.info("\u603b\u516c\u53f8\u8d39\u7528\u6c60\u67e5\u8be2\u3010{}\u3011", (Object)JSON.toJSONString((Object)feePoolQueryVo));
                for (TpmExamineCircularRespVo one : tpmExamineCircularRespVos) {
                    CustomerVo customerVo = (CustomerVo)customerVoMap.get(one.getCustomerCode());
                    BigDecimal feePoolBalance = this.findCustomerFeePool(customerVo, feePoolQueryVo);
                    if (one.getExamineCircularAmount().add(feePoolBalance).compareTo(BigDecimal.ZERO) >= 0) continue;
                    if (StringUtils.equals((CharSequence)BusinessUnitEnum.ONLINE.getCode(), (CharSequence)businessUnitEnum.getCode())) {
                        Validate.isTrue((one.getExamineCircularAmount().add(feePoolBalance).compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u5ba2\u6237\u7f16\u7801\u3010%s\u3011\uff0c\u5ba2\u6237\u540d\u79f0\u3010%s\u3011\u603b\u516c\u53f8\u8d39\u7528\u6c60\u4f59\u989d\u548c\u672c\u6b21\u4e0a\u8d26\u91d1\u989d\u548c\u5c0f\u4e8e0\uff0c\u4e0d\u80fd\u4e0a\u8d26\uff0c\u8d26\u6237\u4f59\u989d\u3010%s\u3011", (Object[])new Object[]{one.getCustomerCode(), one.getCustomerName(), feePoolBalance.toPlainString()});
                    }
                    respVo.setIsBalanceEnough(Boolean.FALSE);
                    respVo.setFeePoolBalance(feePoolBalance);
                }
                break;
            }
            case SON_COMPANY: 
            case VERTICAL: {
                FeePoolQuerySonCompanyVo sonCompanyVo = this.feePoolSonCompany(tpmExamineCircularRespVos, customerVoMap);
                log.info("\u5206\u5b50\u516c\u53f8\u8d39\u7528\u6c60\u67e5\u8be2\u3010{}\u3011", (Object)JSON.toJSONString((Object)sonCompanyVo));
                for (TpmExamineCircularRespVo one : tpmExamineCircularRespVos) {
                    CustomerVo customerVo = (CustomerVo)customerVoMap.get(one.getCustomerCode());
                    BigDecimal feePoolBalance = this.findCustomerFeePoolSonCompany(customerVo, sonCompanyVo);
                    if (one.getExamineCircularAmount().add(feePoolBalance).compareTo(BigDecimal.ZERO) >= 0) continue;
                    respVo.setIsBalanceEnough(Boolean.FALSE);
                    respVo.setFeePoolBalance(feePoolBalance);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7c7b\u578b\u3010" + businessUnitEnum + "\u3011\uff0c\u8bf7\u68c0\u67e5");
            }
        }
    }

    @Transactional
    public void examineCircularHeadCallback(AuditCostPostingCallbackDto dto) {
        log.info("\u8003\u6838\u901a\u62a5\u7ba1\u7406 \u603b\u516c\u53f8\u56de\u8c03 \u3010{}\u3011", (Object)JSON.toJSONString((Object)dto));
        List data = dto.getData();
        if (CollectionUtil.isNotEmpty((Collection)data)) {
            Map map = data.stream().collect(Collectors.toMap(AuditCostPostingCallbackDataDto::getCamp_id, Function.identity(), (o, n) -> o));
            Set examineCircularCodeSet = data.stream().map(AuditCostPostingCallbackDataDto::getCamp_id).collect(Collectors.toSet());
            List<TpmExamineCircularProductSplitEntity> detailList = this.tpmExamineCircularProductSplitEntityMapper.findByCodeCodeList(new ArrayList<String>(examineCircularCodeSet), TenantUtils.getTenantCode());
            List<TpmExamineCircularEntity> examineCirulars = this.tpmExamineCircularEntityRepository.findByCodes(new ArrayList<String>(examineCircularCodeSet));
            if (CollectionUtils.isEmpty(detailList) && CollectionUtils.isEmpty(examineCirulars)) {
                return;
            }
            Date curDate = new Date();
            if (CollectionUtil.isNotEmpty(detailList)) {
                int failCount = 0;
                ArrayList<TpmExamineCircularProductSplitEntity> listUpdate = new ArrayList<TpmExamineCircularProductSplitEntity>();
                for (TpmExamineCircularProductSplitEntity productSplitEntity : detailList) {
                    TpmExamineCircularProductSplitEntity entity = new TpmExamineCircularProductSplitEntity();
                    entity.setId(productSplitEntity.getId());
                    AuditCostPostingCallbackDataDto auditCostPostingCallbackDataDto = (AuditCostPostingCallbackDataDto)map.get(productSplitEntity.getExamineCircularCode());
                    if (SucessOrFailEnum.SUCESS.getCode().equals(auditCostPostingCallbackDataDto.getFlag())) {
                        entity.setSplitCommitStatus(CommitStatusEnum.COMMIT_SUCCESS.getCode());
                        entity.setSplitCommitSuccessTime(curDate);
                    } else {
                        entity.setSplitCommitStatus(CommitStatusEnum.COMMIT_FAIL.getCode());
                        ++failCount;
                    }
                    listUpdate.add(entity);
                }
                this.tpmExamineCircularProductSplitEntityRepository.updateBatchById(listUpdate);
                TpmExamineCircularEntity one = (TpmExamineCircularEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.tpmExamineCircularEntityRepository.lambdaQuery().eq(TpmExamineCircularEntity::getExamineCircularCode, (Object)detailList.get(0).getExamineCircularCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).one();
                if (failCount > 0 && failCount < data.size()) {
                    one.setSapTransferCommitStatus(CommitStatusEnum.PART_SUCCESS.getCode());
                    one.setSapTransferCommitSuccessTime(curDate);
                } else if (failCount == data.size()) {
                    one.setSapTransferCommitStatus(CommitStatusEnum.COMMIT_FAIL.getCode());
                    one.setSapTransferCommitSuccessTime(curDate);
                } else {
                    one.setSapTransferCommitStatus(CommitStatusEnum.COMMIT_SUCCESS.getCode());
                    one.setSapTransferCommitSuccessTime(curDate);
                }
                this.tpmExamineCircularEntityMapper.updateById(one);
                return;
            }
            if (CollectionUtil.isNotEmpty(examineCirulars)) {
                for (TpmExamineCircularEntity entity : examineCirulars) {
                    AuditCostPostingCallbackDataDto auditCostPostingCallbackDataDto = (AuditCostPostingCallbackDataDto)map.get(entity.getExamineCircularCode());
                    if (SucessOrFailEnum.SUCESS.getCode().equals(auditCostPostingCallbackDataDto.getFlag())) {
                        entity.setSapTransferCommitStatus(CommitStatusEnum.COMMIT_SUCCESS.getCode());
                        entity.setSapTransferCommitSuccessTime(curDate);
                    } else {
                        entity.setSapTransferCommitStatus(CommitStatusEnum.COMMIT_FAIL.getCode());
                    }
                    this.tpmExamineCircularEntityMapper.updateById(entity);
                }
            }
        }
    }

    @Transactional
    public void examineCircularSonCallback(SonAuditCostPostingCallbackDto dto) {
        log.info("\u8003\u6838\u901a\u62a5\u7ba1\u7406 \u5206\u5b50\u516c\u53f8\u56de\u8c03 \u3010{}\u3011", (Object)JSON.toJSONString((Object)dto));
        List data = dto.getData();
        if (CollectionUtil.isNotEmpty((Collection)data)) {
            String zftpmhxd = ((SonAuditCostPostingCallbackDataDto)data.get(0)).getZftpmhxd();
            Map map = data.stream().collect(Collectors.toMap(SonAuditCostPostingCallbackDataDto::getZftpmhxd, Function.identity(), (o, n) -> n));
            Set zftpmhxdSet = data.stream().map(SonAuditCostPostingCallbackDataDto::getZftpmhxd).collect(Collectors.toSet());
            List<TpmExamineCircularProductSplitEntity> detailList = ((TpmExamineCircularProductSplitEntityMapper)this.tpmExamineCircularProductSplitEntityRepository.getBaseMapper()).findByDetailCodeList(new ArrayList<String>(zftpmhxdSet), TenantUtils.getTenantCode());
            List<TpmExamineCircularEntity> examineCirculars = this.tpmExamineCircularEntityRepository.findByCodes(new ArrayList<String>(zftpmhxdSet));
            Date curDate = new Date();
            if (CollectionUtil.isNotEmpty(detailList)) {
                ArrayList<TpmExamineCircularProductSplitEntity> listUpdate = new ArrayList<TpmExamineCircularProductSplitEntity>();
                int failCount = 0;
                for (TpmExamineCircularProductSplitEntity detailEntity : detailList) {
                    TpmExamineCircularProductSplitEntity entity = new TpmExamineCircularProductSplitEntity();
                    entity.setId(detailEntity.getId());
                    SonAuditCostPostingCallbackDataDto auditCostPostingCallbackDataDto = (SonAuditCostPostingCallbackDataDto)map.get(detailEntity.getSplitDetailCode());
                    if (SucessOrFailEnum.SUCESS.getCode().equals(auditCostPostingCallbackDataDto.getFlag())) {
                        entity.setSplitCommitStatus(CommitStatusEnum.COMMIT_SUCCESS.getCode());
                        entity.setSplitCommitSuccessTime(curDate);
                    } else {
                        entity.setSplitCommitStatus(CommitStatusEnum.COMMIT_FAIL.getCode());
                        ++failCount;
                    }
                    listUpdate.add(entity);
                }
                this.tpmExamineCircularProductSplitEntityRepository.updateBatchById(listUpdate);
                TpmExamineCircularEntity one = (TpmExamineCircularEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.tpmExamineCircularEntityRepository.lambdaQuery().eq(TpmExamineCircularEntity::getExamineCircularCode, (Object)detailList.get(0).getExamineCircularCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).one();
                if (failCount > 0 && failCount < data.size()) {
                    one.setSapTransferCommitStatus(CommitStatusEnum.PART_SUCCESS.getCode());
                    one.setSapTransferCommitSuccessTime(curDate);
                } else if (failCount == data.size()) {
                    one.setSapTransferCommitMessage(CommitStatusEnum.COMMIT_FAIL.getCode());
                } else {
                    one.setSapTransferCommitStatus(CommitStatusEnum.COMMIT_SUCCESS.getCode());
                    one.setSapTransferCommitSuccessTime(curDate);
                }
                this.tpmExamineCircularEntityMapper.updateById(one);
                return;
            }
            if (CollectionUtil.isNotEmpty(examineCirculars)) {
                for (TpmExamineCircularEntity entity : examineCirculars) {
                    SonAuditCostPostingCallbackDataDto auditCostPostingCallbackDataDto = (SonAuditCostPostingCallbackDataDto)map.get(entity.getExamineCircularCode());
                    if (SucessOrFailEnum.SUCESS.getCode().equals(auditCostPostingCallbackDataDto.getFlag())) {
                        entity.setSapTransferCommitStatus(CommitStatusEnum.COMMIT_SUCCESS.getCode());
                        entity.setSapTransferCommitSuccessTime(curDate);
                    } else {
                        entity.setSapTransferCommitStatus(CommitStatusEnum.COMMIT_FAIL.getCode());
                    }
                    this.tpmExamineCircularEntityMapper.updateById(entity);
                }
            }
        }
    }

    public Map<String, String> pushEventPrepaymentToFeelPoolHandle(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtil.isNotEmpty(ids), (String)"\u8bf7\u9009\u62e9\u6570\u636e", (Object[])new Object[0]);
        List<TpmExamineCircularEntity> tpmExamineCircularEntities = this.tpmExamineCircularEntityMapper.findByIdList(ids, TenantUtils.getTenantCode());
        Validate.isTrue((boolean)CollectionUtil.isNotEmpty(tpmExamineCircularEntities), (String)"\u6570\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        tpmExamineCircularEntities.forEach(item -> {
            if (CommitStatusEnum.COMMIT_SUCCESS.getCode().equals(item.getSapTransferCommitStatus())) {
                throw new RuntimeException("\u8003\u6838\u901a\u62a5\u3010" + item.getExamineCircularCode() + "\u3011\u4e3a\u4e0a\u8d26\u6210\u529f\uff0c\u4e0d\u80fd\u6267\u884c");
            }
        });
        HashMap<String, String> failMap = new HashMap<String, String>();
        ArrayList<String> codeList = new ArrayList<String>();
        for (TpmExamineCircularEntity entity : tpmExamineCircularEntities) {
            if (!StringUtils.equals((CharSequence)ProcessStatusEnum.PASS.getDictCode(), (CharSequence)entity.getProcessStatus())) {
                failMap.put(entity.getExamineCircularCode(), "\u672a\u5ba1\u6279\u901a\u8fc7");
                continue;
            }
            codeList.add(entity.getExamineCircularCode());
        }
        if (CollectionUtil.isNotEmpty(codeList)) {
            this.tpmExamineCircularPushService.feePoolPushToSapSync(codeList);
        }
        return failMap;
    }

    @Transactional
    public void budgetChange(List<TpmExamineCircularRespVo> examineCircularRespVos) {
        List<TpmExamineCircularRespVo> subRespVos = examineCircularRespVos.stream().filter(e -> StringUtils.equals((CharSequence)BusinessUnitEnum.SON_COMPANY.getCode(), (CharSequence)e.getBusinessUnitCode())).collect(Collectors.toList());
        List<TpmExamineCircularRespVo> otherRespVos = examineCircularRespVos.stream().filter(e -> !StringUtils.equals((CharSequence)BusinessUnitEnum.SON_COMPANY.getCode(), (CharSequence)e.getBusinessUnitCode())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(subRespVos)) {
            this.budgetSubForestChange(subRespVos);
        }
        if (CollectionUtil.isNotEmpty(otherRespVos)) {
            this.monthBudgetChange(otherRespVos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void monthBudgetChange(List<TpmExamineCircularRespVo> examineCircularRespVos) {
        List monthBudgetCodes = examineCircularRespVos.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getBudgetCode())).map(TpmExamineCircularRespVo::getBudgetCode).distinct().collect(Collectors.toList());
        Validate.notEmpty(monthBudgetCodes, (String)"\u64cd\u4f5c\u9884\u7b97\u7f16\u7801\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        boolean lock = this.monthBudgetLockService.lock(monthBudgetCodes, TimeUnit.SECONDS, 60);
        Validate.isTrue((boolean)lock, (String)"\u64cd\u4f5c\u6708\u5ea6\u9884\u7b97\u5931\u8d25\uff0c\u83b7\u53d6\u64cd\u4f5c\u9501\u5931\u8d25\uff01", (Object[])new Object[0]);
        try {
            ArrayList monthOperateList = Lists.newArrayList();
            HashMap<String, BigDecimal> monthOperateAmountMap = new HashMap<String, BigDecimal>();
            examineCircularRespVos.forEach(v -> {
                if (BigDecimal.ZERO.compareTo(v.getExamineCircularAmount()) == 0) {
                    log.info("\u8003\u6838\u5ba1\u6279\u56de\u8c03\uff1a\u8003\u6838\u7533\u8bf7\u3010{}\u3011\u7533\u8bf7\u91d1\u989d \u4e3a0\u4e0d\u8c03\u6574\u6708\u5ea6\u9884\u7b97", (Object)v.getExamineCircularCode());
                    return;
                }
                if (!StringUtils.equals((CharSequence)v.getRelationType(), (CharSequence)TpmExamineCircularRelationTypeEnum.BUDGET_RELATION.getCode()) && !StringUtils.equals((CharSequence)v.getRelationType(), (CharSequence)TpmExamineCircularRelationTypeEnum.FEE_POOL_RELATION_AND_BUDGET.getCode())) {
                    log.info("\u8003\u6838\u5ba1\u6279\u56de\u8c03\uff1a\u8003\u6838\u7533\u8bf7\u3010{}\u3011\u975e\u5173\u8054\u9884\u7b97", (Object)v.getExamineCircularCode());
                    return;
                }
                if (!StringUtils.equals((CharSequence)v.getBusinessUnitCode(), (CharSequence)BusinessUnitEnum.SON_COMPANY.getCode())) {
                    OperateMonthBudgetDto operateDto = new OperateMonthBudgetDto();
                    operateDto.setMonthBudgetCode(v.getBudgetCode());
                    operateDto.setBusinessCode(v.getExamineCircularCode());
                    if (BigDecimal.ZERO.compareTo(v.getExamineCircularAmount()) > 0) {
                        operateDto.setOperationType(BudgetOperationTypeEnum.EXAMINE_CIRCULAR_SUBTRACT.getCode());
                        monthOperateAmountMap.put(operateDto.getMonthBudgetCode(), monthOperateAmountMap.getOrDefault(operateDto.getMonthBudgetCode(), BigDecimal.ZERO).add(v.getExamineCircularAmount().abs()));
                    } else {
                        operateDto.setOperationType(BudgetOperationTypeEnum.EXAMINE_CIRCULAR_ADD.getCode());
                    }
                    operateDto.setOperationAmount(v.getExamineCircularAmount().abs());
                    monthOperateList.add(operateDto);
                }
            });
            log.info("\u8003\u6838\u5ba1\u6279\u56de\u8c03\uff1a\u6708\u5ea6\u9884\u7b97\u8c03\u6574\u6570\uff1a{}", (Object)monthOperateList.size());
            if (CollectionUtil.isNotEmpty((Collection)monthOperateList)) {
                if (monthOperateAmountMap.size() > 0) {
                    List monthBudgetVos = this.monthBudgetService.listByCodes((List)Lists.newArrayList(monthOperateAmountMap.keySet()));
                    Map<String, MonthBudgetVo> budgetVoMap = monthBudgetVos.stream().collect(Collectors.toMap(MonthBudgetVo::getMonthBudgetCode, v -> v));
                    monthOperateAmountMap.forEach((k, v) -> {
                        Validate.isTrue((boolean)budgetVoMap.containsKey(k), (String)"\u9884\u7b97\u64cd\u4f5c\u5931\u8d25\uff0c\u6708\u5ea6\u9884\u7b97[%s]\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u9884\u7b97\u662f\u5426\u542f\u7528\u6216\u662f\u5426\u5b58\u5728\uff01", (Object[])new Object[]{k});
                        BigDecimal accumulatedAvailableBalance = ((MonthBudgetVo)budgetVoMap.get(k)).getAccumulatedAvailableBalance();
                        if (Objects.isNull(accumulatedAvailableBalance)) {
                            accumulatedAvailableBalance = BigDecimal.ZERO;
                        }
                        Validate.isTrue((v.compareTo(accumulatedAvailableBalance) <= 0 ? 1 : 0) != 0, (String)"[%s]\u8003\u6838\u6263\u6b3e\u91d1\u989d[%s]\u5927\u4e8e\u5f53\u524d\u9884\u7b97\u7d2f\u8ba1\u53ef\u7528\u4f59\u989d[%s]\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[]{k, v, accumulatedAvailableBalance});
                    });
                }
                this.monthBudgetService.operateBudget((List)monthOperateList);
            }
        }
        finally {
            this.monthBudgetLockService.unLock(monthBudgetCodes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void subMonthBudgetChange(List<TpmExamineCircularRespVo> examineCircularRespVos) {
        List subMonthBudgetCodes = examineCircularRespVos.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getBudgetCode())).map(TpmExamineCircularRespVo::getBudgetCode).distinct().collect(Collectors.toList());
        Validate.notEmpty(subMonthBudgetCodes, (String)"\u64cd\u4f5c\u5206\u5b50\u6708\u5ea6\u9884\u7b97\u7f16\u7801\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        boolean lock = this.subComMonthBudgetLockService.lock(subMonthBudgetCodes, TimeUnit.SECONDS, 60);
        Validate.isTrue((boolean)lock, (String)"\u64cd\u4f5c\u5206\u5b50\u6708\u5ea6\u9884\u7b97\u5931\u8d25\uff0c\u83b7\u53d6\u64cd\u4f5c\u9501\u5931\u8d25\uff01", (Object[])new Object[0]);
        try {
            ArrayList subOperateList = Lists.newArrayList();
            HashMap<String, BigDecimal> subOperateAmountMap = new HashMap<String, BigDecimal>();
            examineCircularRespVos.forEach(v -> {
                OperateMonthBudgetDto operateDto;
                if (BigDecimal.ZERO.compareTo(v.getExamineCircularAmount()) == 0) {
                    log.info("\u8003\u6838\u5ba1\u6279\u56de\u8c03\uff1a\u8003\u6838\u7533\u8bf7\u3010{}\u3011\u7533\u8bf7\u91d1\u989d \u4e3a0\u4e0d\u8c03\u6574\u5206\u5b50\u6708\u5ea6\u9884\u7b97", (Object)v.getExamineCircularCode());
                    return;
                }
                if (!StringUtils.equals((CharSequence)v.getRelationType(), (CharSequence)TpmExamineCircularRelationTypeEnum.BUDGET_RELATION.getCode())) {
                    log.info("\u8003\u6838\u5ba1\u6279\u56de\u8c03\uff1a\u8003\u6838\u7533\u8bf7\u3010{}\u3011\u975e\u5173\u8054\u9884\u7b97", (Object)v.getExamineCircularCode());
                    return;
                }
                if (StringUtils.equals((CharSequence)v.getBusinessUnitCode(), (CharSequence)BusinessUnitEnum.SON_COMPANY.getCode())) {
                    operateDto = new OperateMonthBudgetDto();
                    operateDto.setMonthBudgetCode(v.getBudgetCode());
                    operateDto.setBusinessCode(v.getExamineCircularCode());
                    if (BigDecimal.ZERO.compareTo(v.getExamineCircularAmount()) > 0) {
                        operateDto.setOperationType(BudgetOperationTypeEnum.EXAMINE_CIRCULAR_SUBTRACT.getCode());
                        subOperateAmountMap.put(operateDto.getMonthBudgetCode(), subOperateAmountMap.getOrDefault(operateDto.getMonthBudgetCode(), BigDecimal.ZERO).add(v.getExamineCircularAmount().abs()));
                    } else {
                        operateDto.setOperationType(BudgetOperationTypeEnum.EXAMINE_CIRCULAR_ADD.getCode());
                    }
                } else {
                    throw new RuntimeException("\u8003\u6838\u5ba1\u6279\u56de\u8c03\uff1a\u8003\u6838\u7533\u8bf7\u3010" + v.getExamineCircularCode() + "\u3011\u8c03\u6574\u5206\u5b50\u6708\u5ea6\u9884\u7b97\uff0c\u5f53\u524d\u4e1a\u52a1\u5355\u5143\u672a\u5f00\u653e\u6b64\u529f\u80fd\uff01");
                }
                operateDto.setOperationAmount(v.getExamineCircularAmount().abs());
                subOperateList.add(operateDto);
            });
            log.info("\u8003\u6838\u5ba1\u6279\u56de\u8c03\uff1a\u5206\u5b50\u6708\u5ea6\u9884\u7b97\u8c03\u6574\u6570\uff1a{}", (Object)subOperateList.size());
            if (CollectionUtil.isNotEmpty((Collection)subOperateList)) {
                if (subOperateAmountMap.size() > 0) {
                    List subBudgetVos = this.subComMonthBudgetService.listByBudgetCodeList((List)Lists.newArrayList(subOperateAmountMap.keySet()));
                    Map<String, SubComMonthBudgetVo> budgetVoMap = subBudgetVos.stream().collect(Collectors.toMap(SubComMonthBudgetVo::getMonthBudgetCode, v -> v));
                    subOperateAmountMap.forEach((k, v) -> {
                        Validate.isTrue((boolean)budgetVoMap.containsKey(k), (String)"\u9884\u7b97\u64cd\u4f5c\u5931\u8d25\uff0c\u5206\u5b50\u6708\u5ea6\u9884\u7b97[%s]\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u9884\u7b97\u662f\u5426\u542f\u7528\u6216\u662f\u5426\u5b58\u5728\uff01", (Object[])new Object[]{k});
                        BigDecimal currentBalanceAmount = ((SubComMonthBudgetVo)budgetVoMap.get(k)).getCurrentBalanceAmount();
                        if (Objects.isNull(currentBalanceAmount)) {
                            currentBalanceAmount = BigDecimal.ZERO;
                        }
                        Validate.isTrue((v.compareTo(currentBalanceAmount) <= 0 ? 1 : 0) != 0, (String)"[%s]\u8003\u6838\u6263\u6b3e\u91d1\u989d[%s]\u5927\u4e8e\u5f53\u524d\u9884\u7b97\u672c\u671f\u7ed3\u4f59\u91d1\u989d[%s]\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[]{k, v, currentBalanceAmount});
                    });
                }
                this.subComMonthBudgetService.operateBudget((List)subOperateList);
            }
        }
        finally {
            this.subComMonthBudgetLockService.unlock(subMonthBudgetCodes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void budgetSubForestChange(List<TpmExamineCircularRespVo> examineCircularRespVos) {
        List budgetForecastCodes = examineCircularRespVos.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getBudgetCode())).map(TpmExamineCircularRespVo::getBudgetCode).distinct().collect(Collectors.toList());
        Validate.notEmpty(budgetForecastCodes, (String)"\u64cd\u4f5c\u5206\u5b50\u9884\u7b97\u9884\u6d4b\uff1a\u9884\u7b97\u7f16\u7801\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        boolean lock = this.subComBudgetForecastService.lock(budgetForecastCodes, TimeUnit.SECONDS, 60);
        Validate.isTrue((boolean)lock, (String)"\u64cd\u4f5c\u5206\u5b50\u9884\u7b97\u9884\u6d4b\u5931\u8d25\uff0c\u83b7\u53d6\u64cd\u4f5c\u9501\u5931\u8d25\uff01", (Object[])new Object[0]);
        try {
            ArrayList subOperateList = Lists.newArrayList();
            HashMap<String, BigDecimal> subOperateAmountMap = new HashMap<String, BigDecimal>();
            examineCircularRespVos.forEach(v -> {
                SubComBudgetForecastDetailDto operateDto;
                if (BigDecimal.ZERO.compareTo(v.getExamineCircularAmount()) == 0) {
                    log.info("\u8003\u6838\u5ba1\u6279\u56de\u8c03\uff1a\u8003\u6838\u7533\u8bf7\u3010{}\u3011\u7533\u8bf7\u91d1\u989d \u4e3a0\u4e0d\u8c03\u6574\u5206\u5b50\u9884\u7b97\u9884\u6d4b", (Object)v.getExamineCircularCode());
                    return;
                }
                if (!StringUtils.equals((CharSequence)v.getRelationType(), (CharSequence)TpmExamineCircularRelationTypeEnum.BUDGET_RELATION.getCode())) {
                    log.info("\u8003\u6838\u5ba1\u6279\u56de\u8c03\uff1a\u8003\u6838\u7533\u8bf7\u3010{}\u3011\u975e\u5173\u8054\u9884\u7b97", (Object)v.getExamineCircularCode());
                    return;
                }
                if (StringUtils.equals((CharSequence)v.getBusinessUnitCode(), (CharSequence)BusinessUnitEnum.SON_COMPANY.getCode())) {
                    operateDto = new SubComBudgetForecastDetailDto();
                    operateDto.setBudgetForecastCode(v.getBudgetCode());
                    operateDto.setBusinessCode(v.getExamineCircularCode());
                    if (BigDecimal.ZERO.compareTo(v.getExamineCircularAmount()) > 0) {
                        operateDto.setOperationType(BudgetOperationTypeEnum.EXAMINE_CIRCULAR_SUBTRACT.getCode());
                        subOperateAmountMap.put(operateDto.getBudgetForecastCode(), subOperateAmountMap.getOrDefault(operateDto.getBudgetForecastCode(), BigDecimal.ZERO).add(v.getExamineCircularAmount().abs()));
                    } else {
                        operateDto.setOperationType(BudgetOperationTypeEnum.EXAMINE_CIRCULAR_ADD.getCode());
                    }
                } else {
                    throw new RuntimeException("\u8003\u6838\u5ba1\u6279\u56de\u8c03\uff1a\u8003\u6838\u7533\u8bf7\u3010" + v.getExamineCircularCode() + "\u3011\u8c03\u6574\u5206\u5b50\u9884\u7b97\u9884\u6d4b\uff0c\u5f53\u524d\u4e1a\u52a1\u5355\u5143\u672a\u5f00\u653e\u6b64\u529f\u80fd\uff01");
                }
                operateDto.setCurOperationAmount(v.getExamineCircularAmount().abs());
                subOperateList.add(operateDto);
            });
            log.info("\u8003\u6838\u5ba1\u6279\u56de\u8c03\uff1a\u5206\u5b50\u9884\u7b97\u9884\u6d4b\u8c03\u6574\u6570\uff1a{}", (Object)subOperateList.size());
            if (CollectionUtil.isNotEmpty((Collection)subOperateList)) {
                if (subOperateAmountMap.size() > 0) {
                    List subBudgetVos = this.subComBudgetForecastService.listByBudgetForecastCodeList((List)Lists.newArrayList(subOperateAmountMap.keySet()));
                    Map<String, SubComBudgetForecastVo> budgetVoMap = subBudgetVos.stream().collect(Collectors.toMap(SubComBudgetForecastVo::getBudgetForecastCode, v -> v));
                    subOperateAmountMap.forEach((k, v) -> Validate.isTrue((boolean)budgetVoMap.containsKey(k), (String)"\u9884\u7b97\u64cd\u4f5c\u5931\u8d25\uff0c\u5206\u5b50\u9884\u7b97\u9884\u6d4b[%s]\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5206\u5b50\u9884\u7b97\u9884\u6d4b\u662f\u5426\u542f\u7528\u6216\u662f\u5426\u5b58\u5728\uff01", (Object[])new Object[]{k}));
                }
                this.subComBudgetForecastService.operationBudgetForecast((List)subOperateList);
            }
        }
        finally {
            this.subComBudgetForecastService.unLock(budgetForecastCodes);
        }
    }

    public Map<String, BigDecimal> statisAssessDeduction(SurplusFeePoolBalanceAssessedAmountStatisticsDto dto) {
        if (Objects.isNull(dto.getFeeYearMonth()) || StringUtils.isBlank((CharSequence)dto.getBusinessFormatCode()) || StringUtils.isBlank((CharSequence)dto.getBusinessUnitCode())) {
            return Maps.newHashMap();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        List<SurplusFeePoolBalanceAssessedAmountStatisticsVo> list = this.tpmExamineCircularEntityRepository.statisAssessDeduction(dto);
        if (CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        return list.stream().collect(Collectors.toMap(SurplusFeePoolBalanceAssessedAmountStatisticsVo::getSplicingCode, SurplusFeePoolBalanceAssessedAmountStatisticsVo::getSplitAmount));
    }

    public void relationPrepaymentImportSave(List<TpmExamineCircularDto> importList) {
        ArrayList<TpmExamineCircularEntity> insertList = new ArrayList<TpmExamineCircularEntity>();
        for (TpmExamineCircularDto dto : importList) {
            this.relationPrepaymentImportSaveValidation(dto);
            Date date = new Date();
            FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
            dto.setTenantCode(TenantUtils.getTenantCode());
            TpmExamineCircularEntity entity = (TpmExamineCircularEntity)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, TpmExamineCircularEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            entity.setExamineCircularCode((String)this.generateCodeService.generateCode("K", 1, Integer.valueOf(9), 0L, TimeUnit.DAYS).get(0));
            entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            entity.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
            entity.setApplyTime(date);
            entity.setApplyUserAccount(loginDetails.getUsername());
            entity.setApplyUserName(loginDetails.getRealName());
            entity.setRelationType(TpmExamineCircularRelationTypeEnum.BUDGET_RELATION.getCode());
            insertList.add(entity);
        }
        if (CollectionUtil.isNotEmpty(insertList)) {
            this.tpmExamineCircularEntityRepository.saveBatch(insertList);
            for (TpmExamineCircularEntity entity : insertList) {
                TpmExamineCircularLogDto logDto = new TpmExamineCircularLogDto();
                TpmExamineCircularDto newest = (TpmExamineCircularDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, TpmExamineCircularDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                logDto.setNewest(newest);
                this.tpmExamineCircularLogEventListener.onCreate(logDto);
            }
        }
    }

    public void relationFeePoolSalesVolumeImportSave(List<TpmExamineCircularDto> importList) {
        ArrayList<TpmExamineCircularEntity> insertList = new ArrayList<TpmExamineCircularEntity>();
        for (TpmExamineCircularDto dto : importList) {
            this.relationFeePoolSalesVolumeImportSaveValidation(dto);
            Date date = new Date();
            FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
            dto.setTenantCode(TenantUtils.getTenantCode());
            TpmExamineCircularEntity entity = (TpmExamineCircularEntity)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, TpmExamineCircularEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            entity.setExamineCircularCode((String)this.generateCodeService.generateCode("K", 1, Integer.valueOf(9), 0L, TimeUnit.DAYS).get(0));
            entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            entity.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
            entity.setApplyTime(date);
            entity.setApplyUserAccount(loginDetails.getUsername());
            entity.setApplyUserName(loginDetails.getRealName());
            entity.setRelationType(TpmExamineCircularRelationTypeEnum.FEE_POOL_RELATION.getCode());
            insertList.add(entity);
            if (CollectionUtils.isEmpty((Collection)dto.getProductSplitList())) {
                throw new UnsupportedOperationException("\u7f3a\u5c11\u4ea7\u54c1\u5206\u644a\u6570\u636e");
            }
            ArrayList<TpmExamineCircularProductSplitEntity> splitEntityList = new ArrayList<TpmExamineCircularProductSplitEntity>();
            for (TpmExamineCircularProductSplitDto splitDto : dto.getProductSplitList()) {
                TpmExamineCircularProductSplitEntity splitEntity = (TpmExamineCircularProductSplitEntity)this.nebulaToolkitService.copyObjectByWhiteList((Object)splitDto, TpmExamineCircularProductSplitEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                splitEntity.setId(UUID.randomUUID().toString().replaceAll("-", ""));
                splitEntity.setExamineCircularCode(entity.getExamineCircularCode());
                splitEntity.setCreateAccount(loginDetails.getUsername());
                splitEntity.setCreateName(loginDetails.getRealName());
                splitEntity.setModifyAccount(loginDetails.getUsername());
                splitEntity.setModifyName(loginDetails.getRealName());
                splitEntity.setCreateTime(date);
                splitEntity.setModifyTime(date);
                splitEntity.setTenantCode(TenantUtils.getTenantCode());
                splitEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                splitEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                String splitDetailCode = (String)this.generateCodeService.generateCode("KM", 1, Integer.valueOf(8), 0L, TimeUnit.DAYS).get(0);
                splitEntity.setSplitDetailCode(splitDetailCode);
                splitEntityList.add(splitEntity);
            }
            int pageSize = 500;
            int page = 0;
            while (page * pageSize < splitEntityList.size()) {
                if (page * pageSize + pageSize < splitEntityList.size()) {
                    this.tpmExamineCircularProductSplitEntityMapper.insertList(splitEntityList.subList(page * pageSize, (page + 1) * pageSize));
                } else {
                    this.tpmExamineCircularProductSplitEntityMapper.insertList(splitEntityList.subList(page * pageSize, splitEntityList.size()));
                }
                ++page;
            }
            if (!CollectionUtil.isNotEmpty(insertList)) continue;
            this.tpmExamineCircularEntityRepository.saveBatch(insertList);
            for (TpmExamineCircularEntity circularEntity : insertList) {
                TpmExamineCircularLogDto logDto = new TpmExamineCircularLogDto();
                TpmExamineCircularDto newest = (TpmExamineCircularDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)circularEntity, TpmExamineCircularDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                logDto.setNewest(newest);
                this.tpmExamineCircularLogEventListener.onCreate(logDto);
            }
        }
    }

    public void relationFeePoolHandleImportSave(List<TpmExamineCircularRelationFeePoolHandleImportVo> importList) {
        List list = importList.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getSeq())).collect(Collectors.toList());
        Validate.isTrue((importList.size() == list.size() ? 1 : 0) != 0, (String)"\u5173\u8054\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        ArrayList<TpmExamineCircularDto> circularDtos = new ArrayList<TpmExamineCircularDto>();
        Map<String, List<TpmExamineCircularRelationFeePoolHandleImportVo>> map = importList.stream().collect(Collectors.groupingBy(TpmExamineCircularRelationFeePoolHandleImportVo::getSeq));
        for (Map.Entry<String, List<TpmExamineCircularRelationFeePoolHandleImportVo>> entry : map.entrySet()) {
            TpmExamineCircularDto dto = new TpmExamineCircularDto();
            List<TpmExamineCircularRelationFeePoolHandleImportVo> value = entry.getValue();
            TpmExamineCircularRelationFeePoolHandleImportVo handleImportVo = value.get(0);
            this.constructHandleExamineCircularDto(dto, handleImportVo);
            ArrayList<TpmExamineCircularProductSplitDto> splitDtoList = new ArrayList<TpmExamineCircularProductSplitDto>();
            BigDecimal examineAmount = BigDecimal.ZERO;
            for (TpmExamineCircularRelationFeePoolHandleImportVo vo : value) {
                this.relationFeePoolHandleImportSaveValidation(vo);
                TpmExamineCircularProductSplitDto splitInfo = this.constructHandleSplitInfo(vo);
                splitDtoList.add(splitInfo);
                examineAmount = examineAmount.add(splitInfo.getSplitAmount());
            }
            dto.setProductSplitList(splitDtoList);
            circularDtos.add(dto);
        }
        Collection respVos = this.nebulaToolkitService.copyCollectionByWhiteList(circularDtos, TpmExamineCircularDto.class, TpmExamineCircularRespVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.feelPoolBalanceValidate(new ArrayList<TpmExamineCircularRespVo>(respVos), new TpmExamineCircularRespVo());
        ArrayList<TpmExamineCircularEntity> insertList = new ArrayList<TpmExamineCircularEntity>();
        if (CollectionUtil.isNotEmpty(circularDtos)) {
            for (TpmExamineCircularDto dto : circularDtos) {
                Date date = new Date();
                FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
                dto.setTenantCode(TenantUtils.getTenantCode());
                TpmExamineCircularEntity entity = (TpmExamineCircularEntity)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, TpmExamineCircularEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                entity.setExamineCircularCode((String)this.generateCodeService.generateCode("K", 1, Integer.valueOf(9), 0L, TimeUnit.DAYS).get(0));
                entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                entity.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
                entity.setApplyTime(date);
                entity.setApplyUserAccount(loginDetails.getUsername());
                entity.setApplyUserName(loginDetails.getRealName());
                entity.setRelationType(TpmExamineCircularRelationTypeEnum.FEE_POOL_RELATION.getCode());
                insertList.add(entity);
                if (CollectionUtils.isEmpty((Collection)dto.getProductSplitList())) {
                    throw new UnsupportedOperationException("\u7f3a\u5c11\u4ea7\u54c1\u5206\u644a\u6570\u636e");
                }
                ArrayList<TpmExamineCircularProductSplitEntity> splitEntityList = new ArrayList<TpmExamineCircularProductSplitEntity>();
                for (TpmExamineCircularProductSplitDto splitDto : dto.getProductSplitList()) {
                    TpmExamineCircularProductSplitEntity splitEntity = (TpmExamineCircularProductSplitEntity)this.nebulaToolkitService.copyObjectByWhiteList((Object)splitDto, TpmExamineCircularProductSplitEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                    splitEntity.setId(UUID.randomUUID().toString().replaceAll("-", ""));
                    splitEntity.setExamineCircularCode(entity.getExamineCircularCode());
                    splitEntity.setCreateAccount(loginDetails.getUsername());
                    splitEntity.setCreateName(loginDetails.getRealName());
                    splitEntity.setModifyAccount(loginDetails.getUsername());
                    splitEntity.setModifyName(loginDetails.getRealName());
                    splitEntity.setCreateTime(date);
                    splitEntity.setModifyTime(date);
                    splitEntity.setTenantCode(TenantUtils.getTenantCode());
                    splitEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    splitEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                    String splitDetailCode = (String)this.generateCodeService.generateCode("KM", 1, Integer.valueOf(8), 0L, TimeUnit.DAYS).get(0);
                    splitEntity.setSplitDetailCode(splitDetailCode);
                    splitEntityList.add(splitEntity);
                }
                int pageSize = 500;
                int page = 0;
                while (page * pageSize < splitEntityList.size()) {
                    if (page * pageSize + pageSize < splitEntityList.size()) {
                        this.tpmExamineCircularProductSplitEntityMapper.insertList(splitEntityList.subList(page * pageSize, (page + 1) * pageSize));
                    } else {
                        this.tpmExamineCircularProductSplitEntityMapper.insertList(splitEntityList.subList(page * pageSize, splitEntityList.size()));
                    }
                    ++page;
                }
            }
            if (CollectionUtil.isNotEmpty(insertList)) {
                this.tpmExamineCircularEntityRepository.saveBatch(insertList);
                for (TpmExamineCircularEntity circularEntity : insertList) {
                    TpmExamineCircularLogDto logDto = new TpmExamineCircularLogDto();
                    TpmExamineCircularDto newest = (TpmExamineCircularDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)circularEntity, TpmExamineCircularDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                    logDto.setNewest(newest);
                    this.tpmExamineCircularLogEventListener.onCreate(logDto);
                }
            }
        }
    }

    public void relationPrepaymentImportSaveValidation(TpmExamineCircularDto dto) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getBusinessUnitCode()), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getBusinessFormatCode()), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getExamineType()), (String)"\u8003\u6838\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getBudgetCode()), (String)"\u5173\u8054\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getBudgetProjectCode()), (String)"\u9884\u7b97\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getSalesOrgCode()), (String)"\u9500\u552e\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getSalesOrgName()), (String)"\u9500\u552e\u673a\u6784\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getCustomerCode()), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getCustomerName()), (String)"\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)Objects.nonNull(dto.getExamineCircularAmount()), (String)"\u5956\u52b1/\u6263\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (StringUtils.equals((CharSequence)dto.getBusinessUnitCode(), (CharSequence)BusinessUnitEnum.VERTICAL.getCode())) {
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getSystemCode()), (String)"\u96f6\u552e\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getSystemName()), (String)"\u96f6\u552e\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getRegion()), (String)"\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }

    public void relationFeePoolSalesVolumeImportSaveValidation(TpmExamineCircularDto dto) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getBusinessUnitCode()), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getBusinessFormatCode()), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getExamineType()), (String)"\u8003\u6838\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getAppraisalMonth()), (String)"\u8003\u6838\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)Objects.nonNull(dto.getStartDate()), (String)"\u8003\u6838\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)Objects.nonNull(dto.getEndDate()), (String)"\u8003\u6838\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getActivitySapForm()), (String)"\u6d3b\u52a8\u5f62\u5f0fsap\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getActivityForm()), (String)"\u6d3b\u52a8\u5f62\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getSalesOrgCode()), (String)"\u9500\u552e\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getSalesOrgName()), (String)"\u9500\u552e\u673a\u6784\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getCustomerCode()), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getCustomerName()), (String)"\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getSalesGroupCode()), (String)"\u9500\u552e\u7ec4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getSalesDepartmentCode()), (String)"\u9500\u552e\u90e8\u95e8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)Objects.nonNull(dto.getExamineCircularAmount()), (String)"\u5956\u52b1/\u6263\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (StringUtils.equals((CharSequence)dto.getBusinessUnitCode(), (CharSequence)BusinessUnitEnum.VERTICAL.getCode())) {
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getSystemCode()), (String)"\u96f6\u552e\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getSystemName()), (String)"\u96f6\u552e\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getRegion()), (String)"\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }

    public void relationFeePoolHandleImportSaveValidation(TpmExamineCircularRelationFeePoolHandleImportVo vo) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getBusinessUnitCode()), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getBusinessFormatCode()), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getExamineType()), (String)"\u8003\u6838\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getAppraisalMonth()), (String)"\u8003\u6838\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)Objects.nonNull(vo.getStartDate()), (String)"\u8003\u6838\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)Objects.nonNull(vo.getEndDate()), (String)"\u8003\u6838\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getActivitySapForm()), (String)"\u6d3b\u52a8\u5f62\u5f0fsap\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getActivityForm()), (String)"\u6d3b\u52a8\u5f62\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getSalesOrgCode()), (String)"\u9500\u552e\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getSalesOrgName()), (String)"\u9500\u552e\u673a\u6784\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getCustomerCode()), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getCustomerName()), (String)"\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getSalesGroupCode()), (String)"\u9500\u552e\u7ec4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getSalesDepartmentCode()), (String)"\u9500\u552e\u90e8\u95e8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getProductBrandCode()), (String)"\u54c1\u724c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getProductBrandName()), (String)"\u54c1\u724c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getProductLevelCode()), (String)"\u54c1\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getProductLevelName()), (String)"\u54c1\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getSubProductLevelCode()), (String)"\u54c1\u9879\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getSubProductLevelName()), (String)"\u54c1\u9879\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)Objects.nonNull(vo.getSplitAmount()), (String)"\u5206\u644a\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (StringUtils.equals((CharSequence)vo.getBusinessUnitCode(), (CharSequence)BusinessUnitEnum.VERTICAL.getCode())) {
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getSystemCode()), (String)"\u96f6\u552e\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getSystemName()), (String)"\u96f6\u552e\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getRegion()), (String)"\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }

    public void constructSalesVolumeSplitInfo(TpmExamineCircularDto dto) {
        Collection productSplitDtos;
        String cacheKey = UUID.randomUUID().toString().replace("-", "").toUpperCase() + dto.getBusinessUnitCode();
        List examineCircularDataList = new ArrayList();
        List mainOnedaySalesDataVos = new ArrayList();
        List ce1ExamineCircularSearchVos = new ArrayList();
        BusinessUnitEnum businessUnitEnum = BusinessUnitEnum.codeToEnum((String)dto.getBusinessUnitCode());
        switch (businessUnitEnum) {
            case HEADQUARTERS: {
                MainOnedaySalesDataDto mainOnedaySalesDataDto = new MainOnedaySalesDataDto();
                mainOnedaySalesDataDto.setCustomerCode(dto.getCustomerCode());
                mainOnedaySalesDataDto.setBusinessFormatCode(dto.getBusinessFormatCode());
                mainOnedaySalesDataDto.setSalesInstitutionCode(dto.getSalesOrgCode());
                mainOnedaySalesDataDto.setStartTimeOrDate(DateUtil.dateStrYYYYMMDD((Date)dto.getStartDate()));
                mainOnedaySalesDataDto.setEndTimeOrDate(DateUtil.dateStrYYYYMMDD((Date)dto.getEndDate()));
                log.info("\u4e3b\u4f53\u9500\u91cf\u5206\u644a\u67e5\u8be2\u5206\u644a\u4fe1\u606f,\u53c2\u6570:dto\u3010{}\u3011,  cacheKey:[{}]", (Object)JSON.toJSONString((Object)mainOnedaySalesDataDto), (Object)cacheKey);
                mainOnedaySalesDataVos = this.mainOnedaySaleDataService.findSummaryByConditions(mainOnedaySalesDataDto, cacheKey);
                log.info("\u4e3b\u4f53\u9500\u91cf\u5206\u644a\u67e5\u8be2\u5206\u644a\u4fe1\u606f,\u7ed3\u679c:\u3010{}\u3011", (Object)JSON.toJSONString(mainOnedaySalesDataVos));
                break;
            }
            case ONLINE: {
                Ce1ExamineCircularSearchDto ce1ExamineCircularSearchDto = new Ce1ExamineCircularSearchDto();
                ce1ExamineCircularSearchDto.setCustomerCode(dto.getCustomerCode());
                ce1ExamineCircularSearchDto.setSaleOrgCode(dto.getSalesOrgCode());
                ce1ExamineCircularSearchDto.setStartDate(DateUtil.dateStrYYYYMMDD((Date)dto.getStartDate()));
                ce1ExamineCircularSearchDto.setEndDate(DateUtil.dateStrYYYYMMDD((Date)dto.getEndDate()));
                log.info("\u7535\u5546\u9500\u91cf\u5206\u644a\u67e5\u8be2\u5206\u644a\u4fe1\u606f,\u53c2\u6570:dto\u3010{}\u3011,  cacheKey:[{}]", (Object)JSON.toJSONString((Object)ce1ExamineCircularSearchDto), (Object)cacheKey);
                ce1ExamineCircularSearchVos = this.ce1MnjtSdkService.findExamineCircularDataList(ce1ExamineCircularSearchDto, cacheKey);
                log.info("\u7535\u5546\u9500\u91cf\u5206\u644a\u67e5\u8be2\u5206\u644a\u4fe1\u606f,\u7ed3\u679c:\u3010{}\u3011", (Object)JSON.toJSONString(ce1ExamineCircularSearchVos));
                break;
            }
            case SON_COMPANY: {
                TpmSapDaySalesExamineCircularSearchDto circularSearchDto = new TpmSapDaySalesExamineCircularSearchDto();
                circularSearchDto.setCustomerCode(dto.getCustomerCode());
                circularSearchDto.setBusinessFormatCode(dto.getBusinessFormatCode());
                circularSearchDto.setBusinessUnitCode(dto.getBusinessUnitCode());
                circularSearchDto.setSaleOrgCode(dto.getSalesOrgCode());
                circularSearchDto.setStartDate(DateUtil.dateStrYYYYMMDD((Date)dto.getStartDate()));
                circularSearchDto.setEndDate(DateUtil.dateStrYYYYMMDD((Date)dto.getEndDate()));
                log.info("\u5206\u5b50\u516c\u53f8\u9500\u91cf\u5206\u644a\u67e5\u8be2\u5206\u644a\u4fe1\u606f,\u53c2\u6570:dto\u3010{}\u3011,  cacheKey:[{}]", (Object)JSON.toJSONString((Object)circularSearchDto), (Object)cacheKey);
                examineCircularDataList = this.tpmSapDaySalesService.findExamineCircularDataList(circularSearchDto, cacheKey);
                log.info("\u5206\u5b50\u516c\u53f8\u9500\u91cf\u5206\u644a\u67e5\u8be2\u5206\u644a\u4fe1\u606f,\u7ed3\u679c:\u3010{}\u3011", (Object)JSON.toJSONString(examineCircularDataList));
                break;
            }
            case VERTICAL: {
                throw new IllegalArgumentException("\u5f53\u524d\u4e1a\u52a1\u5355\u5143\u4e0d\u652f\u6301\u9500\u91cf\u5206\u644a");
            }
            default: {
                throw new IllegalArgumentException("\u672a\u77e5\u7684\u4e1a\u52a1\u5355\u5143!");
            }
        }
        Map<Object, Object> calSplitMap = new HashMap();
        if (CollectionUtil.isNotEmpty(examineCircularDataList)) {
            productSplitDtos = this.nebulaToolkitService.copyCollectionByWhiteList(examineCircularDataList, TpmSapDaySalesExamineCircularSearchVo.class, TpmExamineCircularProductSplitDto.class, HashSet.class, ArrayList.class, new String[0]);
            dto.setProductSplitList(new ArrayList(productSplitDtos));
            calSplitMap = this.calSplitMap(dto, cacheKey);
        }
        if (CollectionUtil.isNotEmpty(mainOnedaySalesDataVos)) {
            Map salesDataVoMap = mainOnedaySalesDataVos.stream().collect(Collectors.toMap(MainOnedaySalesDataVo::getProductCode, Function.identity()));
            Collection productSplitDtos2 = this.nebulaToolkitService.copyCollectionByWhiteList(mainOnedaySalesDataVos, MainOnedaySalesDataVo.class, TpmExamineCircularProductSplitDto.class, HashSet.class, ArrayList.class, new String[0]);
            productSplitDtos2.forEach(e -> {
                MainOnedaySalesDataVo mainOnedaySalesDataVo = (MainOnedaySalesDataVo)salesDataVoMap.get(e.getProductCode());
                e.setProductLevelCode(mainOnedaySalesDataVo.getProductCategoryCode());
                e.setProductLevelName(mainOnedaySalesDataVo.getProductCategoryName());
                e.setSubProductLevelCode(mainOnedaySalesDataVo.getProductItemCode());
                e.setSubProductLevelName(mainOnedaySalesDataVo.getProductItemName());
            });
            dto.setProductSplitList(new ArrayList(productSplitDtos2));
            calSplitMap = this.calSplitMap(dto, cacheKey);
        }
        if (CollectionUtil.isNotEmpty(ce1ExamineCircularSearchVos)) {
            productSplitDtos = this.nebulaToolkitService.copyCollectionByWhiteList(ce1ExamineCircularSearchVos, Ce1ExamineCircularSearchVo.class, TpmExamineCircularProductSplitDto.class, HashSet.class, ArrayList.class, new String[0]);
            dto.setProductSplitList(new ArrayList(productSplitDtos));
            calSplitMap = this.calSplitMap(dto, cacheKey);
        }
        Validate.isTrue((boolean)CollectionUtil.isNotEmpty(calSplitMap), (String)"\u5206\u644a\u6570\u636e\u4e3a\u7a7a", (Object[])new Object[0]);
        Collection calRespVos = calSplitMap.values();
        Collection splitDtoList = this.nebulaToolkitService.copyCollectionByWhiteList(new ArrayList(calRespVos), TpmExamineCircularProductSplitCalRespVo.class, TpmExamineCircularProductSplitDto.class, HashSet.class, ArrayList.class, new String[0]);
        dto.setProductSplitList(new ArrayList(splitDtoList));
    }

    public void constructHandleExamineCircularDto(TpmExamineCircularDto dto, TpmExamineCircularRelationFeePoolHandleImportVo vo) {
        BeanUtils.copyProperties((Object)vo, (Object)dto);
    }

    public TpmExamineCircularProductSplitDto constructHandleSplitInfo(TpmExamineCircularRelationFeePoolHandleImportVo vo) {
        TpmExamineCircularProductSplitDto splitDto = new TpmExamineCircularProductSplitDto();
        BeanUtils.copyProperties((Object)vo, (Object)splitDto);
        return splitDto;
    }

    private BigDecimal findCustomerFeePool(CustomerVo customerVo, FeePoolQueryVo feePoolQueryVo) {
        log.info("\u5b50\u516c\u53f8\u8d39\u7528\u67e5\u8be2 \u3010{}\u3011", (Object)JSON.toJSONString((Object)feePoolQueryVo));
        if (customerVo == null) {
            return BigDecimal.ZERO;
        }
        if (feePoolQueryVo == null) {
            return BigDecimal.ZERO;
        }
        List item1 = feePoolQueryVo.getITEM1();
        for (FeePoolQueryVo.Item1 item : item1) {
            if (!customerVo.getErpCode().equals(item.getKUNNR()) || !customerVo.getCustomerChannelCode().equals(item.getVTWEG()) || !customerVo.getSalesInstitutionErpCode().equals(item.getVKORG()) || !customerVo.getSalesRegionErpCode().equals(item.getVKBUR())) continue;
            if (item.getZKYYE().contains("-")) {
                String amount = item.getZKYYE().trim().replace("-", "");
                return new BigDecimal(amount).negate();
            }
            return new BigDecimal(item.getZKYYE().trim());
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal findCustomerFeePoolSonCompany(CustomerVo customerVo, FeePoolQuerySonCompanyVo feePoolQuerySonCompanyVo) {
        if (customerVo == null) {
            return BigDecimal.ZERO;
        }
        if (feePoolQuerySonCompanyVo == null) {
            return BigDecimal.ZERO;
        }
        List item1 = feePoolQuerySonCompanyVo.getITEM1();
        for (FeePoolQuerySonCompanyVo.Item1 item : item1) {
            if (!customerVo.getErpCode().equals(item.getKUNNR()) || !customerVo.getCustomerChannelCode().equals(item.getVTWEG()) || !customerVo.getSalesInstitutionErpCode().equals(item.getVKORG()) || !customerVo.getSalesRegionErpCode().equals(item.getVKBUR())) continue;
            if (item.getZKYYE().contains("-")) {
                String amount = item.getZKYYE().trim().replace("-", "");
                return new BigDecimal(amount).negate();
            }
            return new BigDecimal(item.getZKYYE().trim());
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal findSplitAmountForVariable(TpmExamineCircularDto dto, String productCode) {
        return this.tpmExamineCircularProductSplitEntityMapper.findSplitAmountForVariable(dto, productCode);
    }

    public List<TpmExamineCircularRespVo> findListForReconciliation(TpmExamineCircularDto dto) {
        List<TpmExamineCircularProductSplitEntity> productList;
        if (StringUtils.isEmpty((CharSequence)dto.getBusinessUnitCode()) || StringUtils.isEmpty((CharSequence)dto.getBusinessFormatCode()) || StringUtils.isEmpty((CharSequence)dto.getCustomerCode()) || Objects.isNull(dto.getStartDate()) || Objects.isNull(dto.getEndDate())) {
            return Lists.newArrayList();
        }
        List circularEntities = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.tpmExamineCircularEntityRepository.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(TpmExamineCircularEntity::getBusinessUnitCode, (Object)dto.getBusinessUnitCode())).eq(TpmExamineCircularEntity::getBusinessFormatCode, (Object)dto.getBusinessFormatCode())).between(TpmExamineCircularEntity::getProcessDate, (Object)dto.getStartDate(), (Object)dto.getEndDate())).eq(TpmExamineCircularEntity::getCustomerCode, (Object)dto.getCustomerCode())).eq(TpmExamineCircularEntity::getProcessStatus, (Object)ProcessStatusEnum.PASS.getDictCode())).list();
        if (CollectionUtils.isEmpty((Collection)circularEntities)) {
            return Lists.newArrayList();
        }
        Map<Object, Object> productMap = new HashMap();
        List<String> codes = circularEntities.stream().map(TpmExamineCircularEntity::getExamineCircularCode).distinct().collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(codes) && CollectionUtil.isNotEmpty(productList = this.tpmExamineCircularProductSplitEntityRepository.findProductByCodes(codes))) {
            productMap = productList.stream().collect(Collectors.groupingBy(TpmExamineCircularProductSplitEntity::getExamineCircularCode));
        }
        List respVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)circularEntities, TpmExamineCircularEntity.class, TpmExamineCircularRespVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (CollectionUtil.isNotEmpty(productMap)) {
            for (TpmExamineCircularRespVo respVo : respVos) {
                List productSplitList = (List)productMap.get(respVo.getExamineCircularCode());
                if (!CollectionUtil.isNotEmpty((Collection)productSplitList)) continue;
                StringBuilder productName = new StringBuilder();
                productSplitList.forEach(o -> {
                    if (StringUtils.isNotBlank((CharSequence)o.getProductName())) {
                        productName.append(o.getProductName() + " ; ");
                    }
                });
                if (!StringUtils.isNotBlank((CharSequence)productName.toString())) continue;
                respVo.setProductName(productName.toString());
            }
        }
        return respVos;
    }

    public Page<TpmExamineCircularRespVo> findPageForOut(Pageable pageable, TpmExamineCircularDto dto) {
        return this.tpmExamineCircularEntityRepository.findPageForOut(pageable, dto);
    }

    public List<MobileExamineCircularApprovedVo> mobileExamineCircularApproved(String processNo) {
        if (StringUtils.isEmpty((CharSequence)processNo)) {
            return Lists.newArrayList();
        }
        return this.tpmExamineCircularEntityRepository.mobileExamineCircularApproved(processNo);
    }

    public BigDecimal getExamineMoney(SurplusFeePoolBalanceAssessedAmountStatisticsDto assessDto) {
        return this.tpmExamineCircularEntityRepository.getExamineMoney(assessDto);
    }

    public Page<CostPoolAuditReportVo> findManualUpdateCostPoolReport(Pageable pageable, TpmExamineCircularDto dto) {
        return this.tpmExamineCircularEntityRepository.findManualUpdateCostPoolReport(pageable, dto);
    }

    public Page<CostPoolAuditReportVo> findManualUpdateCostPoolReport2(Pageable pageable, TpmExamineCircularDto dto2) {
        return this.tpmExamineCircularEntityRepository.findManualUpdateCostPoolReport2(pageable, dto2);
    }

    public List<TpmExamineCircularRespVo> findByProfitMonitor(List<TpmExamineCircularDto> tpmExamineCircularDto) {
        if (CollectionUtils.isEmpty(tpmExamineCircularDto)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        return this.tpmExamineCircularEntityRepository.findByProfitMonitor(tpmExamineCircularDto);
    }

    public List<TpmExamineCircularRespVo> findListForMonitor(TpmExamineCircularDto dto) {
        if (Objects.isNull(dto)) {
            return Lists.newArrayList();
        }
        List<TpmExamineCircularEntity> listForMonitor = this.tpmExamineCircularEntityRepository.findListForMonitor(dto);
        Collection respVos = this.nebulaToolkitService.copyCollectionByWhiteList(listForMonitor, TpmExamineCircularEntity.class, TpmExamineCircularRespVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)respVos)) {
            return Lists.newArrayList();
        }
        return new ArrayList<TpmExamineCircularRespVo>(respVos);
    }

    @Transactional(rollbackFor={Exception.class})
    public TpmExamineCircularRespVo createAndSubmit(TpmExamineCircularProcessSubmitDto dto) {
        TpmExamineCircularRespVo respVo = this.create((TpmExamineCircularDto)dto);
        ArrayList ids = Lists.newArrayList((Object[])new String[]{respVo.getId()});
        dto.setIds((List)ids);
        this.submitApproval(dto);
        return respVo;
    }

    public List<String> tpmExamineCircularCustomerList(TpmExamineCircularDto circularDto) {
        if (Objects.isNull(circularDto) || StringUtils.isBlank((CharSequence)circularDto.getBusinessFormatCode()) || StringUtils.isBlank((CharSequence)circularDto.getBusinessUnitCode()) || StringUtils.isBlank((CharSequence)circularDto.getProcessStatus()) || Objects.isNull(circularDto.getStartDate()) || Objects.isNull(circularDto.getEndDate())) {
            return Lists.newArrayList();
        }
        List<String> list = this.tpmExamineCircularEntityRepository.tpmExamineCircularCustomerList(circularDto);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return list;
    }
}

