/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.examine.circular.local.service.process;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.tpm.business.examine.circular.local.service.ExamineCircularDailyRecordService;
import com.biz.crm.tpm.business.examine.circular.sdk.vo.ExamineCircularDailyRecordImportVo;
import com.biz.crm.tpm.business.examine.circular.sdk.vo.ExamineCircularDailyRecordVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExamineCircularDailyRecordImportProcess
implements ImportProcess<ExamineCircularDailyRecordImportVo> {
    @Autowired
    private ExamineCircularDailyRecordService service;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, ExamineCircularDailyRecordImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Validate.notEmpty(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((data.values().size() <= this.getBatchCount() ? 1 : 0) != 0, (String)"\u5355\u6b21\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u8d85\u8fc72000\u6761", (Object[])new Object[0]);
        List<ExamineCircularDailyRecordVo> list = this.validateData(data);
        this.service.createBatch(list);
        return null;
    }

    private List<ExamineCircularDailyRecordVo> validateData(LinkedHashMap<Integer, ExamineCircularDailyRecordImportVo> data) {
        data.forEach((k, v) -> {
            Integer row = k + 2;
            Validate.notBlank((CharSequence)v.getSalesInstitutionCode(), (String)"[%s]\u884c,\u9500\u552e\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{row});
            Validate.notBlank((CharSequence)v.getBusinessFormatCode(), (String)"[%s]\u884c,\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{row});
            Validate.notBlank((CharSequence)v.getChannelCode(), (String)"[%s]\u884c,\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{row});
            Validate.notBlank((CharSequence)v.getChannelName(), (String)"[%s]\u884c,\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{row});
            Validate.notBlank((CharSequence)v.getCustomerCode(), (String)"[%s]\u884c,\u5ba2\u6237MDG\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{row});
            Validate.notBlank((CharSequence)v.getExamineDay(), (String)"[%s]\u884c,\u5e74\u6708\u65e5\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{row});
            Validate.notBlank((CharSequence)v.getExamineType(), (String)"[%s]\u884c,\u8003\u6838\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{row});
        });
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(data.values(), ExamineCircularDailyRecordImportVo.class, ExamineCircularDailyRecordVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public Class<ExamineCircularDailyRecordImportVo> findCrmExcelVoClass() {
        return ExamineCircularDailyRecordImportVo.class;
    }

    public String getTemplateCode() {
        return "TPM_EXAMINE_CIRCULAR_DAILY_RECORD_IMPORT";
    }

    public String getTemplateName() {
        return "TPM-\u8003\u6838\u901a\u62a5\u65e5\u8bb0\u5f55\u660e\u7ec6\u8868\u5bfc\u5165";
    }
}

