/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.examine.circular.local.service.process;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.tpm.business.examine.circular.local.service.ExamineCircularMonthRecordService;
import com.biz.crm.tpm.business.examine.circular.sdk.vo.ExamineCircularMonthRecordImportVo;
import com.biz.crm.tpm.business.examine.circular.sdk.vo.ExamineCircularMonthRecordVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExamineCircularMonthRecordImportProcess
implements ImportProcess<ExamineCircularMonthRecordImportVo> {
    @Autowired
    private ExamineCircularMonthRecordService service;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, ExamineCircularMonthRecordImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Validate.notEmpty(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((data.values().size() <= this.getBatchCount() ? 1 : 0) != 0, (String)"\u5355\u6b21\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u8d85\u8fc72000\u6761", (Object[])new Object[0]);
        List<ExamineCircularMonthRecordVo> list = this.validateData(data);
        this.service.createBatch(list);
        return null;
    }

    private List<ExamineCircularMonthRecordVo> validateData(LinkedHashMap<Integer, ExamineCircularMonthRecordImportVo> data) {
        HashMap itemKeyMap = Maps.newHashMap();
        ArrayList itemKeys = Lists.newArrayList();
        data.forEach((k, v) -> {
            Integer row = k + 2;
            Validate.notBlank((CharSequence)v.getSalesInstitutionCode(), (String)"[%s]\u884c,\u9500\u552e\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{row});
            Validate.notBlank((CharSequence)v.getBusinessFormatCode(), (String)"[%s]\u884c,\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{row});
            Validate.notBlank((CharSequence)v.getChannelCode(), (String)"[%s]\u884c,\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{row});
            Validate.notBlank((CharSequence)v.getChannelName(), (String)"[%s]\u884c,\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{row});
            Validate.notBlank((CharSequence)v.getCustomerCode(), (String)"[%s]\u884c,\u5ba2\u6237MDG\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{row});
            Validate.notBlank((CharSequence)v.getYearAndMonth(), (String)"[%s]\u884c,\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{row});
            v.setMonthDeductAmount(BigDecimal.ZERO);
            if (StringUtils.isNotBlank((CharSequence)v.getMonthDeductAmountStr())) {
                try {
                    v.setMonthDeductAmount(new BigDecimal(v.getMonthDeductAmountStr()));
                }
                catch (Exception e) {
                    Validate.isTrue((boolean)false, (String)"[%s]\u884c,\u5f53\u6708\u6263\u6b3e\u91d1\u989d\u4e0d\u662f\u6570\u5b57", (long)row.intValue());
                }
            }
            v.setMonthRewardAmount(BigDecimal.ZERO);
            if (StringUtils.isNotBlank((CharSequence)v.getMonthRewardAmountStr())) {
                try {
                    v.setMonthRewardAmount(new BigDecimal(v.getMonthRewardAmountStr()));
                }
                catch (Exception e) {
                    Validate.isTrue((boolean)false, (String)"[%s]\u884c,\u5f53\u6708\u5956\u52b1\u91d1\u989d\u4e0d\u662f\u6570\u5b57", (long)row.intValue());
                }
            }
            StringBuffer itemKey = new StringBuffer();
            itemKey.append(v.getSalesInstitutionCode());
            itemKey.append(v.getBusinessFormatCode());
            itemKey.append(v.getChannelCode());
            itemKey.append(v.getCustomerCode());
            itemKey.append(v.getYearAndMonth());
            v.setItemKey(itemKey.toString());
            if (itemKeyMap.containsKey(itemKey.toString())) {
                throw new IllegalArgumentException("[" + row + "]\u884c\uff0c\u4e0e[" + itemKeyMap.get(itemKey.toString()) + "]\u884c\uff0c\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5");
            }
            itemKeyMap.put(itemKey.toString(), row);
            itemKeys.add(itemKey.toString());
        });
        List<ExamineCircularMonthRecordVo> entityList = this.service.findByItemKeys(itemKeys);
        Validate.isTrue((boolean)CollectionUtils.isEmpty(entityList), (String)"\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(data.values(), ExamineCircularMonthRecordImportVo.class, ExamineCircularMonthRecordVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public Class<ExamineCircularMonthRecordImportVo> findCrmExcelVoClass() {
        return ExamineCircularMonthRecordImportVo.class;
    }

    public String getTemplateCode() {
        return "TPM_EXAMINE_CIRCULAR_MONTH_RECORD_IMPORT";
    }

    public String getTemplateName() {
        return "TPM-\u8003\u6838\u901a\u62a5\u6708\u8bb0\u5f55\u6c47\u603b\u8868\u5bfc\u5165";
    }
}

