/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.examine.circular.local.service.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.examine.circular.local.mapper.TpmExamineCircularEntityMapper;
import com.biz.crm.tpm.business.examine.circular.sdk.constant.TpmExamineCircularExamineTypeEnum;
import com.biz.crm.tpm.business.examine.circular.sdk.constant.TpmExamineCircularRelationTypeEnum;
import com.biz.crm.tpm.business.examine.circular.sdk.constant.TpmExamineCircularSplitTypeEnum;
import com.biz.crm.tpm.business.examine.circular.sdk.dto.TpmExamineCircularDto;
import com.biz.crm.tpm.business.examine.circular.sdk.vo.TpmExamineCircularDetailsExportVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.base.CaseFormat;
import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TpmExamineCircularDetailsExportProcess
implements ExportProcess<TpmExamineCircularDetailsExportVo> {
    private static final Logger log = LoggerFactory.getLogger(TpmExamineCircularDetailsExportProcess.class);
    @Resource
    private TpmExamineCircularEntityMapper tpmExamineCircularEntityMapper;
    @Autowired(required=false)
    private ActivityFormService activityFormService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    private static final String TPM_EXAMINE_CIRCULAR_COMMIT_STATUS = "tpm_examine_circular_commit_status";

    public Integer getTotal(Map<String, Object> params) {
        log.info("\u8003\u6838\u901a\u62a5\u660e\u7ec6\u5bfc\u51fa\uff0c\u53c2\u6570\u3010{}\u3011", (Object)JSON.toJSONString(params));
        TpmExamineCircularDto dto = this.transferParamToDto(params);
        Integer total = this.tpmExamineCircularEntityMapper.getDetailExportTotal(dto);
        Validate.isTrue((total < CommonConstant.IE_EXPORT_MAX_TOTAL ? 1 : 0) != 0, (String)("\u5bfc\u51fa\u65f6\uff0c\u5355\u6b21\u6700\u5927\u5bfc\u51fa[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]\u6761,\u8bf7\u8f93\u5165\u66f4\u591a\u67e5\u8be2\u6761\u4ef6!!"), (Object[])new Object[0]);
        return total;
    }

    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        Integer offset = vo.getPageNo() * this.getPageSize();
        Integer limit = this.getPageSize();
        TpmExamineCircularDto dto = this.transferParamToDto(params);
        List<TpmExamineCircularDetailsExportVo> exportData = this.tpmExamineCircularEntityMapper.findDetailExportData(dto, limit, offset);
        this.codeToDesc(exportData);
        return JSON.parseArray((String)JSON.toJSONString(exportData));
    }

    public Class<TpmExamineCircularDetailsExportVo> findCrmExcelVoClass() {
        return TpmExamineCircularDetailsExportVo.class;
    }

    public String getBusinessCode() {
        return "TPM_EXAMINE_CIRCULAR_DETAIL_EXPORT";
    }

    public String getBusinessName() {
        return "\u8003\u6838\u901a\u62a5\u660e\u7ec6\u5bfc\u51fa";
    }

    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    public TpmExamineCircularDto transferParamToDto(Map<String, Object> params) {
        log.info("\u8003\u6838\u901a\u62a5\u660e\u7ec6\u5bfc\u51fa,\u53c2\u6570\u3010{}\u3011", (Object)JSON.toJSONString(params));
        HashMap<String, Object> lowerCamelParamMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String param = entry.getKey();
            if (!param.contains("_")) continue;
            String lowerCamelParam = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, param.substring(0, param.lastIndexOf("_")));
            lowerCamelParamMap.put(lowerCamelParam, entry.getValue());
        }
        TpmExamineCircularDto dto = (TpmExamineCircularDto)JSONObject.parseObject((String)JSON.toJSONString(lowerCamelParamMap), TpmExamineCircularDto.class);
        dto.setTenantCode(TenantUtils.getTenantCode());
        return dto;
    }

    public void codeToDesc(List<TpmExamineCircularDetailsExportVo> data) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        Map formatMap = this.dictToolkitService.findMapByDictTypeCode("mdm_business_format");
        Map unitMap = this.dictToolkitService.findMapByDictTypeCode("mdm_business_unit");
        Map commitStatusMap = this.dictToolkitService.findMapByDictTypeCode(TPM_EXAMINE_CIRCULAR_COMMIT_STATUS);
        ArrayList relationTypeEnums = Lists.newArrayList((Object[])TpmExamineCircularRelationTypeEnum.values());
        Map<String, String> relationTypeMap = relationTypeEnums.stream().collect(Collectors.toMap(TpmExamineCircularRelationTypeEnum::getCode, TpmExamineCircularRelationTypeEnum::getName));
        ArrayList examineTypeEnums = Lists.newArrayList((Object[])TpmExamineCircularExamineTypeEnum.values());
        Map<String, String> examineTypeMap = examineTypeEnums.stream().collect(Collectors.toMap(TpmExamineCircularExamineTypeEnum::getCode, TpmExamineCircularExamineTypeEnum::getName));
        Map<Object, Object> activityFormVoMap = new HashMap();
        Set formCodes = data.stream().map(TpmExamineCircularDetailsExportVo::getActivityForm).collect(Collectors.toSet());
        List activityFormVos = this.activityFormService.findByCodes(new ArrayList(formCodes));
        if (CollectionUtils.isNotEmpty((Collection)activityFormVos)) {
            activityFormVoMap = activityFormVos.stream().collect(Collectors.toMap(ActivityFormVo::getActivityFormCode, Function.identity()));
        }
        List regionDictType = this.dictDataVoService.findByDictTypeCode("MDM_CUSTOMIZE_ORG");
        Map<String, String> regionMap = regionDictType.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue));
        ArrayList splitTypeEnums = Lists.newArrayList((Object[])TpmExamineCircularSplitTypeEnum.values());
        Map<String, String> splitTypeMap = splitTypeEnums.stream().collect(Collectors.toMap(TpmExamineCircularSplitTypeEnum::getCode, TpmExamineCircularSplitTypeEnum::getName));
        for (TpmExamineCircularDetailsExportVo exportVo : data) {
            if (StringUtils.isNotBlank((CharSequence)exportVo.getBusinessFormatCode())) {
                exportVo.setBusinessFormatName((String)formatMap.get(exportVo.getBusinessFormatCode()));
            }
            if (StringUtils.isNotBlank((CharSequence)exportVo.getBusinessUnitCode())) {
                exportVo.setBusinessUnitName((String)unitMap.get(exportVo.getBusinessUnitCode()));
            }
            if (StringUtils.isNotBlank((CharSequence)exportVo.getRelationType())) {
                exportVo.setRelationTypeName(relationTypeMap.get(exportVo.getRelationType()));
            }
            if (StringUtils.isNotBlank((CharSequence)exportVo.getExamineType())) {
                exportVo.setExamineTypeName(examineTypeMap.get(exportVo.getExamineType()));
            }
            if (StringUtils.isNotBlank((CharSequence)exportVo.getActivityForm()) && !activityFormVoMap.isEmpty() && Objects.nonNull(activityFormVoMap.get(exportVo.getActivityForm()))) {
                ActivityFormVo activityFormVo = (ActivityFormVo)activityFormVoMap.get(exportVo.getActivityForm());
                exportVo.setActivityFormName(activityFormVo.getActivityFormName());
            }
            if (StringUtils.isNotBlank((CharSequence)exportVo.getRegion())) {
                exportVo.setRegionName(regionMap.get(exportVo.getRegion()));
            }
            if (StringUtils.isNotBlank((CharSequence)exportVo.getSplitType())) {
                exportVo.setSplitTypeName(splitTypeMap.get(exportVo.getSplitType()));
            }
            if (Objects.nonNull(exportVo.getStartDate())) {
                exportVo.setStartDateStr(DateUtil.dateStrYYYYMMDD((Date)exportVo.getStartDate()));
            }
            if (Objects.nonNull(exportVo.getEndDate())) {
                exportVo.setEndDateStr(DateUtil.dateStrYYYYMMDD((Date)exportVo.getEndDate()));
            }
            if (Objects.nonNull(exportVo.getApplyTime())) {
                exportVo.setApplyTimeStr(DateUtil.dateToStr((SimpleDateFormat)DateUtil.date_yyyy_MM_dd_HH_mm_ss, (Date)exportVo.getApplyTime()));
            }
            if (StringUtils.isNotBlank((CharSequence)exportVo.getSapTransferCommitStatus())) {
                exportVo.setSapTransferCommitStatus((String)commitStatusMap.get(exportVo.getSapTransferCommitStatus()));
            }
            if (StringUtils.isNotBlank((CharSequence)exportVo.getIsUpAccount()) && BooleanEnum.TRUE.getCapital().equals(exportVo.getIsUpAccount())) {
                exportVo.setIsUpAccount(BooleanEnum.TRUE.getSure());
                continue;
            }
            exportVo.setIsUpAccount(BooleanEnum.FALSE.getSure());
        }
    }
}

