/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.examine.circular.local.util;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.tpm.business.examine.circular.local.mapper.TpmExamineCircularProductSplitEntityMapper;
import com.biz.crm.tpm.business.examine.circular.sdk.vo.TpmExamineCircularProductSplitRespVo;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TpmExamineCircularUtil {
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private TpmExamineCircularProductSplitEntityMapper tpmExamineCircularProductSplitEntityMapper;

    public String packageCacheKey(String cacheKey) {
        return "TPM:EXAMINE_SALES_DATE_SPLIT:" + cacheKey;
    }

    public Map<String, Object> getSalesProductAmount(String cacheKey) {
        if (StringUtils.isEmpty((CharSequence)cacheKey)) {
            return Maps.newHashMap();
        }
        Object o = this.redisService.get(cacheKey = this.packageCacheKey(cacheKey));
        if (Objects.isNull(o)) {
            return Maps.newHashMap();
        }
        return (Map)JSONObject.parseObject((String)o.toString(), HashMap.class);
    }

    public Object buildCacheById(String examineCircularCode, String cacheKey) {
        List<TpmExamineCircularProductSplitRespVo> productSplitRespVoList = this.tpmExamineCircularProductSplitEntityMapper.findByExamineCircularCode(examineCircularCode);
        Map<String, BigDecimal> salesProductAmount = productSplitRespVoList.stream().filter(e -> Objects.nonNull(e.getSalesAmount())).collect(Collectors.toMap(TpmExamineCircularProductSplitRespVo::getProductCode, TpmExamineCircularProductSplitRespVo::getSalesAmount));
        HashMap cacheMap = new HashMap();
        salesProductAmount.forEach(cacheMap::put);
        this.redisService.set(this.packageCacheKey(cacheKey), (Object)JSONObject.toJSONString(cacheMap), 43200L);
        return cacheMap;
    }
}

