package com.biz.crm.tpm.business.examine.circular.sdk.constant;

import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import org.apache.commons.lang3.StringUtils;

public enum TpmExamineCircularExamineTypeEnum {

    FLEEING_GOODS_EXAMINE("1","窜货考核", "窜货考核"),
    INTEREST_EXAMINE("2","利息考核", "利息考核"),
    DAILY_EXAMINE("3", "日常考核", "日常考核"),
    PATROL_EXAMINE("4", "巡查考核", "巡查考核"),
    OTHER_EXAMINE("5", "其他考核", "其他考核");

    private String code;
    private String name;
    private String desc;

    TpmExamineCircularExamineTypeEnum(String code, String name, String desc){
        this.code = code;
        this.name = name;
        this.desc = desc;
    }

    public String getCode() {
        return this.code;
    }

    public String getDes() {
        return this.desc;
    }

    public String getName(){
        return this.name;
    }

    public static TpmExamineCircularExamineTypeEnum codeToEnum(String code) {
        TpmExamineCircularExamineTypeEnum generatePeriod = null;
        TpmExamineCircularExamineTypeEnum[] generatePeriodList = values();
        int var3 = generatePeriodList.length;

        for (TpmExamineCircularExamineTypeEnum optionTypeEnum : generatePeriodList) {
            if (optionTypeEnum.code.equals(code)) {
                generatePeriod = optionTypeEnum;
            }
        }

        return generatePeriod;
    }


    public static TpmExamineCircularExamineTypeEnum descToEnum(String desc) {
        if (StringUtils.isEmpty(desc)) {
            return null;
        } else {
            TpmExamineCircularExamineTypeEnum[] var1 = values();
            int var2 = var1.length;

            for(int var3 = 0; var3 < var2; ++var3) {
                TpmExamineCircularExamineTypeEnum v = var1[var3];
                if (v.desc.equals(desc)) {
                    return v;
                }
            }

            return null;
        }
    }


}
