package com.biz.crm.tpm.business.examine.circular.sdk.constant;

import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;

public enum TpmExamineCircularRelationTypeEnum {

    BUDGET_RELATION("1","关联预算", "关联预算"),
    FEE_POOL_RELATION("2","关联费用池", "关联费用池"),
    FEE_POOL_RELATION_AND_BUDGET("3","关联费用池及预算", "关联费用池及预算");

    private String code;
    private String name;
    private String desc;

    TpmExamineCircularRelationTypeEnum(String code, String name, String desc){
        this.code = code;
        this.name = name;
        this.desc = desc;
    }

    public String getCode() {
        return this.code;
    }

    public String getDes() {
        return this.desc;
    }

    public String getName(){
        return this.name;
    }

    public static TpmExamineCircularRelationTypeEnum codeToEnum(String code) {
        TpmExamineCircularRelationTypeEnum generatePeriod = null;
        TpmExamineCircularRelationTypeEnum[] generatePeriodList = values();
        int var3 = generatePeriodList.length;

        for (TpmExamineCircularRelationTypeEnum optionTypeEnum : generatePeriodList) {
            if (optionTypeEnum.code.equals(code)) {
                generatePeriod = optionTypeEnum;
            }
        }

        return generatePeriod;
    }

    public static TpmExamineCircularRelationTypeEnum descToEnum(String desc) {
        TpmExamineCircularRelationTypeEnum[] var1 = values();
        int var2 = var1.length;

        for(int var3 = 0; var3 < var2; ++var3) {
            TpmExamineCircularRelationTypeEnum v = var1[var3];
            if (v.desc.equals(desc)) {
                return v;
            }
        }

        return null;
    }


}
