package com.biz.crm.tpm.business.examine.circular.sdk.dto;

import java.time.*;
import java.math.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;

/**
 * 考核通报月记录汇总表
 *
 * @author zhouyang
 * @date 2023-07-24 18:10:38
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ExamineCircularMonthRecordDto", description = "考核通报月记录汇总表")
public class ExamineCircularMonthRecordDto extends TenantFlagOpDto {

    @ApiModelProperty("业态")
    private String businessFormatCode;

    @ApiModelProperty("业态名称")
    private String businessFormatName;

    @ApiModelProperty("渠道")
    private String channelCode;

    @ApiModelProperty("渠道名称")
    private String channelName;

    @ApiModelProperty("销售机构编码")
    private String salesInstitutionCode;

    @ApiModelProperty("销售机构名称")
    private String salesInstitutionName;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("年月")
    private String yearAndMonth;

    @ApiModelProperty("当月奖励金额（元）")
    private BigDecimal monthRewardAmount;

    @ApiModelProperty("当月扣款金额（元）")
    private BigDecimal monthDeductAmount;

    @ApiModelProperty("本月已结案金额（元）")
    private BigDecimal monthEndAmount;

    @ApiModelProperty("应考核扣款金额（元）")
    private BigDecimal examineDeductAmount;

    @ApiModelProperty("实际考核口矿金额（元）")
    private BigDecimal realExamineDeductAmount;

    @ApiModelProperty("剩余待扣款金额（元）")
    private BigDecimal waitExamineDeductAmount;

    @ApiModelProperty("唯一key")
    private String itemKey;

    @ApiModelProperty("年")
    private String yearStr;

}