package com.biz.crm.tpm.business.examine.circular.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * @author: chenlong
 * @date: 2023/3/6 9:57
 * @description: 剩余费用池余额考核扣款统计Dto
 */
@Data
@ApiModel(value = "客户费比监控表考核扣款费用统计Dto")
public class SurplusFeePoolBalanceAssessedAmountStatisticsDto extends TenantFlagOpDto {

    @ApiModelProperty("费用所属年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    private Date feeYearMonth;

    /**
     * 业态编码
     */
    @ApiModelProperty("业态编码")
    private String businessFormatCode;
    /**
     * 业务单元编码
     */
    @ApiModelProperty("业务单元编码")
    private String businessUnitCode;

    /**
     * 关联类型
     */
    @ApiModelProperty("关联类型")
    private String relationType;

    /**
     * 区域编码集合
     */
    @ApiModelProperty(name = "regionCodeList", notes = "区域编码集合")
    private List<String> regionCodeList;

    /**
     * 零售商编码集合
     */
    @ApiModelProperty(name = "customerRetailerCodeList", notes = "零售商编码集合")
    private List<String> customerRetailerCodeList;

    /**
     * 品牌编码集合
     */
    @ApiModelProperty(name = "brandCodeList", notes = "品牌编码集合")
    private List<String> brandCodeList;

    @ApiModelProperty("区域编码")
    private String regionCode;

    @ApiModelProperty("系统编码")
    private String systemCode;

    @ApiModelProperty("售达方编码")
    private String soldCode;


}
