package com.biz.crm.tpm.business.examine.circular.sdk.dto;

import com.alibaba.excel.util.Validate;
import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.bizunited.nebula.venus.sdk.vo.OrdinaryFileVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @ClassName TpmExamineCircularDto
 * @Description
 * @Author: jiangyin
 * @Date 2022/11/21
 */
@Data
@ApiModel(value = "考核通报数据传输类")
public class TpmExamineCircularDto extends TenantFlagOpDto {

    @ApiModelProperty(value = "缓存key",notes = "")
    private String cacheKey;


    /**
     * 分摊类型
     */
    @ApiModelProperty(value = "分摊类型",notes = "")
    private String shareType;

    /**
     * 考核通报年月
     */
    @ApiModelProperty(value = "考核通报年月",notes = "")
    private String examineCircularYearMonth;
    /**
     * 考核通报编码
     */
    @ApiModelProperty(value = "考核通报编码",notes = "")
    private String examineCircularCode;
    /**
     * 考核通报名称
     */
    @ApiModelProperty(value = "考核通报名称",notes = "")
    private String examineCircularName;
    /**
     * 预算年月
     */
    @ApiModelProperty(value = "预算年月",notes = "")
    private String budgetYearMonth;
    /**
     * 业态
     */
    @ApiModelProperty(value = "业态",notes = "")
    private String businessFormatCode;
    /**
     * 业务单元
     */
    @ApiModelProperty(value = "业务单元",notes = "")
    private String businessUnitCode;
    /**
     * 销售组织编码
     */
    @ApiModelProperty(value = "销售组织编码",notes = "")
    private String salesOrgCode;
    /**
     * 销售组织编码
     */
    @ApiModelProperty(value = "销售组织ERP编码",notes = "")
    private String salesOrgErpCode;
    /**
     * 销售组织名称
     */
    @ApiModelProperty(value = "销售组织名称",notes = "")
    private String salesOrgName;
    /**
     * 客户编码
     */
    @ApiModelProperty(value = "客户编码",notes = "")
    private String customerCode;
    /**
     * 客户名称
     */
    @ApiModelProperty(value = "客户名称",notes = "")
    private String customerName;
    /**
     * 负责人
     */
    @ApiModelProperty(value = "负责人",notes = "")
    private String responsiblePerson;
    /**
     * 考核申请金额,负数为扣减
     */
    @ApiModelProperty(value = "考核申请金额,负数为扣减",notes = "")
    private BigDecimal examineCircularAmount;
    /**
     * 申请人id
     */
    @ApiModelProperty(value = "申请人id",notes = "")
    private String applyUserAccount;
    /**
     * 申请人姓名
     */
    @ApiModelProperty(value = "申请人姓名",notes = "")
    private String applyUserName;
    /**
     * 申请时间
     */
    @ApiModelProperty(value = "申请时间",notes = "")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date applyTime;

    /**
     * 申请时间
     */
    @ApiModelProperty(value = "申请时间字符串",notes = "")
    private String applyTimeStr;
    /**
     * 考核分类
     */
    @ApiModelProperty(value = "关联类型",notes = "")
    private String relationType;
    /**
     * 考核类型
     */
    @ApiModelProperty(value = "考核类型",notes = "")
    private String examineType;
    /**
     * 预算编码
     */
    @ApiModelProperty(value = "预算编码",notes = "")
    private String budgetCode;
    /**
     * 预算项目编码
     */
    @ApiModelProperty(value = "预算项目编码",notes = "")
    private String budgetProjectCode;
    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "预算项目名称",notes = "")
    private String budgetProjectName;
    /**
     * 预算占用标识,0:不占用,1:占用
     */
    @ApiModelProperty(value = "预算占用标识",notes = "预算占用标识,0:不占用,1:占用'")
    private String occupyBudgetFlag;
    /**
     * 审批状态
     */
    @ApiModelProperty(value = "审批状态",notes = "")
    private String processStatus;
    /**
     * 审批流程编码
     */
    @ApiModelProperty(value = "审批流程编码",notes = "")
    private String processNo;

    /**
     * 分摊类型
     */
    @ApiModelProperty(value = "分摊类型")
    private String splitType;
    /**
     * 产品分摊列表
     */
    @ApiModelProperty(value = "产品分摊列表",notes = "")
    private List<TpmExamineCircularProductSplitDto> productSplitList;
    /**
     * 附件列表
     */
    @ApiModelProperty(value = "附件列表",notes = "")
    private List<OrdinaryFileVo> protocolList;

    public boolean validate(){
        Validate.isTrue(StringUtils.isNotEmpty(this.relationType), "关联类型不能为空");
        Validate.isTrue(StringUtils.isNotEmpty(this.businessFormatCode), "业态不能为空");
        Validate.isTrue(StringUtils.isNotEmpty(this.businessUnitCode), "业务单元不能为空");
        Validate.isTrue(StringUtils.isNotEmpty(this.examineType), "考核类型不能为空");
        Validate.isTrue(examineCircularAmount != null, "奖励/扣款金额不能为空");
        if (BusinessUnitEnum.SON_COMPANY.getCode().equals(this.businessUnitCode)) {
            Validate.isTrue(StringUtils.isNotBlank(this.getSalesOrgCode()),"销售组织不能为空！");
            Validate.isTrue(StringUtils.isNotBlank(this.getSalesOrgName()),"销售组织不能为空！");
        }
        return true;
    }

    /**
     * 区域
     */
    @ApiModelProperty("区域")
    private String region;
    /**
     * 系统
     */
    @ApiModelProperty("零售商编码")
    private String systemCode;
    /**
     * 系统
     */
    @ApiModelProperty("零售商名称")
    private String systemName;


    /************新增字段****************/

    @ApiModelProperty(value = "考核月份")
    private String appraisalMonth;

    @ApiModelProperty(value = "开始时间",notes = "")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date startDate;

    @ApiModelProperty(value = "结束时间",notes = "")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date endDate;

    @ApiModelProperty(value = "活动形式",notes = "")
    private String activityForm;

    @ApiModelProperty(value = "活动形式名称",notes = "")
    private String activityFormName;

    @ApiModelProperty(value = "活动形式sap编码",notes = "")
    private String activitySapForm;

    @ApiModelProperty(value = "销售组编码",notes = "")
    private String salesGroupCode;

    @ApiModelProperty(value = "销售组名称")
    private String salesGroupName;

    @ApiModelProperty(value = "销售部门编码")
    private String salesDepartmentCode;

    @ApiModelProperty(value = "销售部门名称")
    private String salesDepartmentName;

    @ApiModelProperty("渠道")
    private String channel;


    @ApiModelProperty("CE上账状态")
    private String ceCommitStatus;

    @ApiModelProperty("费用池上账状态")
    private String sapTransferCommitStatus;

    @ApiModelProperty("费用池上账成功时间")
    private Date sapTransferCommitSuccessTime;

    @ApiModelProperty("费用池上账信息")
    private String sapTransferCommitMessage;

    @ApiModelProperty("SAP转款凭证编码")
    private String sapTransferCertCode;

//    @ApiModelProperty("上账编码")
//    private String upAccountCode;

    @ApiModelProperty("是否上账")
    private String isUpAccount;

    @ApiModelProperty("MDG客户编码")
    private String mdgCustomerCode;

    @ApiModelProperty("结案冲销抵扣金额")
    private BigDecimal auditChargeDeductionAmount;

    @ApiModelProperty("结案冲销未抵扣金额")
    private BigDecimal auditChargeNoDeductionAmount;
    @ApiModelProperty("是否分摊")
    private String isSplit;

//    @ApiModelProperty("上账编码(分子公司接口用)")
//    private String upAccountCodeSon;

    private Integer index;

    @ApiModelProperty("便签名称（取自审批工作流主题）")
    private String processTitle;

    @ApiModelProperty("mdg客户编码集合")
    private List<String> mdgCustomerCodes;

    @ApiModelProperty("创建人hr组织编码")
    private String orgCode;

    @ApiModelProperty("创建人hr组织名称")
    private String orgName;

    @ApiModelProperty(name = "out模块查询开始日期字段", notes = "")
    private String outStartTime;

    @ApiModelProperty(name = "out模块查询结束日期字段", notes = "")
    private String outEndTime;

    private Date enterCostPoolDateBegin;
    private Date enterCostPoolDateEnd;

    @ApiModelProperty("审批时间")
    private Date processDate;
}
