package com.biz.crm.tpm.business.examine.circular.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @ClassName TpmExamineCircularMonitorEntity
 * @Description
 * @AUTHOR WangJJ
 * @DATE 2023/6/10 10:11
 **/
@ApiModel(value = "TpmExamineCircularMonitorDto", description = "TPM-考核通报监控表")
@Data
public class TpmExamineCircularMonitorDto extends TenantFlagOpDto {

    /**
     * 业态
     */
    @ApiModelProperty(value = "业态",notes = "")
    private String businessFormatCode;
    /**
     * 业务单元
     */
    @ApiModelProperty(value = "业务单元",notes = "")
    private String businessUnitCode;

    @ApiModelProperty(value = "考核年月")
    private String appraisalMonth;

    /**
     * 考核类型
     */
    @ApiModelProperty(value = "考核类型",notes = "")
    private String examineType;
    /**
     * 销售组织编码
     */
    @ApiModelProperty(value = "销售组织编码",notes = "")
    private String salesOrgCode;
    /**
     * 销售组织名称
     */
    @ApiModelProperty(value = "销售组织名称",notes = "")
    private String salesOrgName;
    /**
     * 客户编码
     */
    @ApiModelProperty(value = "客户编码",notes = "")
    private String customerCode;
    /**
     * 客户名称
     */
    @ApiModelProperty(value = "客户名称",notes = "")
    private String customerName;

    @ApiModelProperty(value = "月初考核金额",notes = "")
    private BigDecimal monthBeginningExamineCircularAmount;

    @ApiModelProperty(value = "实际考核金额",notes = "")
    private BigDecimal actualExamineCircularAmount;

    /**
     * 考核偏差值
     * 考核偏差值=实际考核金额-月初考核金额
     */
    @ApiModelProperty(value = "考核偏差值",notes = "")
    private BigDecimal examineCircularDiffAmount;

    /**
     * 是否超预估考核
     */
    @ApiModelProperty(value = "是否超预估考核",notes = "")
    private String isOverEstimatedExamineCircular;
}
