package com.biz.crm.tpm.business.examine.circular.sdk.event;

import com.biz.crm.tpm.business.examine.circular.sdk.dto.TpmExamineCircularLogDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * @ClassName TpmExamineCircularLogEventListener
 * @Description
 * @Author: jiangyin
 * @Date 2022/11/22
 */
public interface TpmExamineCircularLogEventListener extends NebulaEvent {

    /**
     * 当业务单元创建时触发
     *
     * @param dto
     */
    default void onCreate( TpmExamineCircularLogDto dto) {
    }

    /**
     * 当业务单元修改时触发
     *
     * @param dto
     */
    default void onUpdate(TpmExamineCircularLogDto dto) {
    }

    /**
     * 当业务单元禁用时触发
     *
     * @param dto
     */
    default void onDisable(TpmExamineCircularLogDto dto) {
    }

    /**
     * 当业务单元启用时触发
     *
     * @param dto
     */
    default void onEnable(TpmExamineCircularLogDto dto) {
    }

    /**
     * 当业务单元删除时触发
     *
     * @param dto
     */
    default void onDelete(TpmExamineCircularLogDto dto) {
    }

}
