package com.biz.crm.tpm.business.examine.circular.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mn.third.system.sd.sdk.dto.AuditCostPostingCallbackDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.SonAuditCostPostingCallbackDto;
import com.biz.crm.mn.third.system.sd.sdk.vo.FeePoolQuerySonCompanyVo;
import com.biz.crm.mn.third.system.sd.sdk.vo.FeePoolQueryVo;
import com.biz.crm.tpm.business.examine.circular.sdk.dto.*;
import com.biz.crm.tpm.business.examine.circular.sdk.vo.*;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import org.springframework.data.domain.Pageable;

import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * @ClassName TpmExamineCircularService
 * @Description
 * @Author: jiangyin
 * @Date 2022/11/22
 */
public interface TpmExamineCircularService {
    Page<TpmExamineCircularRespVo> findByConditions(Pageable pageable, TpmExamineCircularDto dto);

    TpmExamineCircularRespVo findById(String id);

    TpmExamineCircularRespVo findByProcessNo(String processNo);

    TpmExamineCircularRespVo create(TpmExamineCircularDto dto);

    TpmExamineCircularRespVo edit(TpmExamineCircularDto dto);

    void deleteByIdList(List<String> ids);

    void enable(List<String> ids);

    void disable(List<String> ids);

    /**
     * 考核扣款费用统计
     *
     * @param dto 查询dto
     * @return List<CustomerCostAssessedAmountStatisticsVo>
     */
    List<CustomerCostAssessedAmountStatisticsVo> listAssessedAmountByOrgCusCodes(CustomerCostAssessedAmountStatisticsDto dto);

    TpmExamineCircularRespVo submitApproval(TpmExamineCircularProcessSubmitDto submitDto);

    /**
     * 流程结束回调更新
     *
     * @param dto
     */
    @Deprecated
    void onProcessComplete(ProcessStatusDto dto);

    /**
     * 金额分摊
     *
     * @param dto
     * @param cacheKey
     * @return
     */
    Map<String, TpmExamineCircularProductSplitCalRespVo> calSplitMap(TpmExamineCircularDto dto, String cacheKey);


    /**
     * 总部费用池查询
     *
     * @param auditCustomerDetailCollectionList
     * @param customerVoMap
     * @return
     */
    FeePoolQueryVo feePoolQueryMain(List<TpmExamineCircularRespVo> auditCustomerDetailCollectionList, Map<String, CustomerVo> customerVoMap);

    /**
     * 分子公司查询
     *
     * @param auditCustomerDetailCollectionList
     * @param customerVoMap
     * @return
     */
    FeePoolQuerySonCompanyVo feePoolSonCompany(List<TpmExamineCircularRespVo> auditCustomerDetailCollectionList, Map<String, CustomerVo> customerVoMap);

    /**
     * 费用池余额校验
     *
     * @param tpmExamineCircularRespVos
     */
    void feelPoolBalanceValidate(List<TpmExamineCircularRespVo> tpmExamineCircularRespVos, TpmExamineCircularRespVo respVo);


    /**
     * 考核通报总公司上账接口回调
     */
    void examineCircularHeadCallback(AuditCostPostingCallbackDto dto);

    /**
     * 考核通报分子公司上账接口回调
     */
    void examineCircularSonCallback(SonAuditCostPostingCallbackDto dto);


    /**
     * 按钮推送考核扣款到费用池
     *
     * @param ids
     */
    Map<String, String> pushEventPrepaymentToFeelPoolHandle(List<String> ids);

    /**
     * 审批通过调整预算
     *
     * @param examineCircularRespVos
     */
    void budgetChange(List<TpmExamineCircularRespVo> examineCircularRespVos);

    /**
     * 审批通过调整预算-月度预算
     * @param examineCircularRespVos
     */
    void monthBudgetChange(List<TpmExamineCircularRespVo> examineCircularRespVos);

    /**
     * 审批通过调整预算-分子月度预算
     * @param examineCircularRespVos
     */
    void subMonthBudgetChange(List<TpmExamineCircularRespVo> examineCircularRespVos);

    /**
     * 审批通过调整预算-调整预算预测
     *
     * @param examineCircularRespVos
     */
    void budgetSubForestChange(List<TpmExamineCircularRespVo> examineCircularRespVos);


    /**
     * 通过零售商+区域+品牌统计考核扣款
     *
     * @param dto 统计参数
     * @return Map<String, BigDecimal>
     */
    Map<String, BigDecimal> statisAssessDeduction(SurplusFeePoolBalanceAssessedAmountStatisticsDto dto);

    /**
     * 关联预算批量导入新增
     *
     * @param importList
     */
    void relationPrepaymentImportSave(List<TpmExamineCircularDto> importList);

    /**
     * 关联费用池批量导入新增(销量分摊)
     *
     * @param importList
     */
    void relationFeePoolSalesVolumeImportSave(List<TpmExamineCircularDto> importList);

    /**
     * 关联费用池批量导入新增(手动分摊)
     *
     * @param
     */
    void relationFeePoolHandleImportSave(List<TpmExamineCircularRelationFeePoolHandleImportVo> importVos);

    /**
     * 构建分摊信息（销量分摊）
     *
     * @param dto
     */
    void constructSalesVolumeSplitInfo(TpmExamineCircularDto dto);

    /**
     * 指标查询分摊金额
     *
     * @param dto
     * @param productCode
     * @return
     */
    BigDecimal findSplitAmountForVariable(TpmExamineCircularDto dto,String productCode);

    /**
     * 获取考核通报列表（结案对账单用）
     * @param dto
     * @return
     */
    List<TpmExamineCircularRespVo> findListForReconciliation(TpmExamineCircularDto dto);

    /**
     *  考核通报监控表获取数据
     * @return
     */
    List<TpmExamineCircularRespVo> findListForMonitor(TpmExamineCircularDto dto);

    Page<TpmExamineCircularRespVo> findPageForOut(Pageable pageable, TpmExamineCircularDto dto);


    List<MobileExamineCircularApprovedVo> mobileExamineCircularApproved(String processNo);

    /**
     * 获取考核扣款 ext系统用
     * @param assessDto
     * @return
     */
    BigDecimal getExamineMoney(SurplusFeePoolBalanceAssessedAmountStatisticsDto assessDto);


    Page<CostPoolAuditReportVo> findManualUpdateCostPoolReport(Pageable pageable, TpmExamineCircularDto dto);

    Page<CostPoolAuditReportVo> findManualUpdateCostPoolReport2(Pageable pageable, TpmExamineCircularDto dto2);

    /**
     * 分子公司利润报表查询考核通报数据
     * @param tpmExamineCircularDto
     * @return
     */
    List<TpmExamineCircularRespVo> findByProfitMonitor(List<TpmExamineCircularDto> tpmExamineCircularDto);

    TpmExamineCircularRespVo createAndSubmit(TpmExamineCircularProcessSubmitDto dto);

    List<String> tpmExamineCircularCustomerList(TpmExamineCircularDto circularDto);
}
