package com.biz.crm.tpm.business.examine.circular.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author : dengwei
 * @Date :2023/10/6  14:45
 * @Description: TODO
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "CostPoolAuditReportVo", description = "费用池核销表")
public class CostPoolAuditReportVo extends TenantFlagOpVo {

    @ApiModelProperty("维度key")
    private String dimensionKey;

    /**
     * 销售机构编码
     */
    @ApiModelProperty("销售机构编码")
    private String salesInstitutionCode;

    /**
     * 销售机构名称
     */
    @ApiModelProperty("销售机构名称")
    private String salesInstitutionName;

    /**
     * 日期
     */
    @ApiModelProperty("日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date enterCostPoolDate;

    @ApiModelProperty(name = "customerCode", value = "客户编码")
    private String customerCode;


    @ApiModelProperty(name = "customerName", value = "客户名称")
    private String customerName;

    @ApiModelProperty(name = "systemCode",value = "零售商编码",notes = "零售商编码")
    private String systemCode;

    @ApiModelProperty(name = "systemName",value = "零售商名称",notes = "零售商名称")
    private String systemName;

    /**
     * 区域
     */
    @ApiModelProperty("区域")
    private String regionCode;

    /**
     * 区域名称
     */
    @ApiModelProperty("区域名称")
    private String regionName;

    @ApiModelProperty("量子")
    private String quantum;

    @ApiModelProperty(name = "核销code", notes = "核销code")
    private String auditCode;

    @ApiModelProperty(name = "核销名称", notes = "核销名称")
    private String auditName;

    @ApiModelProperty(name = "费用池入账金额", notes = "费用池入账金额")
    private BigDecimal amount;

    @ApiModelProperty("客户ERP编码")
    private String customerErpCode;
}
