package com.biz.crm.tpm.business.examine.circular.sdk.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 考核通报日记录明细表导入Vo
 *
 * @author zhouyang
 * @date 2023-07-24 11:01:00
 */
@Data
@CrmExcelImport(startRow = 2)
public class ExamineCircularDailyRecordImportVo extends CrmExcelVo {

    @ApiModelProperty("销售机构编码")
    @CrmExcelColumn(value = "业态*")
    private String salesInstitutionCode;

    @ApiModelProperty("业态")
    @CrmExcelColumn(value = "业态")
    private String businessFormatCode;

    @ApiModelProperty("渠道")
    @CrmExcelColumn(value = "渠道编码")
    private String channelCode;

    @ApiModelProperty("渠道名称")
    @CrmExcelColumn(value = "渠道")
    private String channelName;

    @ApiModelProperty("客户编码")
    @CrmExcelColumn(value = "客户MDG编码")
    private String customerCode;

    @ApiModelProperty("年月日")
    @CrmExcelColumn(value = "年月日")
    private String examineDay;

    @ApiModelProperty("考核扣款金额（元）")
    @CrmExcelColumn(value = "考核扣款金额（元）")
    private BigDecimal examineDeductAmount;

    @ApiModelProperty("考核简历金额（元）")
    @CrmExcelColumn(value = "考核简历金额（元）")
    private BigDecimal examineRewardAmount;

    @ApiModelProperty("考核类型")
    @CrmExcelColumn(value = "考核类型")
    private String examineType;

    @ApiModelProperty("便签备注")
    @CrmExcelColumn(value = "便签备注")
    private String remark;

}