package com.biz.crm.tpm.business.examine.circular.sdk.vo;

import java.math.*;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 考核通报日记录明细表
 *
 * @author zhouyang
 * @date 2023-07-24 11:01:00
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ExamineCircularDailyRecordVo", description = "考核通报日记录明细表")
public class ExamineCircularDailyRecordVo {

    @ApiModelProperty("业态")
    private String businessFormatCode;

    @ApiModelProperty("业态名称")
    private String businessFormatName;

    @ApiModelProperty("渠道")
    private String channelCode;

    @ApiModelProperty("渠道名称")
    private String channelName;

    @ApiModelProperty("销售机构编码")
    private String salesInstitutionCode;

    @ApiModelProperty("销售机构名称")
    private String salesInstitutionName;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("年月日")
    private String examineDay;

    @ApiModelProperty("考核扣款金额（元）")
    private BigDecimal examineDeductAmount;

    @ApiModelProperty("考核简历金额（元）")
    private BigDecimal examineRewardAmount;

    @ApiModelProperty("考核类型")
    private String examineType;

    @ApiModelProperty("考核类型编码")
    private String examineTypeCode;

    @ApiModelProperty("唯一key")
    private String itemKey;

    @ApiModelProperty("便签备注")
    private String remark;

}