package com.biz.crm.tpm.business.examine.circular.sdk.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 考核通报月记录汇总表导入Vo
 *
 * @author zhouyang
 * @date 2023-07-24 18:10:38
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ExamineCircularMonthRecordImportVo", description = "考核通报月记录汇总表导入Vo")
@CrmExcelImport(startRow = 2)
public class ExamineCircularMonthRecordImportVo extends CrmExcelVo {

    @CrmExcelColumn("销售机构编码")
    private String salesInstitutionCode;

    @CrmExcelColumn("业态")
    private String businessFormatCode;

    @CrmExcelColumn("渠道编码")
    private String channelCode;

    @CrmExcelColumn("渠道")
    private String channelName;

    @CrmExcelColumn("客户编码")
    private String customerCode;

    @CrmExcelColumn("年月")
    private String yearAndMonth;

    @CrmExcelColumn("当月扣款金额（元）")
    private String monthDeductAmountStr;

    @CrmExcelColumn("当月奖励金额（元）")
    private String monthRewardAmountStr;

    private String itemKey;
    private BigDecimal monthDeductAmount;
    private BigDecimal monthRewardAmount;
}