package com.biz.crm.tpm.business.examine.circular.sdk.vo;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author: chenlong
 * @date: 2023/3/6 9:57
 * @description: 剩余费用池余额考核扣款统计Vo
 */
@Data
@ApiModel(value = "客户费比监控表考核扣款费用统计Vo")
public class SurplusFeePoolBalanceAssessedAmountStatisticsVo extends TenantFlagOpDto {

    /**
     * 区域
     */
    @ApiModelProperty("区域")
    private String region;
    /**
     * 系统
     */
    @ApiModelProperty("零售商编码")
    private String systemCode;
    /**
     * 系统
     */
    @ApiModelProperty("零售商名称")
    private String systemName;

    /**
     * 品牌编码
     */
    @ApiModelProperty("品牌编码")
    private String brandCode;

    /**
     * 品牌名称
     */
    @ApiModelProperty("品牌名称")
    private String brandName;

    /**
     * 分摊金额
     */
    @ApiModelProperty("分摊金额")
    private BigDecimal splitAmount;

    /**
     * 编码拼接（零售商+区域+品牌），-隔开
     */
    @ApiModelProperty("编码拼接")
    private String splicingCode;
}
