package com.biz.crm.tpm.business.examine.circular.sdk.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @ClassName TpmExamineCircularDetailsExportVo
 * @Description
 * @AUTHOR WangJJ
 * @DATE 2023/3/24 10:23
 **/
@Data
@CrmExcelExport
public class TpmExamineCircularDetailsExportVo extends CrmExcelVo {

    private String id;

    @CrmExcelColumn(value = "考核通报编码", order = 1)
    private String examineCircularCode;

    @CrmExcelColumn(value = "考核通报名称", order = 1)
    private String examineCircularName;

//    @CrmExcelColumn(value = "业态", order = 2)
    private String businessFormatCode;

    @CrmExcelColumn(value = "业态", order = 2)
    private String businessFormatName;

//    @CrmExcelColumn(value = "业务单元", order = 3)
    private String businessUnitCode;

    @CrmExcelColumn(value = "业务单元", order = 3)
    private String businessUnitName;

//    @CrmExcelColumn(value = "关联类型", order = 4)
    private String relationType;

    @CrmExcelColumn(value = "关联类型", order = 4)
    private String relationTypeName;

//    @CrmExcelColumn(value = "考核类型", order = 5)
    private String examineType;

    @CrmExcelColumn(value = "考核类型", order = 5)
    private String examineTypeName;

    @CrmExcelColumn(value = "关联预算编码", order = 6)
    private String budgetCode;

    @CrmExcelColumn(value = "销售机构编码", order = 7)
    private String salesOrgCode;

    @CrmExcelColumn(value = "销售机构名称", order = 8)
    private String salesOrgName;

    @CrmExcelColumn(value = "销售组", order = 9)
    private String salesGroupName;

    @CrmExcelColumn(value = "销售部门", order = 10)
    private String salesDepartmentName;

    @CrmExcelColumn(value = "客户名称", order = 11)
    private String customerName;

    @CrmExcelColumn(value = "客户编码", order = 12)
    private String customerCode;

    @CrmExcelColumn(value = "奖励/扣款金额", order = 13)
    private BigDecimal examineCircularAmount;

    @CrmExcelColumn(value = "考核说明", order = 14)
    private String remark;

    @CrmExcelColumn(value = "考核月份", order = 15)
    private String appraisalMonth;


    @ApiModelProperty(value = "开始时间",notes = "")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
//    @CrmExcelColumn(value = "考核开始时间", order = 16)
    private Date startDate;

    @CrmExcelColumn(value = "考核开始时间", order = 16)
    private String startDateStr;

    @ApiModelProperty(value = "结束时间",notes = "")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
//    @CrmExcelColumn(value = "考核结束时间", order = 17)
    private Date endDate;

    @CrmExcelColumn(value = "考核结束时间", order = 17)
    private String endDateStr;

    @CrmExcelColumn(value = "活动形式名称", order = 18)
    private String activityFormName;

    @CrmExcelColumn(value = "活动形式编码", order = 19)
    private String activityForm;

    @CrmExcelColumn(value = "渠道编码", order = 20)
    private String channel;

//    @CrmExcelColumn(value = "区域", order = 21)
    private String region;

    @CrmExcelColumn(value = "区域", order = 21)
    private String regionName;

    @CrmExcelColumn(value = "零售商", order = 22)
    private String systemName;

//    @CrmExcelColumn(value = "分摊类型", order = 23)
    private String splitType;

    @CrmExcelColumn(value = "分摊类型", order = 23)
    private String splitTypeName;

    @CrmExcelColumn(value = "产品编码", order = 24)
    private String productCode;

    @CrmExcelColumn(value = "产品名称", order = 25)
    private String productName;

    @CrmExcelColumn(value = "品牌", order = 26)
    private String productBrandName;

    @CrmExcelColumn(value = "品类", order = 27)
    private String productLevelName;

    @CrmExcelColumn(value = "品项", order = 28)
    private String subProductLevelName;

    @CrmExcelColumn(value = "分摊金额", order = 29)
    private BigDecimal splitAmount;

    @CrmExcelColumn(value = "上账单号", order = 30)
    private String splitDetailCode;

    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date applyTime;

    @CrmExcelColumn(value = "奖励/扣款时间", order = 31)
    private String applyTimeStr;

    @CrmExcelColumn(value = "奖励/扣款人", order = 32)
    private String applyUserName;

    @CrmExcelColumn(value = "费用池上账状态", order = 33)
    private String sapTransferCommitStatus;

    @CrmExcelColumn(value = "是否上账", order = 34)
    private String isUpAccount;

}
