package com.biz.crm.tpm.business.examine.circular.sdk.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @ClassName TpmExamineCircularmportVo
 * @Description
 * @AUTHOR WangJJ
 * @DATE 2023/3/16 11:16
 **/
@Data
@CrmExcelImport(startRow = 2)
public class TpmExamineCircularImportVo extends CrmExcelVo {

    /**
     * *业态
     */
    @CrmExcelColumn(value = "*业态")
    private String businessFormatCodeDesc;
    private String businessFormatCode;

    /**
     * *业务单元
     */
    @CrmExcelColumn(value = "*业务单元")
    private String businessUnitCodeDesc;
    private String businessUnitCode;

    /**
     * *关联类型
     */
    @CrmExcelColumn(value = "*关联类型")
    private String relationTypeDesc;
    private String relationType;

    /**
     * *考核类型
     */
    @CrmExcelColumn(value = "*考核类型")
    private String examineTypeDesc;
    private String examineType;

    /**
     * 考核通报名称
     */
    @CrmExcelColumn(value = "考核通报名称")
    private String examineCircularName;

    /**
     * *关联预算编码
     */
    @CrmExcelColumn(value = "*关联预算编码")
    private String budgetCode;

    @ApiModelProperty("预算项目编码")
    private String budgetProjectCode;

    @ApiModelProperty("预算项目名称")
    private String budgetProjectName;

    /**
     * *考核月份
     */
    @CrmExcelColumn(value = "*考核月份")
    private String appraisalMonth;

    /**
     * *考核开始时间
     */
    @CrmExcelColumn(value = "*考核开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date startDate;

    /**
     * *考核结束时间
     */
    @CrmExcelColumn(value = "*考核结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date endDate;

    /**
     * *活动形式编码
     */
    @CrmExcelColumn(value = "*活动形式编码")
    private String activityForm;

    @ApiModelProperty(value = "活动形式名称",notes = "")
    private String activityFormName;

    @ApiModelProperty(value = "活动形式sap编码",notes = "")
    private String activitySapForm;

    /**
     * *销售机构编码
     */
    @CrmExcelColumn(value = "*销售机构编码")
    private String salesOrgErpCode;
    @ApiModelProperty(value = "销售组织编码",notes = "")
    private String salesOrgCode;
    @ApiModelProperty(value = "销售组织名称",notes = "")
    private String salesOrgName;

    @ApiModelProperty(value = "销售组编码",notes = "")
    private String salesGroupCode;

    @ApiModelProperty(value = "销售组名称")
    private String salesGroupName;

    @ApiModelProperty(value = "销售部门编码")
    private String salesDepartmentCode;

    @ApiModelProperty(value = "销售部门名称")
    private String salesDepartmentName;

    /**
     * *客户编码
     */
    @CrmExcelColumn(value = "*客户编码")
    private String mdgCustomerCode;
    private String customerCode;

    /**
     * 客户名称
     */
    @CrmExcelColumn(value = "客户名称")
    private String customerName;

    /**
     * *渠道编码
     */
    @CrmExcelColumn(value = "*渠道编码")
    private String channel;

    /**
     * 区域
     */
    @CrmExcelColumn(value = "*区域")
    private String regionDesc;
    private String region;

    /**
     * 零售商
     */
    @CrmExcelColumn(value = "*零售商")
    private String systemCodeDesc;
    private String systemCode;


    /**
     * *分摊类型
     */
    @CrmExcelColumn(value = "*分摊类型")
    private String splitTypeDesc;
    private String splitType;

    /**
     * 关联序号
     */
    @CrmExcelColumn(value = "关联序号")
    private String seq;

    /**
     * 产品编码
     */
    @CrmExcelColumn(value = "产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @CrmExcelColumn(value = "产品名称")
    private String productName;

    @ApiModelProperty(value = "产品品牌编码",notes = "")
    private String productBrandCode;

    @ApiModelProperty(value = "产品品牌名称",notes = "")
    private String productBrandName;

    @ApiModelProperty(value = "产品品类编码",notes = "")
    private String productLevelCode;

    @ApiModelProperty(value = "产品品类名称",notes = "")
    private String productLevelName;

    @ApiModelProperty(value = "产品品项编码",notes = "")
    private String subProductLevelCode;

    @ApiModelProperty(value = "产品品项名称",notes = "")
    private String subProductLevelName;

    /**
     * 分摊金额
     */
    @CrmExcelColumn(value = "分摊金额")
    private BigDecimal splitAmount;

    /**
     * *奖励/扣款金额
     */
    @CrmExcelColumn(value = "*奖励/扣款金额")
    private BigDecimal examineCircularAmount;

    /**
     * 考核说明
     */
    @CrmExcelColumn(value = "考核说明")
    private String remark;

    /**
     * *是否上账
     */
    @CrmExcelColumn(value = "是否上账")
    private String isUpAccountDesc;
    private String isUpAccount;
    /**
     * 责任人
     */
    @CrmExcelColumn(value = "责任人")
    private String responsiblePerson;

    /**
     * 是否分摊
     */
//    @CrmExcelColumn(value = "是否分摊")
    private String isSplit;

    private Integer index;


}
