package com.biz.crm.tpm.business.examine.circular.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @ClassName TpmExamineCircularProductSplitRespVo
 * @Description
 * @Author: jiangyin
 * @Date 2022/11/21
 */
@Data
@ApiModel(value = "考核通报产品销量分摊查询返回类")
public class TpmExamineCircularProductSplitRespVo extends TenantFlagOpVo {

    /**
     * 考核通报编码
     */
    @ApiModelProperty(value = "考核通报编码",notes = "")
    private String examineCircularCode;

    /**
     * 产品编码
     */
    @ApiModelProperty(value = "产品编码",notes = "")
    private String productCode;

    /**
     * 分摊金额
     */
    @ApiModelProperty(value = "分摊金额",notes = "")
    private BigDecimal splitAmount;

    @ApiModelProperty(value = "销售金额",notes = "")
    private BigDecimal salesAmount;

    /**
     * 产品名称
     */
    @ApiModelProperty(value = "产品名称",notes = "")
    private String productName;

    /**
     * 产品品牌编码
     */
    @ApiModelProperty(value = "产品品牌编码",notes = "")
    private String productBrandCode;

    /**
     * 产品品牌名称
     */
    @ApiModelProperty(value = "产品品牌名称",notes = "")
    private String productBrandName;

    /**
     * 产品品类编码
     */
    @ApiModelProperty(value = "产品品类编码",notes = "")
    private String productLevelCode;

    /**
     * 产品品类名称
     */
    @ApiModelProperty(value = "产品品类名称",notes = "")
    private String productLevelName;

    /**
     * 产品品项编码
     */
    @ApiModelProperty(value = "产品品项编码",notes = "")
    private String subProductLevelCode;

    /**
     * 产品品项名称
     */
    @ApiModelProperty(value = "产品品项名称",notes = "")
    private String subProductLevelName;

    /**
     * 分摊明细编码
     */
    @ApiModelProperty(value = "分摊明细编码",notes = "")
    private String splitDetailCode;

    /**
     * 分摊明细推送状态
     */
    @ApiModelProperty(value = "分摊明细推送状态",notes = "")
    private String splitCommitStatus;

    @ApiModelProperty(value = "分摊明细推送成功时间（回调返回成功时间）",notes = "")
    private Date splitCommitSuccessTime;

//    /**
//     * 分摊明细编码
//     */
//    @ApiModelProperty(value = "上账编码",notes = "")
//    private String upAccountCode;

}
