package com.biz.crm.tpm.business.examine.circular.sdk.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @ClassName TpmExamineCircularProtocolVo
 * @Description
 * @AUTHOR WangJJ
 * @DATE 2023/3/24 17:03
 **/
@Data
public class TpmExamineCircularProtocolVo {
    /**
     * 考核通报编码
     */
    @ApiModelProperty(value = "考核通报编码",notes = "")
    private String examineCircularCode;

    @ApiModelProperty(name = "commitUser", value = "文件的上传者")
    private String commitUser;

    @ApiModelProperty(name = "fileName", value = "重命名后的文件名字")
    private String fileName;

    @ApiModelProperty(name = "originalFileName", value = "重命名前的文件名字")
    private String originalFileName;

    @ApiModelProperty(name = "relativeLocal", value = "文件在本地的存储目录（相对位置，不包括）")
    private String relativeLocal;

    @ApiModelProperty(name = "prefix", value = "文件的扩展类型，例如：png、gif、jpg等")
    private String prefix;

    @ApiModelProperty(name = "effectiveDate", value = "文件有效期截止")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date effectiveDate;

    @ApiModelProperty(name = "fileSize", value = "文件大小单位Byte（字节）")
    private Long fileSize;
}
