package com.biz.crm.tpm.business.examine.circular.sdk.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @ClassName TpmExamineCircularRelationFeePoolHandleImportVo
 * @Description 考核通报费用池导入手动分摊
 * @AUTHOR WangJJ
 * @DATE 2023/3/14 13:57
 **/
@Data
@CrmExcelImport(startRow = 2)
public class TpmExamineCircularRelationFeePoolHandleImportVo extends CrmExcelVo {

    /**
     * 业态
     */
    @CrmExcelColumn(value = "业态*")
    private String businessFormatCode;

    /**
     * 业务单元*
     */
    @CrmExcelColumn(value = "业务单元*")
    private String businessUnitCode;

    /**
     * 考核类型*
     */
    @CrmExcelColumn(value = "考核类型*")
    private String examineType;

    /**
     * 考核月份*
     */
    @CrmExcelColumn(value = "考核月份*")
    private String appraisalMonth;

    /**
     * 考核开始时间*
     */
    @CrmExcelColumn(value = "考核开始时间*")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date startDate;

    /**
     * 考核结束时间*
     */
    @CrmExcelColumn(value = "考核结束时间*")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date endDate;

//    /**
//     * 关联预算*
//     */
//    @CrmExcelColumn(value = "关联预算*")
//    private String budgetCode;

    /**
     * 活动形式sap编码*
     */
    @CrmExcelColumn(value = "活动形式sap编码*")
    private String activitySapForm;

    /**
     * 活动形式*
     */
    @CrmExcelColumn(value = "活动形式*")
    private String activityForm;

    /**
     * 销售机构编码*
     */
    @CrmExcelColumn(value = "销售机构编码*")
    private String salesOrgCode;

    /**
     * 销售机构名称*
     */
    @CrmExcelColumn(value = "销售机构名称*")
    private String salesOrgName;

    /**
     * 客户名称*
     */
    @CrmExcelColumn(value = "客户名称*")
    private String customerName;

    /**
     * 客户编码*
     */
    @CrmExcelColumn(value = "客户编码*")
    private String customerCode;

    /**
     * 销售组*
     */
    @CrmExcelColumn(value = "销售组*")
    private String salesGroupCode;

    /**
     * 销售部门*
     */
    @CrmExcelColumn(value = "销售部门*")
    private String salesDepartmentCode;

    /**
     * 渠道
     */
    @CrmExcelColumn(value = "渠道")
    private String channel;

    /**
     * 责任人
     */
    @CrmExcelColumn(value = "责任人")
    private String responsiblePerson;

    /**
     * 关联序号*
     */
    @CrmExcelColumn(value = "关联序号*")
    private String seq;

    /**
     * 产品名称*
     */
    @CrmExcelColumn(value = "产品名称*")
    private String productName;

    /**
     * 产品编码*
     */
    @CrmExcelColumn(value = "产品编码*")
    private String productCode;

    /**
     * 品牌*
     */
    @CrmExcelColumn(value = "品牌*")
    private String productBrandCode;

    /**
     * 品牌名称*
     */
    @CrmExcelColumn(value = "品牌名称*")
    private String productBrandName;

    /**
     * 品类*
     */
    @CrmExcelColumn(value = "品类*")
    private String productLevelCode;

    /**
     * 品类名称*
     */
    @CrmExcelColumn(value = "品类名称*")
    private String productLevelName;

    /**
     * 品项*
     */
    @CrmExcelColumn(value = "品项*")
    private String subProductLevelCode;

    /**
     * 品项名称*
     */
    @CrmExcelColumn(value = "品项名称*")
    private String subProductLevelName;

    /**
     * 分摊金额*
     */
    @CrmExcelColumn(value = "分摊金额*")
    private BigDecimal splitAmount;



    /**
     * 备注
     */
    @CrmExcelColumn(value = "备注")
    private BigDecimal remark;

    /**
     * 区域
     */
    @CrmExcelColumn(value = "区域")
    private String region;
    /**
     * 零售商编码
     */
    @CrmExcelColumn(value = "零售商编码")
    private String systemCode;
    /**
     * 零售商名称
     */
    @CrmExcelColumn(value = "零售商名称")
    private String systemName;

}
