package com.biz.crm.tpm.business.examine.circular.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.bizunited.nebula.venus.sdk.vo.OrdinaryFileVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @ClassName TpmExamineCircularRespVo
 * @Description
 * @Author: jiangyin
 * @Date 2022/11/21
 */
@Data
@ApiModel(value = "考核通报查询结果返回类")
public class TpmExamineCircularRespVo extends TenantFlagOpVo {

    /**
     * 分摊类型
     */
    @ApiModelProperty(value = "分摊类型",notes = "")
    private String shareType;

    /**
     * 考核通报年月
     */
    @ApiModelProperty(value = "考核通报年月",notes = "")
    private String examineCircularYearMonth;
    /**
     * 考核通报编码
     */
    @ApiModelProperty(value = "考核通报编码",notes = "")
    private String examineCircularCode;
    /**
     * 考核通报编码
     */
    @ApiModelProperty(value = "考核通报名称",notes = "")
    private String examineCircularName;
    /**
     * 预算年月
     */
    @ApiModelProperty(value = "预算年月",notes = "")
    private String budgetYearMonth;
    /**
     * 业态
     */
    @ApiModelProperty(value = "业态",notes = "")
    private String businessFormatCode;
    /**
     * 业务单元
     */
    @ApiModelProperty(value = "业务单元",notes = "")
    private String businessUnitCode;
    /**
     * 销售组织编码
     */
    @ApiModelProperty(value = "销售组织编码",notes = "")
    private String salesOrgCode;
    /**
     * 销售组织编码
     */
    @ApiModelProperty(value = "销售组织ERP编码",notes = "")
    private String salesOrgErpCode;
    /**
     * 销售组织名称
     */
    @ApiModelProperty(value = "销售组织名称",notes = "")
    private String salesOrgName;
    /**
     * 客户编码
     */
    @ApiModelProperty(value = "客户编码",notes = "")
    private String customerCode;
    /**
     * 客户名称
     */
    @ApiModelProperty(value = "客户名称",notes = "")
    private String customerName;
    /**
     * 负责人
     */
    @ApiModelProperty(value = "负责人",notes = "")
    private String responsiblePerson;
    /**
     * 考核申请金额,负数为扣减
     */
    @ApiModelProperty(value = "考核申请金额,负数为扣减",notes = "")
    private BigDecimal examineCircularAmount;
    /**
     * 申请人id
     */
    @ApiModelProperty(value = "申请人id",notes = "")
    private String applyUserAccount;
    /**
     * 申请人姓名
     */
    @ApiModelProperty(value = "申请人姓名",notes = "")
    private String applyUserName;
    /**
     * 申请时间
     */
    @ApiModelProperty(value = "申请时间",notes = "")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date applyTime;
    /**
     * 考核分类
     */
    @ApiModelProperty(value = "关联类型",notes = "")
    private String relationType;
    /**
     * 考核类型
     */
    @ApiModelProperty(value = "考核类型",notes = "")
    private String examineType;
    /**
     * 预算编码
     */
    @ApiModelProperty(value = "预算编码",notes = "")
    private String budgetCode;
    /**
     * 预算项目编码
     */
    @ApiModelProperty(value = "预算项目编码",notes = "")
    private String budgetProjectCode;
    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "预算项目名称",notes = "")
    private String budgetProjectName;
    /**
     * 预算占用标识,0:不占用,1:占用
     */
    @ApiModelProperty(value = "预算占用标识",notes = "预算占用标识,0:不占用,1:占用'")
    private String occupyBudgetFlag;
    /**
     * 产品分摊列表
     */
    @ApiModelProperty(value = "产品分摊列表",notes = "")
    private List<TpmExamineCircularProductSplitRespVo> productSplitList;
    /**
     * 附件列表
     */
    @ApiModelProperty(value = "附件列表",notes = "")
    private List<OrdinaryFileVo> protocolList;
    /**
     * 附件id列表
     */
    @ApiModelProperty(value = "附件id列表",notes = "后台接收id参数，前端无视")
    private String protocols;
    /**
     * 审批流程编码
     */
    @ApiModelProperty(value = "审批流程编码",notes = "")
    private String processNo;
    /**
     * 审批状态
     */
    @ApiModelProperty(value = "审批状态",notes = "")
    private String processStatus;

    /**
     * 分摊类型
     */
    @ApiModelProperty(value = "分摊类型")
    private String splitType;

    /**
     * 区域
     */
    @ApiModelProperty("区域")
    private String region;
    /**
     * 系统
     */
    @ApiModelProperty("零售商编码")
    private String systemCode;
    /**
     * 系统
     */
    @ApiModelProperty("零售商名称")
    private String systemName;

    @ApiModelProperty("CE上账状态")
    private String ceCommitStatus;

    @ApiModelProperty("费用池上账状态")
    private String sapTransferCommitStatus;

    @ApiModelProperty("费用池上账成功时间")
    private Date sapTransferCommitSuccessTime;

    @ApiModelProperty("费用池上账信息")
    private String sapTransferCommitMessage;

    @ApiModelProperty("SAP转款凭证编码")
    private String sapTransferCertCode;

//    @ApiModelProperty("上账编码")
//    private String upAccountCode;




    @ApiModelProperty(value = "考核月份")
    private String appraisalMonth;

    @ApiModelProperty(value = "开始时间",notes = "")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date startDate;

    @ApiModelProperty(value = "结束时间",notes = "")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date endDate;

    @ApiModelProperty(value = "活动形式",notes = "")
    private String activityForm;

    @ApiModelProperty(value = "活动形式名称",notes = "")
    private String activityFormName;

    @ApiModelProperty(value = "活动形式sap编码",notes = "")
    private String activitySapForm;

    @ApiModelProperty(value = "销售组编码",notes = "")
    private String salesGroupCode;

    @ApiModelProperty(value = "销售组名称")
    private String salesGroupName;

    @ApiModelProperty(value = "销售部门编码 ")
    private String salesDepartmentCode;

    @ApiModelProperty(value = "销售部门名称")
    private String salesDepartmentName;

    @ApiModelProperty("渠道")
    private String channel;

    @ApiModelProperty("是否上账")
    private String isUpAccount;

    @ApiModelProperty("费用池余额是否充足")
    private Boolean isBalanceEnough = true;

    @ApiModelProperty("费用池余额")
    private BigDecimal feePoolBalance;

    @ApiModelProperty("MDG客户编码")
    private String mdgCustomerCode;

    @ApiModelProperty("结案冲销抵扣金额")
    private BigDecimal auditChargeDeductionAmount;

    @ApiModelProperty("结案冲销未抵扣金额")
    private BigDecimal auditChargeNoDeductionAmount;
    @ApiModelProperty("是否分摊")
    private String isSplit;

//    @ApiModelProperty("上账编码(分子公司接口用)")
//    private String upAccountCodeSon;

    @ApiModelProperty("便签名称（取自审批工作流主题）")
    private String processTitle;
    /**
     * 渠道编码
     */
    @ApiModelProperty("渠道编码")
    private String channelCode;
    /**
     * 渠道名称
     */
    @ApiModelProperty("渠道名称")
    private String channelName;

    @ApiModelProperty("mdg客户编码集合")
    private List<String> mdgCusotmerCodes;


    @ApiModelProperty("创建人hr组织编码")
    private String orgCode;

    @ApiModelProperty("创建人hr组织名称")
    private String orgName;

    @ApiModelProperty("审批时间")
    private Date processDate;

    @ApiModelProperty("产品名称-冗余")
    private String productName;
}
