/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.expense.initiation.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.expense.initiation.sdk.dto.ExpenseInitiationDto;
import com.biz.crm.tpm.business.expense.initiation.sdk.dto.ExpenseInitiationSubmitDto;
import com.biz.crm.tpm.business.expense.initiation.sdk.service.ExpenseInitiationService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/expenseInitiation"})
@Api(tags={"\u8d39\u7528\u7acb\u9879"})
public class ExpenseInitiationController {
    private static final Logger log = LoggerFactory.getLogger(ExpenseInitiationController.class);
    @Autowired(required=false)
    private ExpenseInitiationService expenseInitiationService;
    @Autowired(required=false)
    private RedisLockService redisLockService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByConditions"})
    public Result<Page<ExpenseInitiationDto>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="expenseInitiation", value="\u8d39\u7528\u7acb\u9879\u5b9e\u4f53\u7c7b") ExpenseInitiationDto expenseInitiation) {
        try {
            Page page = this.expenseInitiationService.findByConditions(pageable, expenseInitiation);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"findById"})
    public Result<ExpenseInitiationDto> findById(@RequestParam(value="expenseInitiationCode") @ApiParam(name="expenseInitiationCode", value="\u8d39\u7528\u7acb\u9879\u7f16\u7801", required=true) String expenseInitiationCode) {
        try {
            ExpenseInitiationDto expenseInitiation = this.expenseInitiationService.findById(expenseInitiationCode);
            return Result.ok((Object)expenseInitiation);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @PostMapping
    public Result<?> create(@ApiParam(name="expenseInitiation", value="\u8d39\u7528\u7acb\u9879dto") @RequestBody ExpenseInitiationDto expenseInitiation) {
        try {
            this.expenseInitiationService.create(expenseInitiation);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    @PatchMapping
    public Result<?> update(@ApiParam(name="expenseInitiation", value="\u8d39\u7528\u7acb\u9879dto") @RequestBody ExpenseInitiationDto expenseInitiation) {
        try {
            this.expenseInitiationService.update(expenseInitiation);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664\u6570\u636e")
    @DeleteMapping
    public Result<?> delete(@ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") @RequestParam(value="ids") List<String> ids) {
        try {
            this.expenseInitiationService.delete(ids);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4e0b\u62c9\u5217\u8868")
    @PostMapping(value={"getList"})
    public Result<List<ExpenseInitiationDto>> getList(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @RequestBody ExpenseInitiationDto dto) {
        try {
            return Result.ok((Object)this.expenseInitiationService.getList(pageable, dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fc3\u9500\u89c4\u5212\u67e5\u770b\u8d39\u7528\u7acb\u9879")
    @GetMapping(value={"findByPromotionPlanCode"})
    public Result<Page<ExpenseInitiationDto>> findByPromotionPlanCode(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @RequestParam(value="code") @ApiParam(name="code", value="\u4fc3\u9500\u89c4\u5212\u7f16\u7801", required=true) String code) {
        try {
            Page page = this.expenseInitiationService.findByPromotionPlanCode(pageable, code);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u4fdd\u5b58\u5e76\u63d0\u4ea4\u5ba1\u6279")
    @PostMapping(value={"submitAndSetPass"})
    public Result<?> submitAndSetPass(@ApiParam(name="expenseInitiationSubmitDto", value="\u63d0\u4ea4\u5ba1\u6279dto") @RequestBody ExpenseInitiationSubmitDto expenseInitiationSubmitDto) {
        String lockKey = "";
        boolean lockSuccess = false;
        try {
            if (StringUtils.isNotBlank((CharSequence)expenseInitiationSubmitDto.getId())) {
                lockKey = "expense_initiation:lock:approve:" + expenseInitiationSubmitDto.getId();
                lockSuccess = this.redisLockService.tryLock(lockKey, TimeUnit.HOURS, 1L);
                Assert.isTrue((boolean)lockSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            }
            this.expenseInitiationService.submitAndSetPass(expenseInitiationSubmitDto);
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (lockSuccess) {
                this.redisLockService.unlock(lockKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u63d0\u4ea4\u5ba1\u6279\u6d41")
    @PostMapping(value={"submitApproval"})
    public Result<?> submitApproval(@ApiParam(name="expenseInitiationSubmitDto", value="\u63d0\u4ea4\u5ba1\u6279dto") @RequestBody ExpenseInitiationSubmitDto expenseInitiationSubmitDto) {
        String lockKey = "";
        boolean lockSuccess = false;
        try {
            Validate.notNull((Object)expenseInitiationSubmitDto.getId(), (String)"\u8bf7\u9009\u62e9\u6570\u636e\uff01", (Object[])new Object[0]);
            lockKey = "expense_initiation:lock:approve:" + expenseInitiationSubmitDto.getId();
            lockSuccess = this.redisLockService.tryLock(lockKey, TimeUnit.MINUTES, 3L);
            Assert.isTrue((boolean)lockSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            this.expenseInitiationService.submitApproval(expenseInitiationSubmitDto);
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (lockSuccess) {
                this.redisLockService.unlock(lockKey);
            }
        }
    }
}

