/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.expense.initiation.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.expense.initiation.local.entity.ExpenseInitiation;
import com.biz.crm.tpm.business.expense.initiation.local.mapper.ExpenseInitiationMapper;
import com.biz.crm.tpm.business.expense.initiation.sdk.dto.ExpenseInitiationDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class ExpenseInitiationRepository
extends ServiceImpl<ExpenseInitiationMapper, ExpenseInitiation> {
    @Autowired(required=false)
    private ExpenseInitiationMapper expenseInitiationMapper;

    public Page<ExpenseInitiationDto> findByConditions(Pageable pageable, ExpenseInitiationDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        if (StringUtils.isEmpty((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        return this.expenseInitiationMapper.findByConditions((Page<ExpenseInitiationDto>)page, dto);
    }

    public Page<ExpenseInitiationDto> findByPromotionPlanCode(Pageable pageable, String code) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<ExpenseInitiationDto> pageList = this.expenseInitiationMapper.findByPromotionPlanCode((Page<ExpenseInitiationDto>)page, code);
        return pageList;
    }

    public void removeExpenseInitiationByIds(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public ExpenseInitiation findByCode(String code) {
        return (ExpenseInitiation)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ExpenseInitiation::getExpenseInitiationCode, (Object)code)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
    }
}

