/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.expense.initiation.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.tpm.business.expense.initiation.local.entity.ExpenseInitiation;
import com.biz.crm.tpm.business.expense.initiation.local.entity.ExpenseInitiationDetail;
import com.biz.crm.tpm.business.expense.initiation.local.entity.ExpenseInitiationFiles;
import com.biz.crm.tpm.business.expense.initiation.local.repository.ExpenseInitiationDetailRepository;
import com.biz.crm.tpm.business.expense.initiation.local.repository.ExpenseInitiationFilesRepository;
import com.biz.crm.tpm.business.expense.initiation.local.repository.ExpenseInitiationRepository;
import com.biz.crm.tpm.business.expense.initiation.sdk.dto.ExpenseInitiationDetailDto;
import com.biz.crm.tpm.business.expense.initiation.sdk.dto.ExpenseInitiationDto;
import com.biz.crm.tpm.business.expense.initiation.sdk.dto.ExpenseInitiationFilesDto;
import com.biz.crm.tpm.business.expense.initiation.sdk.dto.ExpenseInitiationSubmitDto;
import com.biz.crm.tpm.business.expense.initiation.sdk.dto.log.ExpenseInitiationLogEventDto;
import com.biz.crm.tpm.business.expense.initiation.sdk.event.log.ExpenseInitiationLogEventListener;
import com.biz.crm.tpm.business.expense.initiation.sdk.service.ExpenseInitiationService;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.PromotionPlanService;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.GeneralExpensesVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="expenseInitiationService")
public class ExpenseInitiationServiceImpl
implements ExpenseInitiationService {
    @Autowired(required=false)
    private ExpenseInitiationRepository expenseInitiationRepository;
    @Autowired(required=false)
    private ExpenseInitiationDetailRepository expenseInitiationDetailRepository;
    @Autowired(required=false)
    private ExpenseInitiationFilesRepository expenseInitiationFilesRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private PromotionPlanService promotionPlanService;
    @Autowired(required=false)
    private ProcessBusinessService processBusinessService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    public Page<ExpenseInitiationDto> findByConditions(Pageable pageable, ExpenseInitiationDto expenseInitiation) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(expenseInitiation)) {
            expenseInitiation = new ExpenseInitiationDto();
        }
        return this.expenseInitiationRepository.findByConditions(pageable, expenseInitiation);
    }

    public ExpenseInitiationDto findById(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        ExpenseInitiation eiEntity = this.expenseInitiationRepository.findByCode(code);
        ExpenseInitiationDto dto = (ExpenseInitiationDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)eiEntity, ExpenseInitiationDto.class, HashSet.class, ArrayList.class, new String[0]);
        Collection filesDtos = this.nebulaToolkitService.copyCollectionByWhiteList(this.expenseInitiationFilesRepository.findByCode(eiEntity.getExpenseInitiationCode()), ExpenseInitiationFiles.class, ExpenseInitiationFilesDto.class, HashSet.class, ArrayList.class, new String[0]);
        Collection detailDtos = this.nebulaToolkitService.copyCollectionByWhiteList(this.expenseInitiationDetailRepository.findByCode(eiEntity.getExpenseInitiationCode()), ExpenseInitiationDetail.class, ExpenseInitiationDetailDto.class, HashSet.class, ArrayList.class, new String[0]);
        GeneralExpensesVo generalVo = this.promotionPlanService.findByDetailCodeGeneral(eiEntity.getExpensesCode());
        dto.setFiles(new ArrayList(filesDtos));
        dto.setDetails(new ArrayList(detailDtos));
        dto.setGeneral(generalVo);
        return dto;
    }

    @Transactional(rollbackFor={Exception.class})
    public void create(ExpenseInitiationDto expenseInitiation) {
        this.createValidate(expenseInitiation);
        FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
        List codeList = this.generateCodeService.generateCode("EI", 1, Integer.valueOf(5), 2L, TimeUnit.DAYS);
        expenseInitiation.setExpenseInitiationCode((String)codeList.get(0));
        expenseInitiation.setProcessStatus(ProcessStatusEnum.PREPARE.getKey());
        expenseInitiation.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        expenseInitiation.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        expenseInitiation.setTenantCode(TenantUtils.getTenantCode());
        expenseInitiation.setOrgCode(loginDetails.getOrgCode());
        expenseInitiation.setOrgName(loginDetails.getOrgName());
        this.store(expenseInitiation, expenseInitiation.getExpenseInitiationCode());
        ExpenseInitiationLogEventDto logEventDto = new ExpenseInitiationLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(expenseInitiation);
        SerializableBiConsumer & Serializable onCreate = ExpenseInitiationLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ExpenseInitiationLogEventListener.class, (SerializableBiConsumer)onCreate);
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(ExpenseInitiationDto expenseInitiation) {
        this.updateValidate(expenseInitiation);
        ExpenseInitiation eiEntityOld = (ExpenseInitiation)((Object)this.expenseInitiationRepository.getById((Serializable)((Object)expenseInitiation.getId())));
        if (!(ProcessStatusEnum.PREPARE.getKey().equals(eiEntityOld.getProcessStatus()) || ProcessStatusEnum.REJECT.getKey().equals(eiEntityOld.getProcessStatus()) || ProcessStatusEnum.RECOVER.getKey().equals(eiEntityOld.getProcessStatus()))) {
            throw new RuntimeException("\u53ea\u80fd\u7f16\u8f91\u5f85\u63d0\u4ea4\u3001\u9a73\u56de\u3001\u8ffd\u56de\u72b6\u6001\u7684\u6570\u636e\uff01");
        }
        this.expenseInitiationFilesRepository.deleteByCode(eiEntityOld.getExpenseInitiationCode());
        this.expenseInitiationDetailRepository.deleteByCode(eiEntityOld.getExpenseInitiationCode());
        expenseInitiation.setExpenseInitiationCode(null);
        expenseInitiation.setTenantCode(null);
        this.store(expenseInitiation, eiEntityOld.getExpenseInitiationCode());
        ExpenseInitiationLogEventDto logEventDto = new ExpenseInitiationLogEventDto();
        logEventDto.setOriginal((ExpenseInitiationDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)eiEntityOld, ExpenseInitiationDto.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        logEventDto.setNewest(expenseInitiation);
        SerializableBiConsumer & Serializable onUpdate = ExpenseInitiationLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ExpenseInitiationLogEventListener.class, (SerializableBiConsumer)onUpdate);
    }

    public void store(ExpenseInitiationDto expenseInitiation, String code) {
        ExpenseInitiation eiEntity = (ExpenseInitiation)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)expenseInitiation, ExpenseInitiation.class, HashSet.class, ArrayList.class, new String[0]));
        Collection eiDetails = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)expenseInitiation.getDetails(), ExpenseInitiationDetailDto.class, ExpenseInitiationDetail.class, HashSet.class, ArrayList.class, new String[0]);
        Collection files = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)expenseInitiation.getFiles(), ExpenseInitiationFilesDto.class, ExpenseInitiationFiles.class, HashSet.class, ArrayList.class, new String[0]);
        GeneralExpensesVo generalVo = this.promotionPlanService.findByDetailCodeGeneral(eiEntity.getExpensesCode());
        List codeList = this.generateCodeService.generateCode("EID", eiDetails.size(), Integer.valueOf(5), 2L, TimeUnit.DAYS);
        BigDecimal amount = BigDecimal.ZERO;
        int index = 0;
        for (ExpenseInitiationDetail e2 : eiDetails) {
            e2.setExpenseInitiationCode(code);
            e2.setTenantCode(TenantUtils.getTenantCode());
            e2.setExpenseInitiationDetailCode((String)codeList.get(index));
            amount = amount.add(e2.getApplyAmount());
            ++index;
        }
        files.forEach(e -> {
            e.setExpenseInitiationCode(code);
            e.setTenantCode(TenantUtils.getTenantCode());
        });
        Validate.isTrue((amount.compareTo(generalVo.getBalance()) <= 0 ? 1 : 0) != 0, (String)"\u7533\u8bf7\u91d1\u989d\u5927\u4e8e\u53ef\u7528\u4f59\u989d\uff01", (Object[])new Object[0]);
        eiEntity.setApplyAmount(amount);
        this.expenseInitiationRepository.saveOrUpdate((Object)eiEntity);
        this.expenseInitiationDetailRepository.saveBatch(eiDetails);
        this.expenseInitiationFilesRepository.saveBatch(files);
        expenseInitiation.setId(eiEntity.getId());
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List planlist = this.expenseInitiationRepository.listByIds(idList);
        Validate.notEmpty((Collection)planlist, (String)"\u6839\u636e\u63d0\u4f9b\u7684\u4e3b\u952e\u96c6\u5408\u4fe1\u606f\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u6570\u636e", (Object[])new Object[0]);
        for (ExpenseInitiation entity : planlist) {
            if (ProcessStatusEnum.PREPARE.getKey().equals(entity.getProcessStatus()) || ProcessStatusEnum.REJECT.getKey().equals(entity.getProcessStatus()) || ProcessStatusEnum.RECOVER.getKey().equals(entity.getProcessStatus())) continue;
            throw new RuntimeException("[" + entity.getExpenseInitiationCode() + "]\u672a\u5904\u4e8e\u3010\u5f85\u63d0\u4ea4\u3011\u3001\u3010\u9a73\u56de\u3011\u3001\u3010\u8ffd\u56de\u3011\u72b6\u6001\uff0c\u4e0d\u80fd\u5220\u9664\uff01");
        }
        this.expenseInitiationRepository.removeExpenseInitiationByIds(idList);
        Collection dtoList = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)planlist, ExpenseInitiation.class, ExpenseInitiationDto.class, HashSet.class, ArrayList.class, new String[0]);
        SerializableBiConsumer & Serializable onDelete = ExpenseInitiationLogEventListener::onDelete;
        for (ExpenseInitiationDto dto : dtoList) {
            ExpenseInitiationLogEventDto logEventDto = new ExpenseInitiationLogEventDto();
            logEventDto.setOriginal(dto);
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ExpenseInitiationLogEventListener.class, (SerializableBiConsumer)onDelete);
        }
    }

    public List<ExpenseInitiationDto> getList(Pageable pageable, ExpenseInitiationDto dto) {
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        Page<ExpenseInitiationDto> pageResult = this.expenseInitiationRepository.findByConditions(pageable, dto);
        return pageResult.getRecords();
    }

    public Page<ExpenseInitiationDto> findByPromotionPlanCode(Pageable pageable, String code) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        return this.expenseInitiationRepository.findByPromotionPlanCode(pageable, code);
    }

    @Transactional(rollbackFor={Exception.class})
    public void submitAndSetPass(ExpenseInitiationSubmitDto dto) {
        ProcessBusinessDto processBusiness = dto.getProcessBusiness();
        ExpenseInitiationDto expenseInitiationDto = (ExpenseInitiationDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, ExpenseInitiationDto.class, HashSet.class, ArrayList.class, new String[0]);
        Validate.isTrue((boolean)Objects.nonNull(processBusiness), (String)"\u6d41\u7a0b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)Objects.nonNull(expenseInitiationDto), (String)"\u8d39\u7528\u7acb\u9879\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        expenseInitiationDto.setDetails(dto.getDetails());
        expenseInitiationDto.setFiles(dto.getFiles());
        if (StringUtils.isNotBlank((CharSequence)expenseInitiationDto.getId())) {
            this.update(expenseInitiationDto);
        } else {
            this.create(expenseInitiationDto);
        }
        ExpenseInitiation entity = this.submitValEntity(expenseInitiationDto.getId());
        expenseInitiationDto = (ExpenseInitiationDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, ExpenseInitiationDto.class, HashSet.class, ArrayList.class, new String[0]);
        this.submitApprovalHandle(expenseInitiationDto, processBusiness);
    }

    private ExpenseInitiation submitValEntity(String id) {
        ExpenseInitiation entity = (ExpenseInitiation)((Object)this.expenseInitiationRepository.getById((Serializable)((Object)id)));
        Validate.notNull((Object)((Object)entity), (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u4fc3\u9500\u89c4\u5212", (Object[])new Object[0]);
        if (ProcessStatusEnum.COMMIT.getDictCode().equals(entity.getProcessStatus())) {
            throw new IllegalArgumentException("\u5f53\u524d\u6570\u636e[" + ProcessStatusEnum.COMMIT.getValue() + "],\u4e0d\u53ef\u63d0\u4ea4!");
        }
        if (ProcessStatusEnum.PASS.getDictCode().equals(entity.getProcessStatus())) {
            throw new IllegalArgumentException("\u5f53\u524d\u6570\u636e[" + ProcessStatusEnum.PASS.getValue() + "],\u4e0d\u53ef\u63d0\u4ea4!");
        }
        return entity;
    }

    @Transactional(rollbackFor={Exception.class})
    public void submitApproval(ExpenseInitiationSubmitDto dto) {
        Validate.isTrue((boolean)Objects.nonNull(dto.getProcessBusiness()), (String)"\u6d41\u7a0b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ExpenseInitiation entity = this.submitValEntity(dto.getId());
        ExpenseInitiationDto expenseInitiationDto = (ExpenseInitiationDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, ExpenseInitiationDto.class, HashSet.class, ArrayList.class, new String[0]);
        this.submitApprovalHandle(expenseInitiationDto, dto.getProcessBusiness());
    }

    public void rejectRecover(ExpenseInitiationDto dto) {
        GeneralExpensesVo generalVo = this.promotionPlanService.findByDetailCodeGeneral(dto.getExpensesCode());
        generalVo.setBalance(generalVo.getBalance().add(dto.getApplyAmount()));
        this.promotionPlanService.updateGeneral(generalVo);
    }

    public void submitApprovalHandle(ExpenseInitiationDto dto, ProcessBusinessDto processBusiness) {
        processBusiness.setBusinessNo(dto.getExpenseInitiationCode());
        JSONObject jsonObject = JsonUtils.toJSONObject((Object)dto);
        processBusiness.setBusinessFormJson(jsonObject.toJSONString());
        processBusiness.setBusinessCode("expense_initiation_process");
        ProcessBusinessVo processBusinessVo = this.processBusinessService.processStart(processBusiness);
        ExpenseInitiation entity = new ExpenseInitiation();
        entity.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
        entity.setProcessNo(processBusinessVo.getProcessNo());
        entity.setId(dto.getId());
        this.expenseInitiationRepository.updateById((Object)entity);
        GeneralExpensesVo generalVo = this.promotionPlanService.findByDetailCodeGeneral(dto.getExpensesCode());
        generalVo.setBalance(generalVo.getBalance().subtract(dto.getApplyAmount()));
        this.promotionPlanService.updateGeneral(generalVo);
    }

    private void createValidate(ExpenseInitiationDto expenseInitiation) {
        expenseInitiation.setId(null);
        this.commonValidate(expenseInitiation);
    }

    private void updateValidate(ExpenseInitiationDto expenseInitiation) {
        Validate.notBlank((CharSequence)expenseInitiation.getId(), (String)"\u4fee\u6539\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.commonValidate(expenseInitiation);
    }

    private void commonValidate(ExpenseInitiationDto expenseInitiation) {
        String configName = expenseInitiation.getConfigName();
        Validate.notNull((Object)expenseInitiation, (String)"\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((Collection)expenseInitiation.getDetails(), (String)"\u8d39\u7528\u7acb\u9879\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)expenseInitiation.getExpenseInitiationName(), (String)"\u8d39\u7528\u7acb\u9879\u540d\u79f0\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)expenseInitiation.getExpensesCode(), (String)"\u4fc3\u9500\u89c4\u5212\u660e\u7ec6\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)expenseInitiation.getAmount(), (String)"\u4fc3\u9500\u89c4\u5212\u91d1\u989d\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)configName, (String)"\u6a21\u677f\u540d\u79f0\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        expenseInitiation.getFiles().forEach(e -> {
            Validate.notBlank((CharSequence)e.getFileCode(), (String)"\u6587\u4ef6\u552f\u4e00\u8bc6\u522b\u53f7\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)e.getOriginalFileName(), (String)"\u539f\u59cb\u6587\u4ef6\u540d\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        });
        expenseInitiation.getDetails().forEach(e -> {
            Validate.notNull((Object)e.getStartDate(), (String)"\u5f00\u59cb\u65f6\u95f4\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)e.getEndDate(), (String)"\u7ed3\u675f\u65f6\u95f4\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            switch (configName) {
                case "\u5e38\u89c4\u7c7b\u7acb\u9879\u6a21\u677f": {
                    Validate.notNull((Object)e.getApplyAmount(), (String)"\u7533\u8bf7\u91d1\u989d\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                    Validate.notNull((Object)e.getEstimatedAmount(), (String)"\u9884\u8ba1\u9500\u552e\u91d1\u989d\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                    e.setEstimatedRoi(e.getEstimatedAmount().divide(e.getApplyAmount(), 2, 4));
                    break;
                }
                case "\u7269\u6599\u7c7b\u7acb\u9879\u6a21\u677f": {
                    Validate.notBlank((CharSequence)e.getMaterialCode(), (String)"\u7269\u6599\u7f16\u7801\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                    Validate.notNull((Object)e.getPrice(), (String)"\u5355\u4ef7\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                    Validate.notNull((Object)e.getQuantity(), (String)"\u6570\u91cf\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                    Validate.notNull((Object)e.getEstimatedAmount(), (String)"\u9884\u8ba1\u9500\u552e\u91d1\u989d\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                    e.setApplyAmount(e.getPrice().multiply(e.getQuantity()));
                    e.setEstimatedRoi(e.getEstimatedAmount().divide(e.getApplyAmount(), 2, 4));
                    break;
                }
                case "\u77ed\u4fe1\u7c7b\u7acb\u9879\u6a21\u677f": {
                    Validate.notNull((Object)e.getEstimatedSmPrice(), (String)"\u9884\u8ba1\u77ed\u4fe1\u4ef7\u683c\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                    Validate.notNull((Object)e.getSmQuantity(), (String)"\u53d1\u9001\u6570\u91cf\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                    Validate.notNull((Object)e.getEstimatedRoi(), (String)"\u9884\u8ba1ROI\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                    e.setApplyAmount(e.getEstimatedSmPrice().multiply(e.getSmQuantity()));
                    break;
                }
                case "\u4f1a\u5458\u8425\u9500\u7c7b\u7acb\u9879\u6a21\u677f": {
                    Validate.notNull((Object)e.getApplyAmount(), (String)"\u7533\u8bf7\u91d1\u989d\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                    Validate.notNull((Object)e.getEstimatedAmount(), (String)"\u9884\u8ba1\u9500\u552e\u91d1\u989d\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                    e.setEstimatedRoi(e.getEstimatedAmount().divide(e.getApplyAmount(), 2, 4));
                    break;
                }
                case "\u76f4\u64ad\u4f63\u91d1\u7c7b\u7acb\u9879\u6a21\u677f": {
                    Validate.notNull((Object)e.getEstimatedLiveAmount(), (String)"\u9884\u8ba1\u76f4\u64ad\u9500\u552e\u91d1\u989d\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                    Validate.notNull((Object)e.getLiveCommission(), (String)"\u76f4\u64ad\u4f63\u91d1\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                    Validate.notNull((Object)e.getCommission(), (String)"\u4f63\u91d1\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                    Validate.notNull((Object)e.getEstimatedAmount(), (String)"\u9884\u8ba1\u9500\u552e\u91d1\u989d\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                    e.setApplyAmount(e.getLiveCommission().add(e.getCommission()));
                    e.setEstimatedRoi(e.getEstimatedLiveAmount().add(e.getEstimatedAmount()).divide(e.getApplyAmount(), 2, 4));
                    break;
                }
                case "\u5751\u4f4d\u8d39\u7c7b\u7acb\u9879\u6a21\u677f": {
                    Validate.notNull((Object)e.getEstimatedLiveAmount(), (String)"\u9884\u8ba1\u76f4\u64ad\u9500\u552e\u91d1\u989d\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                    Validate.notNull((Object)e.getLiveCommission(), (String)"\u76f4\u64ad\u4f63\u91d1\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                    Validate.notNull((Object)e.getPitFee(), (String)"\u5751\u4f4d\u8d39\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                    e.setApplyAmount(e.getLiveCommission().add(e.getPitFee()));
                    e.setEstimatedRoi(e.getEstimatedLiveAmount().divide(e.getApplyAmount(), 2, 4));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("\u672a\u77e5\u7684\u6a21\u677f\u540d\u79f0\uff0c\u8bf7\u68c0\u67e5");
                }
            }
        });
    }
}

