/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.expense.initiation.local.workFlowListener;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.expense.initiation.local.entity.ExpenseInitiation;
import com.biz.crm.tpm.business.expense.initiation.local.repository.ExpenseInitiationRepository;
import com.biz.crm.tpm.business.expense.initiation.sdk.dto.ExpenseInitiationDto;
import com.biz.crm.tpm.business.expense.initiation.sdk.service.ExpenseInitiationService;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ExpenseInitiationProcessCallBackListener
implements ProcessCompleteListener {
    private static final Logger log = LoggerFactory.getLogger(ExpenseInitiationProcessCallBackListener.class);
    @Autowired(required=false)
    private ExpenseInitiationRepository expenseInitiationRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ExpenseInitiationService expenseInitiationService;

    public String getBusinessCode() {
        return "expense_initiation_process";
    }

    @Transactional(rollbackFor={Exception.class})
    public void onProcessComplete(ProcessStatusDto dto) {
        String processStatus = dto.getProcessStatus();
        ExpenseInitiation one = (ExpenseInitiation)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.expenseInitiationRepository.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(ExpenseInitiation::getExpenseInitiationCode, (Object)dto.getBusinessNo())).one());
        if (Objects.isNull((Object)one)) {
            return;
        }
        if (!ProcessStatusEnum.COMMIT.getDictCode().equals(one.getProcessStatus())) {
            return;
        }
        ExpenseInitiation two = new ExpenseInitiation();
        two.setId(one.getId());
        two.setProcessStatus(processStatus);
        if (ProcessStatusEnum.REJECT.getDictCode().equals(processStatus)) {
            ExpenseInitiationDto expenseInitiationDto = (ExpenseInitiationDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)one, ExpenseInitiationDto.class, HashSet.class, ArrayList.class, new String[0]);
            this.expenseInitiationService.rejectRecover(expenseInitiationDto);
        }
        this.expenseInitiationRepository.updateById((Object)two);
    }
}

