package com.biz.crm.tpm.business.expense.initiation.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.GeneralExpensesVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * 费用立项dto
 *
 * @author: yaoyongming
 * @date: 2022/11/7 10:14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ExpenseInitiationDto", description = "费用立项dto")
public class ExpenseInitiationDto extends TenantFlagOpDto {

    /**
     * 费用立项编码
     */
    @ApiModelProperty("费用立项编码")
    private String expenseInitiationCode;
    /**
     * 费用立项编码
     */
    @ApiModelProperty("费用立项编码")
    private String codeOrName;

    /**
     * 费用立项编码
     */
    @ApiModelProperty("费用立项编码")
    private List<String> selectedCodeList;

    /**
     * 费用立项名称
     */
    @ApiModelProperty("费用立项名称")
    private String expenseInitiationName;

    /**
     * 促销规划明细编码
     */
    @ApiModelProperty("促销规划明细编码")
    private String expensesCode;

    /**
     * 促销规划名称
     */
    @ApiModelProperty("促销规划名称")
    private String promotionPlanName;

    /**
     * 促销规划金额
     */
    @ApiModelProperty("促销规划金额")
    private BigDecimal amount;

    /**
     * 促销规划可用余额
     */
    @ApiModelProperty("促销规划可用余额")
    private BigDecimal balance;

    /**
     * 申请金额
     */
    @ApiModelProperty("申请金额")
    private BigDecimal applyAmount;

    /**
     * 配置编码
     */
    @ApiModelProperty("配置编码")
    private String configCode;

    /**
     * 配置名称
     */
    @ApiModelProperty("配置名称")
    private String configName;

    /**
     * 审批流程编码
     */
    @ApiModelProperty("审批流程编码")
    private String processNo;

    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    private String processStatus;

    /**
     * hr组织
     */
    @ApiModelProperty("hr组织")
    private String orgCode;

    /**
     * hr组织名称
     */
    @ApiModelProperty("hr组织名称")
    private String orgName;

    /**
     * 附件
     */
    @ApiModelProperty("促销规划金额")
    private List<ExpenseInitiationFilesDto> files;

    /**
     * 费用立项明细
     */
    @ApiModelProperty("费用立项明细")
    private List<ExpenseInitiationDetailDto> details;

    /**
     * 促销规划明细
     */
    @ApiModelProperty("促销规划明细")
    private GeneralExpensesVo general;
}
