package com.biz.crm.tpm.business.expense.initiation.sdk.event.log;

import com.biz.crm.tpm.business.expense.initiation.sdk.dto.log.ExpenseInitiationLogEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * 日志监听
 *
 * @author: yaoyongming
 * @date: 2022/11/8 9:44
 */
public interface ExpenseInitiationLogEventListener extends NebulaEvent {
    /**
     * 创建事件
     *
     * @param eventDto
     */
    void onCreate(ExpenseInitiationLogEventDto eventDto);
    /**
     * 删除事件
     *
     * @param eventDto
     */
    void onDelete(ExpenseInitiationLogEventDto eventDto);
    /**
     * 更新日志
     *
     * @param eventDto
     */
    void onUpdate(ExpenseInitiationLogEventDto eventDto);
    /**
     * 启用
     *
     * @param eventDto
     */
    void onEnable(ExpenseInitiationLogEventDto eventDto);
    /**
     * 禁用
     *
     * @param eventDto
     */
    void onDisable(ExpenseInitiationLogEventDto eventDto);
}
