//package com.biz.crm.tpm.business.inventory.check.manage.feign.feign;
//
//import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
//import com.biz.crm.business.common.sdk.model.Result;
//
//import com.biz.crm.tpm.business.inventory.check.manage.feign.feign.internal.TpmInventoryCheckServiceFeignImpl;
//import com.biz.crm.tpm.business.inventory.check.manage.sdk.dto.TpmInventoryCheckDto;
//import com.biz.crm.tpm.business.inventory.check.manage.sdk.vo.TpmInventoryCheckVo;
//import io.swagger.annotations.ApiOperation;
//import io.swagger.annotations.ApiParam;
//import org.springframework.cloud.openfeign.FeignClient;
//import org.springframework.data.domain.Pageable;
//import org.springframework.data.web.PageableDefault;
//import org.springframework.web.bind.annotation.*;
//
//import java.util.List;
//
///**
// * 库存盘点feign
// *
// * @author heding
// * @create 2022-12-13 18:01:38
// */
//@FeignClient(
//        name = "${tpm.feign-client.name:crm-tpm}",
//        path = "crm-tpm",
//        fallbackFactory = TpmInventoryCheckServiceFeignImpl.class)
//public
//interface TpmInventoryCheckServiceFeign {
//
//    /**
//     * 分页查询数据
//     *
//     * @param pageable 分页对象
//     * @param dto      查询条件实体
//     * @return 所有数据
//     */
//    @ApiOperation(value = "分页查询数据")
//    @GetMapping("/v1/tpmInventoryCheck/findByConditions")
//    Result<Page<TpmInventoryCheckVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
//                                                       @ApiParam(name = "dto", value = "库存盘点")@SpringQueryMap TpmInventoryCheckDto dto);
//
//    /**
//     * 新增数据
//     *
//     * @param dto dto
//     * @return 新增结果
//     */
//    @ApiOperation(value = "新增数据")
//    @PostMapping("/v1/tpmInventoryCheck")
//    Result<TpmInventoryCheckVo> create(@ApiParam(name = "dto", value = "库存新增") @RequestBody TpmInventoryCheckDto dto);
//
//    /**
//     * 删除数据
//     *
//     * @param idList 主键集合
//     * @return 删除结果
//     */
//    @ApiOperation(value = "删除数据")
//    @DeleteMapping("/v1/tpmInventoryCheck")
//    Result<?> delete(@ApiParam(name = "idList", value = "主键集合") @RequestParam("idList") List<String> idList);
//
//    /**
//     * 通过主键查询单条数据回显
//     *
//     * @param id 主键
//     * @return 单条数据
//     */
//    @ApiOperation(value = "通过主键查询单条数据")
//    @GetMapping("/v1/tpmInventoryCheck/{id}")
//    Result<TpmInventoryCheckVo> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id);
//
//    /**
//     * 编辑数据
//     *
//     * @param dto 实体对象
//     * @return 编辑结果
//     */
//    @ApiOperation(value = "编辑数据")
//    @PatchMapping("/v1/tpmInventoryCheck")
//    Result<TpmInventoryCheckVo> update(@ApiParam(name = "tpmInventoryCheck", value = "库存信息编辑") @RequestBody TpmInventoryCheckDto dto);
//
//    /**
//     * 禁用
//     *
//     * @param idList 主键集合
//     * @return 禁用结果
//     */
//    @ApiOperation(value = "批量根据id禁用")
//    @PatchMapping("/v1/tpmInventoryCheck/disable")
//    Result<?> disable(@ApiParam(name = "idList", value = "主键集合") @RequestBody List<String> idList);
//}
