//package com.biz.crm.tpm.business.inventory.check.manage.feign.internal;
//
//import cn.hutool.core.lang.Assert;
//import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
//import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
//import com.biz.crm.business.common.sdk.model.Result;
//
//import com.biz.crm.tpm.business.inventory.check.manage.feign.feign.TpmInventoryCheckServiceFeign;
//import com.biz.crm.tpm.business.inventory.check.manage.sdk.constant.TpmInventoryCheckConstant;
//import com.biz.crm.tpm.business.inventory.check.manage.sdk.dto.CowMasterGuestInventoryDto;
//import com.biz.crm.tpm.business.inventory.check.manage.sdk.dto.TpmInventoryCheckDto;
//import com.biz.crm.tpm.business.inventory.check.manage.sdk.service.TpmInventoryCheckService;
//import com.biz.crm.tpm.business.inventory.check.manage.sdk.vo.TpmInventoryCheckVo;
//import lombok.extern.slf4j.Slf4j;
//import org.apache.commons.lang3.StringUtils;
//import org.apache.commons.lang3.Validate;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.data.domain.Pageable;
//import org.springframework.stereotype.Service;
//
//import java.util.List;
//
//import static com.biz.crm.tpm.business.inventory.check.manage.sdk.constant.TpmInventoryCheckConstant.PATTERN;
//
///**
// * 库存盘点(TpmInventoryCheck)表服务实现类
// *
// * @author heding
// * @create 2022-12-13 18:50:12
// */
//@Slf4j
//@Service
//public class TpmInventoryCheckVoServiceImpl implements TpmInventoryCheckService {
//
//    @Autowired(required = false)
//    private TpmInventoryCheckServiceFeign tpmInventoryCheckServiceFeign;
//
//    /**
//     * 按id查询详情
//     *
//     * @param id 主键ID
//     * @return com.biz.crm.tpm.business.inventory.check.manage.sdk.vo.TpmInventoryCheckVo
//     */
//    @Override
//    public TpmInventoryCheckVo findById(String id) {
//        if (StringUtils.isEmpty(id)) {
//            return null;
//        }
//        Result<TpmInventoryCheckVo> result = tpmInventoryCheckServiceFeign.findById(id);
//        Assert.isTrue(result.isSuccess(), result.getMessage());
//        return result.getResult();
//    }
//
//    /**
//     * 删除
//     *
//     * @param idList 主键集合
//     */
//    @Override
//    public void delete(List<String> idList) {
//        Validate.isTrue(!CollectionUtils.isEmpty(idList), "删除数据时，主键集合不能为空！");
//        Result result = tpmInventoryCheckServiceFeign.delete(idList);
//        Assert.isTrue(result.isSuccess(), result.getMessage());
//    }
//
//    /**
//     * 新增数据
//     *
//     * @param dto 实体对象
//     * @return 新增结果
//     */
//    @Override
//    public TpmInventoryCheckVo create(TpmInventoryCheckDto dto) {
//        Validate.notNull(dto, "对象信息不能为空！");
//        Result<TpmInventoryCheckVo> result = tpmInventoryCheckServiceFeign.create(dto);
//        Assert.isTrue(result.isSuccess(), result.getMessage());
//        return result.getResult();
//    }
//
//    /**
//     * 基础共同校验
//     *
//     * @param dto 实体对象
//     */
//    private void commonValidate(TpmInventoryCheckDto dto) {
//        Validate.notNull(dto, "对象信息不能为空！");
//        Validate.notNull(dto.getSourceType(), "数据来源不能为空！");
//        Validate.notNull(dto.getInventoryType(), "库存类型不能为空！");
//        Validate.notNull(dto.getDateIsLarge(), "是否大日期不能为空！");
//        Validate.notNull(dto.getBusinessFormatCode(), "业态必须选择！");
//        Validate.notNull(dto.getBusinessUnitCode(), "业务单元必须选择！");
//        Validate.notNull(dto.getSalesOrgName(), "销售组织不能为空！");
//        Validate.notNull(dto.getTerminalRegionName(), "区域不能为空！");
//        Validate.notNull(dto.getProductName(), "商品名称不能为空！");
//        Validate.notNull(dto.getProductCode(), "商品编码不能为空！");
//        if (TpmInventoryCheckConstant.BRANCH_WAREHOUSE_INVENTORY.equals(dto.getInventoryType())) {
//            Validate.notNull(dto.getBranchWarehouse(), "分仓不能为空！");
//        } else if (TpmInventoryCheckConstant.TERMINAL_INVENTORY.equals(dto.getInventoryType())) {
//            Validate.notNull(dto.getTerminalCode(), "门店编码不能为空！");
//            Validate.notNull(dto.getTerminalName(), "门店名称不能为空！");
//        } else if (TpmInventoryCheckConstant.CUSTOMER_INVENTORY.equals(dto.getInventoryType())) {
//            Validate.notNull(dto.getCustomerCode(), "客户编码不能为空！");
//            Validate.notNull(dto.getCustomerName(), "客户名称不能为空！");
//        }
//        Validate.notNull(dto.getProductionStartDate(), "产品日期必须选择！");
//        Validate.notNull(dto.getExpirationDate(), "保质期不能为空！");
//        Validate.matchesPattern(String.valueOf(dto.getExpirationDays()), PATTERN, "保质期剩余天数必须为数值！");
//        Validate.matchesPattern(String.valueOf(dto.getQuantity()), PATTERN, "数量必须为数值！");
//        Validate.matchesPattern(String.valueOf(dto.getGiftNumber()), PATTERN, "赠品数量必须为数值！");
//        Validate.notNull(dto.getDateOfReporting(), "库存提报日期必须选择！");
//        if (dto.getRemark() != null) {
//            Validate.isTrue(dto.getRemark().length() < 100, "最大备注长度为100");
//        }
//    }
//
//    /**
//     * 分页查询数据
//     *
//     * @param pageable 分页对象
//     * @param dto      查询条件实体
//     * @return 所有数据
//     */
//    @Override
//    public Page<TpmInventoryCheckVo> findByConditions(Pageable pageable, TpmInventoryCheckDto dto) {
//        Result<Page<TpmInventoryCheckVo>> result = tpmInventoryCheckServiceFeign.findByConditions(pageable, dto);
//        Assert.isTrue(result.isSuccess(), result.getMessage());
//        return result.getResult();
//    }
//
//    /**
//     * 编辑数据
//     *
//     * @param dto 实体对象
//     * @return 编辑结果
//     */
//    @Override
//    public TpmInventoryCheckVo update(TpmInventoryCheckDto dto) {
//        commonValidate(dto);
//        Result<TpmInventoryCheckVo> result = tpmInventoryCheckServiceFeign.update(dto);
//        Assert.isTrue(result.isSuccess(), result.getMessage());
//        return result.getResult();
//    }
//
//    /**
//     * 禁用
//     *
//     * @param idList 主键集合
//     * @return 禁用结果
//     */
//    @Override
//    public void disable(List<String> idList) {
//        Validate.notEmpty(idList, "待禁用的数据主键不能为空");
//        Result result = tpmInventoryCheckServiceFeign.disable(idList);
//        Assert.isTrue(result.isSuccess(), result.getMessage());
//    }
//
//    @Override
//    public List<TpmInventoryCheckVo> findAllByConditions(TpmInventoryCheckDto dto) {
//        throw new UnsupportedOperationException();
//    }
//
//    @Override
//    public Integer getTotalByConditions(TpmInventoryCheckDto dto) {
//        throw new UnsupportedOperationException();
//    }
//
//    @Override
//    public void pullInventoryDataList(CowMasterGuestInventoryDto dto) {
//        throw new UnsupportedOperationException();
//    }
//
//    /**
//     * 批量新增
//     *
//     * @param importList 对象集合
//     * @return 新增结果
//     */
//    @Override
//    public void importSave(List<TpmInventoryCheckDto> importList) {
//        throw new UnsupportedOperationException();
//    }
//
//}
