/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.inventory.check.manage.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgBaseDto;
import com.biz.crm.tpm.business.inventory.check.manage.sdk.dto.TpmInventoryCheckDto;
import com.biz.crm.tpm.business.inventory.check.manage.sdk.service.TpmInventoryCheckService;
import com.biz.crm.tpm.business.inventory.check.manage.sdk.vo.TpmInventoryCheckVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/tpmInventoryCheck"})
@Api(tags={"TPM-\u5e93\u5b58\u76d8\u70b9\u7ba1\u7406"})
public class TpmInventoryCheckController {
    private static final Logger log = LoggerFactory.getLogger(TpmInventoryCheckController.class);
    @Autowired(required=false)
    private TpmInventoryCheckService tpmInventoryCheckService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6570\u636e")
    @GetMapping(value={"findByConditions"})
    public Result<Page<TpmInventoryCheckVo>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="\u5e93\u5b58\u76d8\u70b9") TpmInventoryCheckDto dto) {
        try {
            Page page = this.tpmInventoryCheckService.findByConditions(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @PostMapping
    public Result<TpmInventoryCheckVo> create(@ApiParam(name="dto", value="\u5e93\u5b58\u65b0\u589e") @RequestBody TpmInventoryCheckDto dto) {
        try {
            TpmInventoryCheckVo result = this.tpmInventoryCheckService.create(dto);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664\u6570\u636e")
    @DeleteMapping
    public Result<?> delete(@ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") @RequestParam(value="ids") List<String> ids) {
        try {
            this.tpmInventoryCheckService.delete(ids);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"{id}"})
    public Result<TpmInventoryCheckVo> findById(@PathVariable @ApiParam(name="id", value="\u4e3b\u952eid") String id) {
        try {
            TpmInventoryCheckVo result = this.tpmInventoryCheckService.findById(id);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7f16\u8f91\u6570\u636e")
    @PatchMapping
    public Result<TpmInventoryCheckVo> update(@ApiParam(name="dto", value="\u5e93\u5b58\u4fe1\u606f\u7f16\u8f91") @RequestBody TpmInventoryCheckDto dto) {
        try {
            TpmInventoryCheckVo result = this.tpmInventoryCheckService.update(dto);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u6839\u636eid\u7981\u7528")
    @PatchMapping(value={"disable"})
    public Result<?> disable(@ApiParam(name="idList", value="\u4e3b\u952e\u96c6\u5408") @RequestBody List<String> idList) {
        try {
            this.tpmInventoryCheckService.disable(idList);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u62c9\u53d6\u725b\u8981\u5ba2\u6570\u636e")
    @PostMapping(value={"pullInventoryDataList"})
    public Result<?> pullInventoryDataList(@ApiParam(name="dto", value="\u725b\u8981\u5ba2\u6570\u636e\u67e5\u8be2\u6761\u4ef6") @RequestBody TpmInventoryCheckDto dto) {
        try {
            this.tpmInventoryCheckService.pullInventoryDataList(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u62c9\u53d6\u5206\u4ed3\u5927\u65e5\u671f\u5e93\u5b58\u6570\u636e")
    @PostMapping(value={"pullTpmInventoryList"})
    public Result<?> pullTpmInventoryList(@ApiParam(name="dto", value="\u6570\u636e\u4e2d\u53f0\u6570\u636e\u67e5\u8be2\u6761\u4ef6") @RequestBody MasterDataMdgBaseDto dto) {
        try {
            this.tpmInventoryCheckService.pullTpmInventoryList(dto);
            return Result.ok((String)"\u6279\u91cf\u62c9\u53d6\u5206\u4ed3\u5927\u65e5\u671f\u5e93\u5b58\u6570\u636e\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u624b\u52a8\u89e6\u53d1\u5b9a\u65f6\u66f4\u65b0")
    @GetMapping
    public Result<?> pullUpdateChange() {
        try {
            this.tpmInventoryCheckService.pullUpdateChange();
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6309\u6761\u4ef6\u67e5\u8be2\u5e93\u5b58\u6570\u91cf")
    @GetMapping(value={"getQuantityByCondition"})
    public Result<Integer> getQuantityByCondition(@ApiParam(name="dto", value="\u725b\u8981\u5ba2\u6570\u636e\u67e5\u8be2\u6761\u4ef6") TpmInventoryCheckDto dto) {
        try {
            dto.setDateIsLarge(BooleanEnum.TRUE.getNumStr());
            Integer result = this.tpmInventoryCheckService.getQuantityByCondition(dto);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

