/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.inventory.check.manage.local.repository;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.interfaces.Compare;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.inventory.check.manage.local.entity.TpmInventoryCheck;
import com.biz.crm.tpm.business.inventory.check.manage.local.mapper.TpmInventoryCheckMapper;
import com.biz.crm.tpm.business.inventory.check.manage.sdk.dto.InventoryDataVerifyDto;
import com.biz.crm.tpm.business.inventory.check.manage.sdk.dto.OperateInventoryCheckDto;
import com.biz.crm.tpm.business.inventory.check.manage.sdk.dto.TpmInventoryCheckDto;
import com.biz.crm.tpm.business.inventory.check.manage.sdk.vo.InventoryProductVo;
import com.biz.crm.tpm.business.inventory.check.manage.sdk.vo.TpmInventoryCheckVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class TpmInventoryCheckRepository
extends ServiceImpl<TpmInventoryCheckMapper, TpmInventoryCheck> {
    @Autowired(required=false)
    private TpmInventoryCheckMapper tpmInventoryCheckMapper;

    public Page<TpmInventoryCheckVo> findByConditions(Pageable pageable, TpmInventoryCheckDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<TpmInventoryCheckVo> pageList = this.tpmInventoryCheckMapper.findByConditions((Page<TpmInventoryCheckDto>)page, dto);
        return pageList;
    }

    public Page<TpmInventoryCheckVo> findAllByConditions(Pageable pageable, TpmInventoryCheckDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)200));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.tpmInventoryCheckMapper.findAllByConditions((Page<TpmInventoryCheckDto>)page, dto);
    }

    public Integer getTotalByConditions(TpmInventoryCheckDto dto) {
        return this.tpmInventoryCheckMapper.getTotalByConditions(dto);
    }

    public List<TpmInventoryCheck> findByVerifyCodes(List<String> verifyCodeList) {
        if (CollectionUtils.isEmpty(verifyCodeList)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(TpmInventoryCheck::getVerifyCode, verifyCodeList)).eq(TpmInventoryCheck::getSourceType, (Object)"cow_master_guest")).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<TpmInventoryCheck> findRepetition(InventoryDataVerifyDto dto) {
        if (ObjectUtils.isEmpty((Object)dto) || StringUtils.isEmpty((CharSequence)dto.getProductCode()) || StringUtils.isEmpty((CharSequence)dto.getBusinessFormatCode()) || StringUtils.isEmpty((CharSequence)dto.getBusinessUnitCode()) || StringUtils.isEmpty((CharSequence)dto.getSalesOrgCode()) || StringUtils.isEmpty((CharSequence)dto.getTerminalRegionName())) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TpmInventoryCheck::getSourceType, (Object)"1")).eq(TpmInventoryCheck::getProductCode, (Object)dto.getProductCode())).eq(TpmInventoryCheck::getBusinessFormatCode, (Object)dto.getBusinessFormatCode())).eq(TpmInventoryCheck::getBusinessUnitCode, (Object)dto.getBusinessUnitCode())).eq(TpmInventoryCheck::getSalesOrgCode, (Object)dto.getSalesOrgCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TpmInventoryCheck::getTerminalRegionName, (Object)dto.getTerminalRegionName())).eq("\u96f6\u552e\u5546".equals(dto.getFieldType()), TpmInventoryCheck::getCustomerRetailerCode, (Object)dto.getCustomerRetailerCode())).eq("\u5ba2\u6237\u5e93\u5b58".equals(dto.getFieldType()), TpmInventoryCheck::getCustomerCode, (Object)dto.getCustomerCode())).eq("\u5206\u4ed3\u5e93\u5b58".equals(dto.getFieldType()), TpmInventoryCheck::getBranchWarehouse, (Object)dto.getBranchWarehouse())).eq("\u95e8\u5e97\u5e93\u5b58".equals(dto.getFieldType()), TpmInventoryCheck::getTerminalCode, (Object)dto.getTerminalCode())).list();
    }

    public List<TpmInventoryCheck> findVerifyDto(InventoryDataVerifyDto VerifyDto) {
        if (ObjectUtils.isEmpty((Object)VerifyDto)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TpmInventoryCheck::getSourceType, (Object)"1")).eq(TpmInventoryCheck::getVerifyCode, (Object)VerifyDto.getVerifyCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq("\u96f6\u552e\u5546".equals(VerifyDto.getFieldType()), TpmInventoryCheck::getCustomerRetailerCode, (Object)VerifyDto.getFieldCode())).eq("\u5ba2\u6237\u5e93\u5b58".equals(VerifyDto.getFieldType()), TpmInventoryCheck::getCustomerCode, (Object)VerifyDto.getFieldCode())).eq("\u5206\u4ed3\u5e93\u5b58".equals(VerifyDto.getFieldType()), TpmInventoryCheck::getBranchWarehouse, (Object)VerifyDto.getFieldCode())).eq("\u95e8\u5e97\u5e93\u5b58".equals(VerifyDto.getFieldType()), TpmInventoryCheck::getTerminalCode, (Object)VerifyDto.getFieldCode())).list();
    }

    public List<TpmInventoryCheck> findByMdgVerifyCodes(List<String> verifyCodeList) {
        if (CollectionUtils.isEmpty(verifyCodeList)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(TpmInventoryCheck::getVerifyCode, verifyCodeList)).eq(TpmInventoryCheck::getSourceType, (Object)"master_data_mdg")).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<TpmInventoryCheck> findByMdgWarehouse(List<String> warehouseList) {
        if (CollectionUtils.isEmpty(warehouseList)) {
            return new ArrayList<TpmInventoryCheck>();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(TpmInventoryCheck::getBranchWarehouse, warehouseList)).eq(TpmInventoryCheck::getSourceType, (Object)"master_data_mdg")).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<TpmInventoryCheck> findByTerminalCodeList(List<String> terminalCodeList) {
        if (CollectionUtils.isEmpty(terminalCodeList)) {
            return new ArrayList<TpmInventoryCheck>();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(TpmInventoryCheck::getTerminalCode, terminalCodeList)).eq(TpmInventoryCheck::getSourceType, (Object)"cow_master_guest")).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<TpmInventoryCheck> findListByConditions(TpmInventoryCheckDto dto) {
        if (StringUtils.isEmpty((CharSequence)dto.getInventoryType()) && StringUtils.isEmpty((CharSequence)dto.getSalesOrgCode()) && StringUtils.isEmpty((CharSequence)dto.getProductionStartDate()) && StringUtils.isEmpty((CharSequence)dto.getCustomerRetailerCode()) && StringUtils.isEmpty((CharSequence)dto.getProductCode())) {
            return new ArrayList<TpmInventoryCheck>();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((CharSequence)dto.getProductionStartDate()), TpmInventoryCheck::getProductionStartDate, (Object)dto.getProductionStartDate())).eq(StringUtils.isNotEmpty((CharSequence)dto.getTerminalRegionCode()), TpmInventoryCheck::getTerminalRegionCode, (Object)dto.getTerminalRegionCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getCustomerRetailerCode()), TpmInventoryCheck::getCustomerRetailerCode, (Object)dto.getCustomerRetailerCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getTerminalCode()), TpmInventoryCheck::getTerminalCode, (Object)dto.getTerminalCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getProductCode()), TpmInventoryCheck::getProductCode, (Object)dto.getProductCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getInventoryType()), TpmInventoryCheck::getInventoryType, (Object)dto.getInventoryType())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getBusinessUnitCode()), TpmInventoryCheck::getBusinessUnitCode, (Object)dto.getBusinessUnitCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getBusinessFormatCode()), TpmInventoryCheck::getBusinessFormatCode, (Object)dto.getBusinessFormatCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getSalesOrgCode()), TpmInventoryCheck::getSalesOrgCode, (Object)dto.getSalesOrgCode())).le(ObjectUtil.isNotNull((Object)dto.getDateOfReporting()), TpmInventoryCheck::getDateOfReporting, (Object)dto.getDateOfReportingStr())).list();
    }

    public void updateExpirationDays() {
        this.tpmInventoryCheckMapper.updateExpirationDays();
    }

    public Page<InventoryProductVo> findAllData(InventoryProductVo dto, Pageable pageable) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.tpmInventoryCheckMapper.findAllData(dto, page);
    }

    public void updateBatchData(List<InventoryProductVo> inventoryProductVos) {
        this.tpmInventoryCheckMapper.updateBatchData(inventoryProductVos);
    }

    public void saveBatchData(Collection<TpmInventoryCheck> saveList) {
        this.tpmInventoryCheckMapper.saveBatchData(saveList);
    }

    public Integer getQuantityByCondition(TpmInventoryCheckDto dto) {
        if (StringUtils.isNotEmpty((CharSequence)dto.getTerminalRegionCode()) && dto.getTerminalRegionCode().contains(",")) {
            dto.setTerminalRegionCodeList(Arrays.asList(dto.getTerminalRegionCode().split(",")));
            dto.setTerminalRegionCode(null);
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getCustomerRetailerCode()) && dto.getCustomerRetailerCode().contains(",")) {
            dto.setCustomerRetailerCodeList(Arrays.asList(dto.getCustomerRetailerCode().split(",")));
            dto.setCustomerRetailerCode(null);
        }
        return this.tpmInventoryCheckMapper.getQuantityByCondition(dto);
    }

    public List<TpmInventoryCheck> findListToOperate(OperateInventoryCheckDto operateInventoryCheckDto) {
        LambdaQueryChainWrapper queryChainWrapper;
        String maxProductDate = operateInventoryCheckDto.getThisProductProductionDateStr();
        List productCodeList = operateInventoryCheckDto.getProductCodeList();
        List terminalCodeList = operateInventoryCheckDto.getTerminalCodeList();
        List warHouseNameList = operateInventoryCheckDto.getWarHouseNameList();
        List regionList = operateInventoryCheckDto.getRegionNameList();
        List systemNameList = operateInventoryCheckDto.getSystemNameList();
        ArrayList list = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)terminalCodeList)) {
            queryChainWrapper = (LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().le(TpmInventoryCheck::getProductionStartDate, (Object)maxProductDate)).in(TpmInventoryCheck::getProductCode, (Collection)productCodeList)).in(TpmInventoryCheck::getCustomerRetailerName, (Collection)systemNameList)).in(TpmInventoryCheck::getTerminalRegionName, (Collection)regionList)).eq(TpmInventoryCheck::getInventoryType, (Object)"TERMINAL_INVENTORY");
            queryChainWrapper.in(TpmInventoryCheck::getTerminalCode, (Collection)terminalCodeList);
            list.addAll(queryChainWrapper.list());
        }
        if (!CollectionUtils.isEmpty((Collection)warHouseNameList)) {
            queryChainWrapper = (LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().le(TpmInventoryCheck::getProductionStartDate, (Object)maxProductDate)).in(TpmInventoryCheck::getProductCode, (Collection)productCodeList)).in(TpmInventoryCheck::getCustomerRetailerName, (Collection)systemNameList)).in(TpmInventoryCheck::getTerminalRegionName, (Collection)regionList)).eq(TpmInventoryCheck::getInventoryType, (Object)"BRANCH_WAREHOUSE_INVENTORY");
            queryChainWrapper.in(TpmInventoryCheck::getBranchWarehouse, (Collection)warHouseNameList);
            list.addAll(queryChainWrapper.list());
        }
        return list;
    }

    public void resetCowMasterGuestPullSign() {
        LambdaUpdateChainWrapper wrapper = this.lambdaUpdate();
        this.buildCowMasterGuestQuery((Compare<?, SFunction<TpmInventoryCheck, ?>>)wrapper);
        ((LambdaUpdateChainWrapper)wrapper.set(TpmInventoryCheck::getPullSign, (Object)BooleanEnum.FALSE.getNumStr())).update();
    }

    public void buildCowMasterGuestQuery(Compare<?, SFunction<TpmInventoryCheck, ?>> wrapper) {
        wrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode());
        wrapper.eq(TpmInventoryCheck::getSourceType, (Object)"cow_master_guest");
        wrapper.eq(TpmInventoryCheck::getInventoryType, (Object)"TERMINAL_INVENTORY");
        wrapper.eq(TpmInventoryCheck::getBusinessUnitCode, (Object)BusinessUnitEnum.VERTICAL.getCode());
        wrapper.eq(TpmInventoryCheck::getBusinessFormatCode, (Object)BusinessFormatEnum.NORMAL.getCode());
    }

    public void updateCowMasterGuestToZero() {
        LambdaQueryChainWrapper wrapper = this.lambdaQuery();
        this.buildCowMasterGuestQuery((Compare<?, SFunction<TpmInventoryCheck, ?>>)wrapper);
        wrapper.eq(TpmInventoryCheck::getPullSign, (Object)BooleanEnum.TRUE.getNumStr());
        wrapper.isNotNull(TpmInventoryCheck::getTerminalCode);
        wrapper.select(new SFunction[]{TpmInventoryCheck::getTerminalCode});
        wrapper.groupBy(TpmInventoryCheck::getTerminalCode);
        List terminalList = wrapper.list();
        if (CollectionUtils.isEmpty((Collection)terminalList)) {
            return;
        }
        List terminalCodeList = terminalList.stream().map(TpmInventoryCheck::getTerminalCode).collect(Collectors.toList());
        LambdaUpdateChainWrapper updateWrapper = this.lambdaUpdate();
        this.buildCowMasterGuestQuery((Compare<?, SFunction<TpmInventoryCheck, ?>>)updateWrapper);
        updateWrapper.in(TpmInventoryCheck::getTerminalCode, terminalCodeList);
        updateWrapper.ne(TpmInventoryCheck::getPullSign, (Object)BooleanEnum.FALSE.getNumStr());
        ((LambdaUpdateChainWrapper)updateWrapper.set(TpmInventoryCheck::getQuantity, (Object)BigDecimal.ZERO)).update();
    }

    public void updateMasterDataMdgToZero() {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(TpmInventoryCheck::getSourceType, (Object)"master_data_mdg")).eq(TpmInventoryCheck::getInventoryType, (Object)"BRANCH_WAREHOUSE_INVENTORY")).eq(TpmInventoryCheck::getBusinessUnitCode, (Object)BusinessUnitEnum.VERTICAL.getCode())).eq(TpmInventoryCheck::getBusinessFormatCode, (Object)BusinessFormatEnum.NORMAL.getCode())).gt(TpmInventoryCheck::getQuantity, (Object)BigDecimal.ZERO)).set(TpmInventoryCheck::getQuantity, (Object)BigDecimal.ZERO)).update();
    }
}

