/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.inventory.check.manage.local.service.imports;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.customer.retailer.sdk.service.CustomerRetailerVoService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.inventory.check.manage.sdk.dto.InventoryDataVerifyDto;
import com.biz.crm.tpm.business.inventory.check.manage.sdk.dto.TpmInventoryCheckDto;
import com.biz.crm.tpm.business.inventory.check.manage.sdk.service.TpmInventoryCheckService;
import com.biz.crm.tpm.business.inventory.check.manage.sdk.vo.imports.TpmInventoryCheckImportsVo;
import com.biz.crm.tpm.business.large.date.config.sdk.service.TpmProductRangeService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TpmInventoryCheckImportsProcess
implements ImportProcess<TpmInventoryCheckImportsVo> {
    private static final Logger log = LoggerFactory.getLogger(TpmInventoryCheckImportsProcess.class);
    @Autowired(required=false)
    private TpmInventoryCheckService tpmInventoryCheckService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private CustomerRetailerVoService customerRetailerVoService;
    @Autowired(required=false)
    private TerminalVoService terminalVoService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private TpmProductRangeService tpmProductRangeService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    private CustomerChannelVoService customerChannelVoService;

    public Integer getBatchCount() {
        return 2000;
    }

    public boolean importBeforeValidationFlag() {
        return Boolean.TRUE;
    }

    public Map<Integer, String> tryVerify(LinkedHashMap<Integer, TpmInventoryCheckImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        HashMap<Integer, String> errMap = new HashMap<Integer, String>();
        for (Map.Entry<Integer, TpmInventoryCheckImportsVo> row : data.entrySet()) {
            String errInfo;
            int rowNum = row.getKey();
            TpmInventoryCheckImportsVo vo = row.getValue();
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getInventoryType()), "\u5e93\u5b58\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getBusinessFormatCode()), "\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getBusinessUnitCode()), "\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getProductionStartDate()), "\u4ea7\u54c1\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getChannelCode()), "\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getSalesOrgCode()), "\u9500\u552e\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getProductCode()), "\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            if ("\u5206\u4ed3\u5e93\u5b58".equals(vo.getInventoryType())) {
                this.validateIsTrue(StringUtils.isNotBlank((CharSequence)vo.getBranchWarehouse()), "\u5206\u4ed3\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            } else if ("\u95e8\u5e97\u5e93\u5b58".equals(vo.getInventoryType())) {
                this.validateIsTrue(StringUtils.isNotBlank((CharSequence)vo.getTerminalCode()), "\u95e8\u5e97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            } else if ("\u5ba2\u6237\u5e93\u5b58".equals(vo.getInventoryType())) {
                this.validateIsTrue(StringUtils.isNotBlank((CharSequence)vo.getCustomerCode()), "\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            } else {
                this.validateIsTrue(false, "\u5e93\u5b58\u7c7b\u578b\u9519\u8bef\uff01");
            }
            if ((errInfo = this.validateGetErrorInfo()) == null) continue;
            errMap.put(rowNum, errInfo);
        }
        return errMap;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, TpmInventoryCheckImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        HashMap errMap = new HashMap();
        Validate.notNull(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((data.values().size() <= 2000 ? 1 : 0) != 0, (String)"\u5355\u6b21\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u8d85\u8fc72000\u6761", (Object[])new Object[0]);
        log.error("\u5e93\u5b58\u76d8\u70b9\u5bfc\u5165\u6570\u636e\u6761\u6570[{}]\uff01", (Object)data.values().size());
        HashMap<Integer, String> resultErrorMap = new HashMap<Integer, String>();
        List<TpmInventoryCheckDto> importList = this.validate(data, resultErrorMap);
        if (!resultErrorMap.isEmpty()) {
            return resultErrorMap;
        }
        log.error("\u5e93\u5b58\u76d8\u70b9\u5bfc\u5165\u8fdb\u5165\u4fdd\u5b58\u65b9\u6cd5\uff01");
        this.tpmInventoryCheckService.importSave(importList);
        importList.clear();
        return null;
    }

    private List<TpmInventoryCheckDto> validate(LinkedHashMap<Integer, TpmInventoryCheckImportsVo> data, Map<Integer, String> resultErrorMap) {
        ArrayList<TpmInventoryCheckDto> checkDtoList = new ArrayList<TpmInventoryCheckDto>();
        LinkedList<String> list = new LinkedList<String>();
        String tenantCode = TenantUtils.getTenantCode();
        String sourceType = "1";
        String del = DelFlagStatusEnum.NORMAL.getCode();
        String enableCode = EnableStatusEnum.ENABLE.getCode();
        Map formatMap = this.dictToolkitService.findConvertMapByDictTypeCode("mdm_business_format");
        Validate.isTrue((boolean)ObjectUtils.isNotEmpty((Object)formatMap), (String)"\u672a\u67e5\u8be2\u5230\u4e1a\u6001\u6570\u636e\u5b57\u5178!", (Object[])new Object[0]);
        Map unitMap = this.dictToolkitService.findConvertMapByDictTypeCode("mdm_business_unit");
        Validate.isTrue((boolean)ObjectUtils.isNotEmpty((Object)unitMap), (String)"\u672a\u67e5\u8be2\u5230\u4e1a\u52a1\u5355\u5143\u6570\u636e\u5b57\u5178!", (Object[])new Object[0]);
        Collection<TpmInventoryCheckImportsVo> values = data.values();
        HashMap<String, List<SalesOrgVo>> salesMap = new HashMap<String, List<SalesOrgVo>>();
        HashMap<String, List<ProductVo>> productMap = new HashMap<String, List<ProductVo>>();
        HashMap<String, String> customerRetailerMap = new HashMap<String, String>();
        HashMap<String, List<TerminalVo>> terminalMap = new HashMap<String, List<TerminalVo>>();
        HashMap<String, List<CustomerVo>> customerMap = new HashMap<String, List<CustomerVo>>();
        HashMap<String, List<CustomerChannelVo>> channelVoMap = new HashMap<String, List<CustomerChannelVo>>();
        this.queryMasterData(values, salesMap, productMap, customerRetailerMap, terminalMap, customerMap, channelVoMap);
        int index = 1;
        for (TpmInventoryCheckImportsVo importsVo : values) {
            ++index;
            try {
                String msg;
                InventoryDataVerifyDto verifyDto;
                String msg2;
                InventoryDataVerifyDto verifyDto2;
                String verifyCode;
                Validate.notNull((Object)importsVo, (String)"[\u884c%s]\u5bfc\u5165\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[]{index});
                String inventoryType = importsVo.getInventoryType();
                String businessFormatCode = importsVo.getBusinessFormatCode();
                String businessUnitCode = importsVo.getBusinessUnitCode();
                String productionStartDate = importsVo.getProductionStartDate();
                if (formatMap.containsKey(businessFormatCode)) {
                    businessFormatCode = (String)formatMap.get(businessFormatCode);
                } else {
                    this.validateIsTrue(false, "\u4e1a\u6001\u672a\u80fd\u8bc6\u522b");
                }
                if (unitMap.containsKey(businessUnitCode)) {
                    businessUnitCode = (String)unitMap.get(businessUnitCode);
                } else {
                    this.validateIsTrue(false, "\u4e1a\u52a1\u5355\u5143\u672a\u80fd\u8bc6\u522b");
                }
                DateUtil.date_yyyy_MM_dd.setLenient(false);
                try {
                    DateUtil.date_yyyy_MM_dd.parse(productionStartDate);
                }
                catch (ParseException e2) {
                    this.validateIsTrue(false, "\u4ea7\u54c1\u65e5\u671f\u683c\u5f0f\u9519\u8befyyyy-MM-dd\uff01");
                }
                String dateOfReporting = importsVo.getDateOfReporting();
                Validate.notNull((Object)dateOfReporting, (String)"\u5e93\u5b58\u63d0\u62a5\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                Date parse = null;
                try {
                    parse = DateUtil.date_yyyy_MM_dd.parse(dateOfReporting);
                }
                catch (ParseException e3) {
                    this.validateIsTrue(false, "\u5e93\u5b58\u63d0\u62a5\u65e5\u671f\u683c\u5f0f\u9519\u8befyyyy-MM-dd\uff01");
                }
                String channelCode = importsVo.getChannelCode();
                List customerChannelVoList = (List)channelVoMap.get(channelCode);
                if (CollectionUtils.isEmpty((Collection)customerChannelVoList)) {
                    this.validateIsTrue(false, "\u6e20\u9053\u7f16\u7801" + channelCode + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
                TpmInventoryCheckDto tpmInventoryCheckDto = new TpmInventoryCheckDto();
                String salesOrgCode = importsVo.getSalesOrgCode();
                List salesOrgVoList = (List)salesMap.get(salesOrgCode);
                if (CollectionUtils.isEmpty((Collection)salesOrgVoList)) {
                    this.validateIsTrue(false, "\u9500\u552e\u7ec4\u7ec7\u7f16\u7801" + salesOrgCode + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
                } else {
                    String finalBusinessFormatCode = businessFormatCode;
                    SalesOrgVo salesOrgVo = salesOrgVoList.stream().filter(e -> importsVo.getChannelCode().equals(e.getChannelCode()) && finalBusinessFormatCode.equals(e.getBusinessFormatCode())).findFirst().orElse(null);
                    if (salesOrgVo != null) {
                        tpmInventoryCheckDto.setSalesOrgCode(salesOrgVo.getSalesOrgCode());
                        tpmInventoryCheckDto.setSalesOrgName(salesOrgVo.getSalesOrgName());
                    } else {
                        this.validateIsTrue(false, "\u9500\u552e\u7ec4\u7ec7\u7f16\u7801" + salesOrgCode + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
                    }
                }
                String terminalRegionName = importsVo.getTerminalRegionName();
                String productCode = importsVo.getProductCode();
                List byQueryDto = (List)productMap.get(productCode);
                if (CollectionUtils.isEmpty((Collection)byQueryDto)) {
                    this.validateIsTrue(false, "\u4ea7\u54c1\u7f16\u7801" + productCode + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
                } else {
                    ProductVo productVo = (ProductVo)byQueryDto.get(0);
                    tpmInventoryCheckDto.setProductName(productVo.getProductName());
                    tpmInventoryCheckDto.setExpirationDate(productVo.getExpirationDate());
                }
                String customerRetailerCode = importsVo.getCustomerRetailerCode();
                String repeatVerify = verifyCode = businessFormatCode + businessUnitCode + salesOrgCode + terminalRegionName + productCode + productionStartDate + dateOfReporting;
                tpmInventoryCheckDto.setVerifyCode(verifyCode);
                if (StringUtils.isNotEmpty((CharSequence)customerRetailerCode)) {
                    String customerRetailerName = (String)customerRetailerMap.get(customerRetailerCode);
                    if (StringUtils.isBlank((CharSequence)customerRetailerName)) {
                        this.validateIsTrue(false, "\u96f6\u552e\u5546\u7f16\u7801" + customerRetailerCode + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
                    }
                    this.validateIsTrue(!list.contains(repeatVerify = repeatVerify + customerRetailerCode), "[\u4e1a\u6001+\u4e1a\u52a1\u5355\u5143+\u9500\u552e\u7ec4\u7ec7+\u533a\u57df+\u4ea7\u54c1+\u96f6\u552e\u5546+\u4ea7\u54c1\u65e5\u671f+\u5e93\u5b58\u63d0\u62a5\u65e5\u671f]\u7ef4\u5ea6\u6570\u636e\u91cd\u590d,\u8bf7\u68c0\u67e5\uff01");
                    list.add(repeatVerify);
                    verifyDto2 = this.getCondition(verifyCode, customerRetailerCode, "\u96f6\u552e\u5546");
                    msg2 = "[\u4e1a\u6001+\u4e1a\u52a1\u5355\u5143+\u9500\u552e\u7ec4\u7ec7+\u533a\u57df+\u4ea7\u54c1+\u96f6\u552e\u5546+\u4ea7\u54c1\u65e5\u671f+\u5e93\u5b58\u63d0\u62a5\u65e5\u671f]\u7ef4\u5ea6\u6570\u636e\u5e93\u5b58\u5728\u76f8\u540c\u6570\u636e,\u8bf7\u68c0\u67e5\uff01";
                    this.verifyData(verifyDto2, msg2);
                    tpmInventoryCheckDto.setCustomerRetailerCode(customerRetailerCode);
                    tpmInventoryCheckDto.setCustomerRetailerName(customerRetailerName);
                }
                if ("\u5206\u4ed3\u5e93\u5b58".equals(importsVo.getInventoryType())) {
                    String branchWarehouse = importsVo.getBranchWarehouse();
                    this.validateIsTrue(!list.contains(repeatVerify = repeatVerify + branchWarehouse), "[\u4e1a\u6001+\u4e1a\u52a1\u5355\u5143+\u9500\u552e\u7ec4\u7ec7+\u533a\u57df+\u4ea7\u54c1+\u5206\u4ed3+\u4ea7\u54c1\u65e5\u671f+\u5e93\u5b58\u63d0\u62a5\u65e5\u671f]\u7ef4\u5ea6\u6570\u636e\u91cd\u590d,\u8bf7\u68c0\u67e5\uff01");
                    list.add(repeatVerify);
                    verifyDto2 = this.getCondition(verifyCode, branchWarehouse, "\u5206\u4ed3\u5e93\u5b58");
                    msg2 = "[\u4e1a\u6001+\u4e1a\u52a1\u5355\u5143+\u9500\u552e\u7ec4\u7ec7+\u533a\u57df+\u4ea7\u54c1+\u5206\u4ed3+\u4ea7\u54c1\u65e5\u671f+\u5e93\u5b58\u63d0\u62a5\u65e5\u671f]\u7ef4\u5ea6\u6570\u636e\u5e93\u5b58\u5728\u76f8\u540c\u6570\u636e,\u8bf7\u68c0\u67e5\uff01";
                    this.verifyData(verifyDto2, msg2);
                    tpmInventoryCheckDto.setBranchWarehouse(branchWarehouse);
                } else if ("\u95e8\u5e97\u5e93\u5b58".equals(importsVo.getInventoryType())) {
                    String terminalCode = importsVo.getTerminalCode();
                    List terminalVos = (List)terminalMap.get(terminalCode);
                    if (CollectionUtils.isEmpty((Collection)terminalVos)) {
                        this.validateIsTrue(false, "\u95e8\u5e97\u7f16\u7801" + terminalCode + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
                    } else {
                        tpmInventoryCheckDto.setTerminalName(((TerminalVo)terminalVos.get(0)).getTerminalName());
                    }
                    repeatVerify = repeatVerify + terminalCode;
                    this.validateIsTrue(!list.contains(repeatVerify), "[\u4e1a\u6001+\u4e1a\u52a1\u5355\u5143+\u9500\u552e\u7ec4\u7ec7+\u533a\u57df+\u4ea7\u54c1+\u95e8\u5e97+\u4ea7\u54c1\u65e5\u671f+\u5e93\u5b58\u63d0\u62a5\u65e5\u671f]\u7ef4\u5ea6\u6570\u636e\u91cd\u590d,\u8bf7\u68c0\u67e5\uff01");
                    list.add(repeatVerify);
                    verifyDto = this.getCondition(verifyCode, terminalCode, "\u95e8\u5e97\u5e93\u5b58");
                    msg = "[\u4e1a\u6001+\u4e1a\u52a1\u5355\u5143+\u9500\u552e\u7ec4\u7ec7+\u533a\u57df+\u4ea7\u54c1+\u95e8\u5e97+\u4ea7\u54c1\u65e5\u671f+\u5e93\u5b58\u63d0\u62a5\u65e5\u671f]\u7ef4\u5ea6\u6570\u636e\u5e93\u5b58\u5728\u76f8\u540c\u6570\u636e,\u8bf7\u68c0\u67e5\uff01";
                    this.verifyData(verifyDto, msg);
                    tpmInventoryCheckDto.setTerminalCode(terminalCode);
                } else if ("\u5ba2\u6237\u5e93\u5b58".equals(importsVo.getInventoryType())) {
                    String customerCode = importsVo.getCustomerCode();
                    List baseByCustomerCodes = (List)customerMap.get(customerCode);
                    if (CollectionUtils.isEmpty((Collection)baseByCustomerCodes)) {
                        this.validateIsTrue(false, "\u5ba2\u6237\u7f16\u7801" + customerCode + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
                    } else {
                        CustomerVo customerVo = baseByCustomerCodes.stream().filter(e -> importsVo.getChannelCode().equals(e.getCustomerChannelCode()) && salesOrgCode.equals(e.getSalesInstitutionErpCode()) && importsVo.getBusinessFormatCode().equals(e.getBusinessFormatCode())).findFirst().orElse(null);
                        if (customerVo == null) {
                            this.validateIsTrue(false, "\u5ba2\u6237\u7f16\u7801" + customerCode + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
                        } else {
                            tpmInventoryCheckDto.setCustomerCode(customerVo.getCustomerCode());
                            tpmInventoryCheckDto.setCustomerName(customerVo.getCustomerName());
                        }
                    }
                    repeatVerify = repeatVerify + customerCode;
                    this.validateIsTrue(!list.contains(repeatVerify), "[\u4e1a\u6001+\u4e1a\u52a1\u5355\u5143+\u9500\u552e\u7ec4\u7ec7+\u533a\u57df+\u4ea7\u54c1+\u5ba2\u6237+\u4ea7\u54c1\u65e5\u671f+\u5e93\u5b58\u63d0\u62a5\u65e5\u671f]\u7ef4\u5ea6\u6570\u636e\u91cd\u590d,\u8bf7\u68c0\u67e5\uff01");
                    list.add(repeatVerify);
                    verifyDto = this.getCondition(verifyCode, customerCode, "\u5ba2\u6237\u5e93\u5b58");
                    msg = "[\u4e1a\u6001+\u4e1a\u52a1\u5355\u5143+\u9500\u552e\u7ec4\u7ec7+\u533a\u57df+\u4ea7\u54c1+\u5ba2\u6237+\u4ea7\u54c1\u65e5\u671f+\u5e93\u5b58\u63d0\u62a5\u65e5\u671f]\u7ef4\u5ea6\u6570\u636e\u5e93\u5b58\u5728\u76f8\u540c\u6570\u636e,\u8bf7\u68c0\u67e5\uff01";
                    this.verifyData(verifyDto, msg);
                    tpmInventoryCheckDto.setCustomerErpCode(customerCode);
                }
                Integer quantity = importsVo.getQuantity();
                Integer giftNumber = importsVo.getGiftNumber();
                String remark = importsVo.getRemark();
                if (remark != null) {
                    if (remark.length() <= 100) {
                        tpmInventoryCheckDto.setRemark(remark);
                    } else {
                        this.validateIsTrue(false, "\u6700\u5927\u5907\u6ce8\u957f\u5ea6\u4e3a100");
                    }
                }
                tpmInventoryCheckDto.setChannelCode(channelCode);
                tpmInventoryCheckDto.setChannelName(((CustomerChannelVo)customerChannelVoList.get(0)).getCustomerChannelName());
                tpmInventoryCheckDto.setSourceType(sourceType);
                tpmInventoryCheckDto.setBusinessFormatCode(businessFormatCode);
                tpmInventoryCheckDto.setBusinessUnitCode(businessUnitCode);
                tpmInventoryCheckDto.setSalesOrgErpCode(salesOrgCode);
                tpmInventoryCheckDto.setTerminalRegionName(terminalRegionName);
                tpmInventoryCheckDto.setProductCode(productCode);
                switch (inventoryType) {
                    case "\u5206\u4ed3\u5e93\u5b58": {
                        tpmInventoryCheckDto.setInventoryType("BRANCH_WAREHOUSE_INVENTORY");
                        break;
                    }
                    case "\u5ba2\u6237\u5e93\u5b58": {
                        tpmInventoryCheckDto.setInventoryType("CUSTOMER_INVENTORY");
                        break;
                    }
                    case "\u95e8\u5e97\u5e93\u5b58": {
                        tpmInventoryCheckDto.setInventoryType("TERMINAL_INVENTORY");
                        break;
                    }
                }
                tpmInventoryCheckDto.setTenantCode(tenantCode);
                tpmInventoryCheckDto.setDelFlag(del);
                tpmInventoryCheckDto.setEnableStatus(enableCode);
                tpmInventoryCheckDto.setQuantity(quantity);
                tpmInventoryCheckDto.setGiftNumber(giftNumber);
                tpmInventoryCheckDto.setDateOfReporting(parse);
                tpmInventoryCheckDto.setProductionStartDate(productionStartDate);
                tpmInventoryCheckDto.setProductMonth(productionStartDate.substring(5, productionStartDate.lastIndexOf("-")));
                tpmInventoryCheckDto.setId(UUID.randomUUID().toString().replace("-", ""));
                tpmInventoryCheckDto.setRepeatVerify(repeatVerify);
                checkDtoList.add(tpmInventoryCheckDto);
                String errInfo = this.validateGetErrorInfo();
                if (errInfo == null) continue;
                resultErrorMap.put(index, errInfo);
            }
            catch (Exception e4) {
                log.error(e4.getMessage(), (Throwable)e4);
                String msg = "\u7b2c\u3010" + index + "\u3011\u884c\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e4.getMessage();
                resultErrorMap.put(index, msg);
            }
        }
        return checkDtoList;
    }

    private void queryMasterData(Collection<TpmInventoryCheckImportsVo> values, Map<String, List<SalesOrgVo>> salesMap, Map<String, List<ProductVo>> productMap, Map<String, String> customerRetailerMap, Map<String, List<TerminalVo>> terminalMap, Map<String, List<CustomerVo>> customerMap, Map<String, List<CustomerChannelVo>> channelVoMap) {
        List channelCodeSet;
        List channelList;
        List customerCodes;
        List customerVos;
        List terminalCodes;
        List terminals;
        List customerRetailerCodes;
        Map retailerMap;
        List productCodes;
        List byProductCodes;
        List salesOrgCodes = values.stream().map(TpmInventoryCheckImportsVo::getSalesOrgCode).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        List salesOrgVos = this.salesOrgVoService.findByErpCodeList(salesOrgCodes);
        if (CollectionUtils.isNotEmpty((Collection)salesOrgVos)) {
            Map<String, List<SalesOrgVo>> map = salesOrgVos.stream().collect(Collectors.groupingBy(SalesOrgVo::getErpCode));
            salesMap.putAll(map);
        }
        if (CollectionUtils.isNotEmpty((Collection)(byProductCodes = this.productVoService.findByCodes(productCodes = values.stream().map(TpmInventoryCheckImportsVo::getProductCode).filter(StringUtils::isNotBlank).collect(Collectors.toList()))))) {
            Map<String, List<ProductVo>> map = byProductCodes.stream().collect(Collectors.groupingBy(ProductVo::getProductCode));
            productMap.putAll(map);
        }
        if (Objects.nonNull(retailerMap = this.customerRetailerVoService.getRetailerByCodes(customerRetailerCodes = values.stream().map(TpmInventoryCheckImportsVo::getCustomerRetailerCode).filter(StringUtils::isNotBlank).collect(Collectors.toList())))) {
            customerRetailerMap.putAll(retailerMap);
        }
        if (CollectionUtils.isNotEmpty((Collection)(terminals = this.terminalVoService.findByTerminalCodes(terminalCodes = values.stream().map(TpmInventoryCheckImportsVo::getTerminalCode).filter(StringUtils::isNotBlank).collect(Collectors.toList()))))) {
            Map<String, List<TerminalVo>> map = terminals.stream().collect(Collectors.groupingBy(TerminalVo::getTerminalCode));
            terminalMap.putAll(map);
        }
        if (CollectionUtils.isNotEmpty((Collection)(customerVos = this.customerVoService.findByCustomerMdgCodes(customerCodes = values.stream().map(TpmInventoryCheckImportsVo::getCustomerCode).filter(StringUtils::isNotBlank).collect(Collectors.toList()))))) {
            Map<String, List<CustomerVo>> map = customerVos.stream().collect(Collectors.groupingBy(CustomerVo::getErpCode));
            customerMap.putAll(map);
        }
        if (CollectionUtils.isNotEmpty((Collection)(channelList = this.customerChannelVoService.findByCodes(new ArrayList(channelCodeSet = values.stream().map(TpmInventoryCheckImportsVo::getChannelCode).filter(StringUtils::isNotBlank).collect(Collectors.toList())))))) {
            Map<String, List<CustomerChannelVo>> map = channelList.stream().collect(Collectors.groupingBy(CustomerChannelVo::getCustomerChannelCode));
            channelVoMap.putAll(map);
        }
    }

    private InventoryDataVerifyDto getCondition(String verifyCode, String code, String type) {
        InventoryDataVerifyDto verifyDto = new InventoryDataVerifyDto();
        verifyDto.setVerifyCode(verifyCode);
        verifyDto.setFieldCode(code);
        verifyDto.setFieldType(type);
        return verifyDto;
    }

    private void verifyData(InventoryDataVerifyDto verifyDto, String msg) {
        Boolean res = this.tpmInventoryCheckService.verifyRepetition(verifyDto);
        this.validateIsTrue(res, msg);
    }

    public Class<TpmInventoryCheckImportsVo> findCrmExcelVoClass() {
        return TpmInventoryCheckImportsVo.class;
    }

    public String getBusinessCode() {
        return "TPM_INVENTORY_CHECK_IMPORT";
    }

    public String getBusinessName() {
        return "TPM\u5e93\u5b58\u76d8\u70b9\u7ba1\u7406\u5bfc\u5165";
    }

    public String getTemplateCode() {
        return "TPM_INVENTORY_CHECK_IMPORT";
    }

    public String getTemplateName() {
        return "TPM\u5e93\u5b58\u76d8\u70b9\u7ba1\u7406\u5bfc\u5165";
    }
}

