/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.inventory.check.manage.local.service.internal;

import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.tpm.business.inventory.check.manage.local.entity.TpmInventoryCheck;
import com.biz.crm.tpm.business.inventory.check.manage.local.repository.TpmInventoryCheckRepository;
import com.biz.crm.tpm.business.inventory.check.manage.local.service.InventoryCheckTransService;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="inventoryCheckTransService")
public class InventoryCheckTransServiceImpl
implements InventoryCheckTransService {
    @Autowired(required=false)
    private TpmInventoryCheckRepository tpmInventoryCheckRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDataList(List<TpmInventoryCheck> updateList) {
        this.tpmInventoryCheckRepository.updateBatchById(updateList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveDataList(Collection<TpmInventoryCheck> saveList) {
        if (CollectionUtils.isEmpty(saveList)) {
            return;
        }
        AbstractCrmUserIdentity loginDetails = this.loginUserService.getAbstractLoginUser();
        Date date = new Date();
        String username = loginDetails.getUsername();
        String realName = loginDetails.getRealName();
        String account = loginDetails.getAccount();
        for (TpmInventoryCheck inventoryCheck : saveList) {
            inventoryCheck.setCreateAccount(username);
            inventoryCheck.setCreateName(realName);
            inventoryCheck.setCreateTime(date);
            inventoryCheck.setCreateAccount(account);
            inventoryCheck.setInitQuantity(inventoryCheck.getQuantity());
            inventoryCheck.setUsableQuantity(inventoryCheck.getQuantity());
        }
        this.tpmInventoryCheckRepository.saveBatchData(saveList);
    }
}

