/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.inventory.check.manage.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.customer.retailer.sdk.service.CustomerRetailerVoService;
import com.biz.crm.mdm.business.customer.retailer.sdk.vo.CustomerRetailerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.product.sdk.dto.ProductQueryDto;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.third.system.cow.master.guest.sdk.dto.CowMasterGuestInventoryDto;
import com.biz.crm.mn.third.system.cow.master.guest.sdk.service.CowMasterGuestService;
import com.biz.crm.mn.third.system.cow.master.guest.sdk.vo.CowMasterGuestInventoryVo;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgBaseDto;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.service.MasterDataMdgService;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgInventoryVo;
import com.biz.crm.tpm.business.inventory.check.manage.local.entity.TpmInventoryCheck;
import com.biz.crm.tpm.business.inventory.check.manage.local.entity.TpmInventoryCheckOperation;
import com.biz.crm.tpm.business.inventory.check.manage.local.repository.TpmInventoryCheckOperationRepository;
import com.biz.crm.tpm.business.inventory.check.manage.local.repository.TpmInventoryCheckRepository;
import com.biz.crm.tpm.business.inventory.check.manage.local.service.InventoryCheckTransService;
import com.biz.crm.tpm.business.inventory.check.manage.sdk.dto.InventoryDataVerifyDto;
import com.biz.crm.tpm.business.inventory.check.manage.sdk.dto.OperateInventoryCheckDto;
import com.biz.crm.tpm.business.inventory.check.manage.sdk.dto.TpmInventoryCheckDto;
import com.biz.crm.tpm.business.inventory.check.manage.sdk.dto.log.InventoryCheckManageLogEventDto;
import com.biz.crm.tpm.business.inventory.check.manage.sdk.enums.InventoryCheckOperationTypeEnum;
import com.biz.crm.tpm.business.inventory.check.manage.sdk.event.log.InventoryCheckManageEventListener;
import com.biz.crm.tpm.business.inventory.check.manage.sdk.service.TpmInventoryCheckService;
import com.biz.crm.tpm.business.inventory.check.manage.sdk.vo.InventoryProductVo;
import com.biz.crm.tpm.business.inventory.check.manage.sdk.vo.TpmInventoryCheckVo;
import com.biz.crm.tpm.business.large.date.config.sdk.service.TpmLargeDateConfigService;
import com.biz.crm.tpm.business.large.date.config.sdk.vo.TpmLargeDateConfigVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service(value="tpmInventoryCheckService")
public class TpmInventoryCheckServiceImpl
implements TpmInventoryCheckService {
    private static final Logger log = LoggerFactory.getLogger(TpmInventoryCheckServiceImpl.class);
    @Autowired(required=false)
    private TpmInventoryCheckRepository tpmInventoryCheckRepository;
    @Autowired(required=false)
    private TpmInventoryCheckOperationRepository tpmInventoryCheckOperationRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private CowMasterGuestService cowMasterGuestInventoryService;
    @Autowired(required=false)
    private MasterDataMdgService masterDataMdgService;
    @Autowired(required=false)
    private InventoryCheckTransService inventoryCheckTransService;
    @Autowired(required=false)
    private TerminalVoService terminalVoService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private TpmLargeDateConfigService tpmLargeDateConfigService;
    @Autowired(required=false)
    private CustomerRetailerVoService customerRetailerVoService;

    @Transactional(rollbackFor={Exception.class})
    public TpmInventoryCheckVo create(TpmInventoryCheckDto dto) {
        this.createValidate(dto);
        InventoryDataVerifyDto dataVerifyDto = (InventoryDataVerifyDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, InventoryDataVerifyDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        TpmInventoryCheck tpmInventoryCheck = (TpmInventoryCheck)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, TpmInventoryCheck.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        List<TpmInventoryCheck> list = this.tpmInventoryCheckRepository.findRepetition(dataVerifyDto);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(list)) {
            tpmInventoryCheck.setId(list.get(0).getId());
            this.tpmInventoryCheckRepository.updateById((Object)tpmInventoryCheck);
            list.clear();
            return null;
        }
        tpmInventoryCheck.setTenantCode(TenantUtils.getTenantCode());
        tpmInventoryCheck.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        tpmInventoryCheck.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        String productionStartDate = tpmInventoryCheck.getProductionStartDate();
        if (StringUtils.isBlank((CharSequence)tpmInventoryCheck.getProductMonth()) && StringUtils.isNotBlank((CharSequence)productionStartDate)) {
            tpmInventoryCheck.setProductMonth(productionStartDate.substring(5, productionStartDate.lastIndexOf("-")));
        }
        this.tpmInventoryCheckRepository.saveOrUpdate((Object)tpmInventoryCheck);
        InventoryCheckManageLogEventDto logEventDto = new InventoryCheckManageLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(dto);
        SerializableBiConsumer & Serializable onCreate = InventoryCheckManageEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, InventoryCheckManageEventListener.class, (SerializableBiConsumer)onCreate);
        return (TpmInventoryCheckVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, TpmInventoryCheckVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> idList) {
        Validate.isTrue((!org.apache.commons.collections.CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\uff01", (Object[])new Object[0]);
        List entities = this.tpmInventoryCheckRepository.listByIds(idList);
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)entities)) {
            entities.forEach(entity -> {
                if ("1".equals(entity.getSourceType())) {
                    InventoryCheckManageLogEventDto logEventDto = new InventoryCheckManageLogEventDto();
                    TpmInventoryCheckVo oldVo = (TpmInventoryCheckVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, TpmInventoryCheckVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                    logEventDto.setOriginal(oldVo);
                    entity.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
                    TpmInventoryCheckDto tpmInventoryCheckDto = (TpmInventoryCheckDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, TpmInventoryCheckDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                    logEventDto.setNewest(tpmInventoryCheckDto);
                    SerializableBiConsumer & Serializable onDelete = InventoryCheckManageEventListener::onDelete;
                    this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, InventoryCheckManageEventListener.class, (SerializableBiConsumer)onDelete);
                }
            });
            this.inventoryCheckTransService.updateDataList(entities);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public TpmInventoryCheckVo update(TpmInventoryCheckDto dto) {
        this.updateValidate(dto);
        TpmInventoryCheckVo oldVo = this.findById(dto.getId());
        FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
        dto.setModifyName(loginDetails.getUsername());
        dto.setModifyAccount(loginDetails.getAccount());
        dto.setModifyTime(new Date());
        String productionStartDate = dto.getProductionStartDate();
        if (StringUtils.isBlank((CharSequence)dto.getProductMonth()) && StringUtils.isNotBlank((CharSequence)productionStartDate)) {
            dto.setProductMonth(productionStartDate.substring(5, productionStartDate.lastIndexOf("-")));
        }
        TpmInventoryCheck entity = (TpmInventoryCheck)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, TpmInventoryCheck.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        this.tpmInventoryCheckRepository.updateById((Object)entity);
        InventoryCheckManageLogEventDto logEventDto = new InventoryCheckManageLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(dto);
        SerializableBiConsumer & Serializable onUpdate = InventoryCheckManageEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, InventoryCheckManageEventListener.class, (SerializableBiConsumer)onUpdate);
        return (TpmInventoryCheckVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, TpmInventoryCheckVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public TpmInventoryCheckVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        TpmInventoryCheck entity = (TpmInventoryCheck)((Object)this.tpmInventoryCheckRepository.getById((Serializable)((Object)id)));
        Validate.notNull((Object)((Object)entity), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        return (TpmInventoryCheckVo)this.nebulaToolkitService.copyObjectByBlankList((Object)entity, TpmInventoryCheckVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public void importSave(List<TpmInventoryCheckDto> importList) {
        try {
            if (org.apache.commons.collections.CollectionUtils.isEmpty(importList)) {
                return;
            }
            List inventoryChecks = importList.stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getRepeatVerify())).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<TpmInventoryCheckDto>(Comparator.comparing(TpmInventoryCheckDto::getRepeatVerify))), ArrayList::new));
            List entities = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)inventoryChecks, TpmInventoryCheckDto.class, TpmInventoryCheck.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            log.error("\u5e93\u5b58\u76d8\u70b9\u5bfc\u5165\u4fdd\u5b58\u603b\u6761\u6570[{}]\uff01\uff01", (Object)entities.size());
            for (TpmInventoryCheck entity : entities) {
                entity.setInitQuantity(entity.getQuantity());
                entity.setUsableQuantity(entity.getQuantity());
            }
            this.inventoryCheckTransService.saveDataList(entities);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            String errorMsg = e.getMessage();
            if (StringUtils.isEmpty((CharSequence)e.getMessage())) {
                errorMsg = "\u5e93\u5b58\u76d8\u70b9\u5bfc\u5165,\u6570\u636e\u6279\u91cf\u65b0\u589e\u5904\u7406\u5931\u8d25\uff01";
            }
            throw new IllegalArgumentException(errorMsg);
        }
    }

    public Boolean verifyRepetition(InventoryDataVerifyDto VerifyDto) {
        if (ObjectUtils.isEmpty((Object)VerifyDto)) {
            return true;
        }
        List<TpmInventoryCheck> list = this.tpmInventoryCheckRepository.findVerifyDto(VerifyDto);
        return org.apache.commons.collections.CollectionUtils.isEmpty(list) || list.size() == 0;
    }

    public Page<TpmInventoryCheckVo> findByConditions(Pageable pageable, TpmInventoryCheckDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new TpmInventoryCheckDto();
        }
        return this.tpmInventoryCheckRepository.findByConditions(pageable, dto);
    }

    @Transactional(rollbackFor={Exception.class})
    public void disable(List<String> idList) {
        Validate.isTrue((!org.apache.commons.collections.CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u7981\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List inventoryCheckList = this.tpmInventoryCheckRepository.listByIds(idList);
        Validate.isTrue((!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)inventoryCheckList) ? 1 : 0) != 0, (String)"\u7981\u7528\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ArrayList<TpmInventoryCheck> tpmInventoryCheckList = new ArrayList<TpmInventoryCheck>();
        String code = EnableStatusEnum.DISABLE.getCode();
        for (int i = 0; i < inventoryCheckList.size(); ++i) {
            Assert.isTrue((!code.equals(((TpmInventoryCheck)((Object)inventoryCheckList.get(i))).getEnableStatus()) ? 1 : 0) != 0, (String)("\u7b2c[" + i + "]\u884c\u5df2\u7981\u7528,\u4e0d\u53ef\u91cd\u590d\u7981\u7528!"));
        }
        inventoryCheckList.forEach(item -> {
            TpmInventoryCheck tpmInventoryCheck = new TpmInventoryCheck();
            tpmInventoryCheck.setId(item.getId());
            tpmInventoryCheck.setEnableStatus(code);
            tpmInventoryCheckList.add(tpmInventoryCheck);
            InventoryCheckManageLogEventDto logEventDto = new InventoryCheckManageLogEventDto();
            TpmInventoryCheckVo oldVo = (TpmInventoryCheckVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, TpmInventoryCheckVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            logEventDto.setOriginal(oldVo);
            TpmInventoryCheckDto tpmInventoryCheckDto = (TpmInventoryCheckDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, TpmInventoryCheckDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            tpmInventoryCheckDto.setEnableStatus(item.getEnableStatus());
            logEventDto.setNewest(tpmInventoryCheckDto);
            SerializableBiConsumer & Serializable onDisable = InventoryCheckManageEventListener::onDisable;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, InventoryCheckManageEventListener.class, (SerializableBiConsumer)onDisable);
        });
        this.inventoryCheckTransService.updateDataList(tpmInventoryCheckList);
    }

    public Page<TpmInventoryCheckVo> findAllByConditions(Pageable pageable, TpmInventoryCheckDto dto) {
        Validate.notNull((Object)dto, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getDateOfReportingStr(), (String)"\u63d0\u62a5\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return this.tpmInventoryCheckRepository.findAllByConditions(pageable, dto);
    }

    public List<TpmInventoryCheckVo> findListByConditions(TpmInventoryCheckDto dto) {
        List<TpmInventoryCheck> tpmInventoryCheckList;
        Validate.notNull((Object)dto, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (StringUtils.isEmpty((CharSequence)dto.getTenantCode())) {
            String tenantCode = TenantUtils.getTenantCode();
            dto.setTenantCode(tenantCode);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(tpmInventoryCheckList = this.tpmInventoryCheckRepository.findListByConditions(dto))) {
            Collection tpmInventoryCheckVos = this.nebulaToolkitService.copyCollectionByBlankList(tpmInventoryCheckList, TpmInventoryCheck.class, TpmInventoryCheckVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            return (List)tpmInventoryCheckVos;
        }
        return new ArrayList<TpmInventoryCheckVo>();
    }

    public Integer getTotalByConditions(TpmInventoryCheckDto dto) {
        Validate.notNull((Object)dto, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getDateOfReportingStr(), (String)"\u63d0\u62a5\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (StringUtils.isEmpty((CharSequence)dto.getTenantCode())) {
            String tenantCode = TenantUtils.getTenantCode();
            dto.setTenantCode(tenantCode);
        }
        return this.tpmInventoryCheckRepository.getTotalByConditions(dto);
    }

    @DynamicTaskService(cornExpression="0 0 3 * * ?", taskDesc="\u6279\u91cf\u62c9\u53d6\u725b\u8981\u5ba2\u6570\u636e")
    public void pullInventoryDataList() {
        this.loginUserService.refreshAuthentication(null);
        AbstractCrmUserIdentity loginUser = this.loginUserService.getAbstractLoginUser();
        TpmInventoryCheckDto dto = new TpmInventoryCheckDto();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        CowMasterGuestInventoryDto InventoryDto = this.getCowMasterGuestInventoryDto(dto, sdf);
        this.dataTransformation(sdf, InventoryDto);
    }

    public void pullInventoryDataList(TpmInventoryCheckDto dto) {
        if (ObjectUtils.isEmpty((Object)dto)) {
            dto = new TpmInventoryCheckDto();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        CowMasterGuestInventoryDto InventoryDto = this.getCowMasterGuestInventoryDto(dto, sdf);
        this.dataTransformation(sdf, InventoryDto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dataTransformation(SimpleDateFormat sdf, CowMasterGuestInventoryDto inventoryDto) {
        boolean lock = true;
        String lockKey = "CowMasterGuest" + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd");
        int pageNum = 1;
        try {
            lock = this.lock(lockKey);
            if (!lock) {
                return;
            }
            log.info("\u5f00\u59cb\u62c9\u53d6\u725b\u8981\u5ba2\u5e93\u5b58\u6570\u636e");
            this.tpmInventoryCheckRepository.resetCowMasterGuestPullSign();
            boolean judge = true;
            while (judge) {
                List inventoryVoList = this.cowMasterGuestInventoryService.pullInventoryDataVo(inventoryDto, Integer.valueOf(pageNum), Integer.valueOf("1000"));
                if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)inventoryVoList)) {
                    if (pageNum == 1) {
                        throw new RuntimeException("\u672c\u6b21\u62c9\u53d6\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
                    }
                    judge = false;
                    return;
                }
                ++pageNum;
                List<TpmInventoryCheck> inventoryList = this.InventoryDataValidate(inventoryVoList, sdf);
                TreeSet<TpmInventoryCheck> pullList = new TreeSet<TpmInventoryCheck>(Comparator.comparing(TpmInventoryCheck::getVerifyCode));
                pullList.addAll(inventoryList);
                inventoryList.clear();
                inventoryVoList.clear();
                List<String> verifyCodeList = pullList.stream().map(TpmInventoryCheck::getVerifyCode).distinct().collect(Collectors.toList());
                List<TpmInventoryCheck> byVerifyCodes = this.tpmInventoryCheckRepository.findByVerifyCodes(verifyCodeList);
                verifyCodeList.clear();
                if (org.apache.commons.collections.CollectionUtils.isEmpty(byVerifyCodes)) {
                    this.inventoryCheckTransService.saveDataList(pullList);
                    continue;
                }
                LinkedList<TpmInventoryCheck> saveList = new LinkedList<TpmInventoryCheck>();
                ArrayList<TpmInventoryCheck> updateList = new ArrayList<TpmInventoryCheck>();
                Map map = byVerifyCodes.stream().collect(Collectors.toMap(TpmInventoryCheck::getVerifyCode, Function.identity(), (a, b) -> a));
                byVerifyCodes.clear();
                pullList.forEach(pull -> {
                    if (map.containsKey(pull.getVerifyCode())) {
                        TpmInventoryCheck tpmInventoryCheck = (TpmInventoryCheck)((Object)((Object)map.get(pull.getVerifyCode())));
                        if (null != tpmInventoryCheck.getUsableQuantity() && Objects.equals(tpmInventoryCheck.getInitQuantity(), tpmInventoryCheck.getUsableQuantity())) {
                            tpmInventoryCheck.setInitQuantity(pull.getQuantity());
                            tpmInventoryCheck.setUsableQuantity(pull.getQuantity());
                        }
                        tpmInventoryCheck.setQuantity(pull.getQuantity());
                        tpmInventoryCheck.setGiftNumber(pull.getGiftNumber());
                        tpmInventoryCheck.setDateOfReporting(pull.getDateOfReporting());
                        tpmInventoryCheck.setTenantCode(TenantUtils.getTenantCode());
                        tpmInventoryCheck.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                        tpmInventoryCheck.setPullSign(BooleanEnum.TRUE.getNumStr());
                        updateList.add(tpmInventoryCheck);
                    } else {
                        pull.setInitQuantity(pull.getQuantity());
                        pull.setUsableQuantity(pull.getQuantity());
                        pull.setPullSign(BooleanEnum.TRUE.getNumStr());
                        saveList.add((TpmInventoryCheck)((Object)pull));
                    }
                });
                if (!org.apache.commons.collections.CollectionUtils.isEmpty(saveList)) {
                    this.inventoryCheckTransService.saveDataList(saveList);
                }
                if (org.apache.commons.collections.CollectionUtils.isEmpty(updateList)) continue;
                this.inventoryCheckTransService.updateDataList(updateList);
            }
            this.tpmInventoryCheckRepository.resetCowMasterGuestPullSign();
        }
        finally {
            if (lock) {
                this.unLock(lockKey);
            }
        }
    }

    @DynamicTaskService(cornExpression="0 0 3 * * ?", taskDesc="\u6570\u636e\u4e2d\u53f0\u51cc\u6668\u6279\u91cf\u62c9\u53d6\u524d\u5929\u5206\u4ed3\u5927\u65e5\u671f\u5e93\u5b58\u6570\u636e")
    public void pullTpmInventoryList() {
        this.loginUserService.refreshAuthentication(null);
        AbstractCrmUserIdentity loginUser = this.loginUserService.getAbstractLoginUser();
        MasterDataMdgBaseDto dto = new MasterDataMdgBaseDto();
        dto.setPageSize("1000");
        dto.setDs(this.defaultDate(DateUtil.date_yyyyMMdd));
        this.dataTransformation(dto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DynamicTaskService(cornExpression="0 0 5 * * ?", taskDesc="\u51cc\u6668\u6279\u91cf\u66f4\u65b0\u5e93\u5b58\u4fdd\u8d28\u671f\u5269\u4f59\u5929\u6570\u3001\u662f\u5426\u5927\u65e5\u671f\u6570\u636e")
    public void pullUpdateChange() {
        this.loginUserService.refreshAuthentication(null);
        AbstractCrmUserIdentity loginUser = this.loginUserService.getAbstractLoginUser();
        boolean lock = true;
        String lockKey = "updateChange_" + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd");
        try {
            lock = this.lock(lockKey);
            if (!lock) {
                return;
            }
            this.tpmInventoryCheckRepository.updateExpirationDays();
            Map listMap = this.tpmLargeDateConfigService.findAllProductConfig();
            if (Objects.isNull(listMap)) {
                return;
            }
            int size = Integer.parseInt("1000");
            PageRequest pageable = PageRequest.of((int)1, (int)size);
            InventoryProductVo dto = new InventoryProductVo();
            dto.setBusinessUnitCode(BusinessUnitEnum.SON_COMPANY.getCode());
            Page<InventoryProductVo> page = this.tpmInventoryCheckRepository.findAllData(dto, (Pageable)pageable);
            this.updateData(page.getRecords(), listMap);
            while (page.hasNext()) {
                page = this.tpmInventoryCheckRepository.findAllData(dto, (Pageable)(pageable = PageRequest.of((int)(pageable.getPageNumber() + 1), (int)pageable.getPageSize())));
                List records = page.getRecords();
                if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)records)) {
                    return;
                }
                this.updateData(records, listMap);
            }
        }
        finally {
            if (lock) {
                this.unLock(lockKey);
            }
        }
    }

    private void updateData(List<InventoryProductVo> list, Map<String, List<TpmLargeDateConfigVo>> map) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(list)) {
            return;
        }
        ArrayList<TpmInventoryCheck> inventoryCheckList = new ArrayList<TpmInventoryCheck>(list.size());
        list.forEach(l -> {
            String dateIsLarge;
            block9: {
                String businessUnitCode = l.getBusinessUnitCode();
                List largeDateConfigVos = (List)map.get(l.getBusinessFormatCode() + businessUnitCode);
                if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)largeDateConfigVos)) {
                    return;
                }
                Integer expirationDays = l.getExpirationDays();
                String productCode = l.getProductCode();
                dateIsLarge = null;
                try {
                    if (BusinessUnitEnum.SON_COMPANY.getCode().equals(businessUnitCode)) {
                        String salesOrgCode = l.getSalesOrgCode();
                        for (TpmLargeDateConfigVo largeDateConfigVo : largeDateConfigVos) {
                            String codeSet = largeDateConfigVo.getCodeSet();
                            String salesOrgCodeSet = largeDateConfigVo.getSalesOrgCodeSet();
                            String formulaName = largeDateConfigVo.getFormulaName();
                            if (StringUtils.isNotBlank((CharSequence)salesOrgCodeSet)) {
                                if (!codeSet.contains(productCode) || !salesOrgCodeSet.contains(salesOrgCode)) continue;
                                dateIsLarge = this.getCalculatedValue(formulaName, expirationDays);
                            } else {
                                if (!codeSet.contains(productCode)) continue;
                                dateIsLarge = this.getCalculatedValue(formulaName, expirationDays);
                            }
                            break block9;
                        }
                        break block9;
                    }
                    for (TpmLargeDateConfigVo largeDateConfigVo : largeDateConfigVos) {
                        String codeSet = largeDateConfigVo.getCodeSet();
                        if (!codeSet.contains(productCode)) continue;
                        dateIsLarge = this.getCalculatedValue(largeDateConfigVo.getFormulaName(), expirationDays);
                        break;
                    }
                }
                catch (NumberFormatException e) {
                    log.error("\u5e93\u5b58\u76d8\u70b9---\u89e3\u6790\u5927\u65e5\u671f\u914d\u7f6e\u516c\u5f0f\u5931\u8d25\uff01");
                    e.printStackTrace();
                }
            }
            if (StringUtils.isBlank(dateIsLarge)) {
                return;
            }
            l.setDateIsLarge(dateIsLarge);
            TpmInventoryCheck tpmInventoryCheck = (TpmInventoryCheck)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(l, TpmInventoryCheck.class, LinkedHashSet.class, ArrayList.class, new String[0])));
            inventoryCheckList.add(tpmInventoryCheck);
        });
        this.inventoryCheckTransService.updateDataList(inventoryCheckList);
    }

    private String getCalculatedValue(String formulaName, Integer expirationDays) {
        String s = formulaName.replaceAll("[^\\d]", "");
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        Integer calculatedValue = Integer.valueOf(s);
        if (formulaName.contains("<=")) {
            if (Objects.nonNull(expirationDays) && expirationDays.compareTo(calculatedValue) <= 0) {
                return "1";
            }
            return "0";
        }
        if (Objects.nonNull(expirationDays) && expirationDays.compareTo(calculatedValue) < 0) {
            return "1";
        }
        return "0";
    }

    public void pullTpmInventoryList(MasterDataMdgBaseDto dto) {
        String ds;
        if (ObjectUtils.isEmpty((Object)dto)) {
            dto = new MasterDataMdgBaseDto();
        }
        if (StringUtils.isEmpty((CharSequence)dto.getPageSize())) {
            dto.setPageSize("1000");
        }
        if (StringUtils.isEmpty((CharSequence)(ds = dto.getDs()))) {
            dto.setDs(DateUtil.format((Date)new Date(), (String)"yyyyMMdd"));
        } else {
            try {
                DateUtil.date_yyyyMMdd.parse(ds);
            }
            catch (ParseException e) {
                throw new RuntimeException("\u521b\u5efa\u65e5\u671fds\u7684\u683c\u5f0f\u9700\u8981\u4e3ayyyyMMdd!");
            }
        }
        this.dataTransformation(dto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dataTransformation(MasterDataMdgBaseDto dto) {
        boolean lock = true;
        String lockKey = "MDG" + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd");
        int pageNum = 1;
        try {
            lock = this.lock(lockKey);
            if (!lock) {
                return;
            }
            log.info("\u5f00\u59cb\u62c9\u53d6MDG\u5206\u4ed3\u5927\u65e5\u671f\u5e93\u5b58\u6570\u636e");
            boolean judge = true;
            this.tpmInventoryCheckRepository.updateMasterDataMdgToZero();
            while (judge) {
                dto.setPageNum(String.valueOf(pageNum));
                List mdgInventoryVos = this.masterDataMdgService.pullTpmInventoryList(dto);
                if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)mdgInventoryVos)) {
                    if (pageNum == 1) {
                        throw new RuntimeException("\u672c\u6b21\u62c9\u53d6\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
                    }
                    judge = false;
                    return;
                }
                ++pageNum;
                List<TpmInventoryCheck> inventoryList = this.InventoryDataValidate(mdgInventoryVos);
                TreeSet<TpmInventoryCheck> pullList = new TreeSet<TpmInventoryCheck>(Comparator.comparing(TpmInventoryCheck::getVerifyCode));
                pullList.addAll(inventoryList);
                inventoryList.clear();
                mdgInventoryVos.clear();
                List<String> verifyCodeList = pullList.stream().map(TpmInventoryCheck::getVerifyCode).distinct().collect(Collectors.toList());
                List<TpmInventoryCheck> byVerifyCodes = this.tpmInventoryCheckRepository.findByMdgVerifyCodes(verifyCodeList);
                if (org.apache.commons.collections.CollectionUtils.isEmpty(byVerifyCodes)) {
                    this.inventoryCheckTransService.saveDataList(pullList);
                    return;
                }
                HashSet<TpmInventoryCheck> saveList = new HashSet<TpmInventoryCheck>();
                ArrayList<TpmInventoryCheck> updateList = new ArrayList<TpmInventoryCheck>();
                Map map = byVerifyCodes.stream().collect(Collectors.toMap(TpmInventoryCheck::getVerifyCode, Function.identity(), (a, b) -> a));
                byVerifyCodes.clear();
                String tenantCode = TenantUtils.getTenantCode();
                String code = DelFlagStatusEnum.NORMAL.getCode();
                pullList.forEach(pull -> {
                    if (map.containsKey(pull.getVerifyCode())) {
                        TpmInventoryCheck tpmInventoryCheck = (TpmInventoryCheck)((Object)((Object)map.get(pull.getVerifyCode())));
                        if (null != tpmInventoryCheck.getUsableQuantity() && Objects.equals(tpmInventoryCheck.getInitQuantity(), tpmInventoryCheck.getUsableQuantity())) {
                            tpmInventoryCheck.setInitQuantity(pull.getQuantity());
                            tpmInventoryCheck.setUsableQuantity(pull.getQuantity());
                        }
                        tpmInventoryCheck.setQuantity(pull.getQuantity());
                        tpmInventoryCheck.setDateOfReporting(pull.getDateOfReporting());
                        tpmInventoryCheck.setInventoryWanyuan(pull.getInventoryWanyuan());
                        tpmInventoryCheck.setStorageAgeDay(pull.getStorageAgeDay());
                        tpmInventoryCheck.setIsAbnormal(pull.getIsAbnormal());
                        tpmInventoryCheck.setOneThridShelfLifeTime(pull.getOneThridShelfLifeTime());
                        tpmInventoryCheck.setDeliveryWeeks(pull.getDeliveryWeeks());
                        tpmInventoryCheck.setTenantCode(tenantCode);
                        tpmInventoryCheck.setDelFlag(code);
                        updateList.add(tpmInventoryCheck);
                    } else {
                        pull.setInitQuantity(pull.getQuantity());
                        pull.setUsableQuantity(pull.getQuantity());
                        saveList.add((TpmInventoryCheck)((Object)pull));
                    }
                });
                if (!org.apache.commons.collections.CollectionUtils.isEmpty(saveList)) {
                    this.inventoryCheckTransService.saveDataList(saveList);
                }
                if (org.apache.commons.collections.CollectionUtils.isEmpty(updateList)) continue;
                this.inventoryCheckTransService.updateDataList(updateList);
            }
        }
        finally {
            if (lock) {
                this.unLock(lockKey);
            }
        }
    }

    private List<TpmInventoryCheck> InventoryDataValidate(List<MasterDataMdgInventoryVo> mdgInventoryVos) {
        List customerRetailerVoList;
        ArrayList<TpmInventoryCheck> pullList = new ArrayList<TpmInventoryCheck>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        java.sql.Date date = java.sql.Date.valueOf(sdf.format(new Date()));
        String normalCode = DelFlagStatusEnum.NORMAL.getCode();
        String tenantCode = TenantUtils.getTenantCode();
        String isYes = "1";
        String code = BusinessUnitEnum.VERTICAL.getCode();
        String currDate = DateUtil.getDateStrByFormat((Date)new Date(), (String)"yyyy-MM-dd");
        HashSet systemNameSet = Sets.newHashSet();
        mdgInventoryVos.forEach(InventoryVo -> {
            String system = InventoryVo.getSystem();
            Validate.notEmpty((CharSequence)system, (String)"\u7cfb\u7edf\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            String region = InventoryVo.getRegion();
            Validate.notEmpty((CharSequence)region, (String)"\u5927\u533a\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            String warehousename = InventoryVo.getWarehousename();
            Validate.notEmpty((CharSequence)warehousename, (String)"\u5206\u4ed3\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            String material = InventoryVo.getMaterial();
            Validate.notEmpty((CharSequence)material, (String)"\u4ea7\u54c1\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            String materialname = InventoryVo.getMaterialname();
            Validate.notEmpty((CharSequence)materialname, (String)"\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            String prodDate = InventoryVo.getProductionDate();
            Validate.notNull((Object)prodDate, (String)"\u5e93\u5b58\u4ea7\u54c1\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            String whInventory = InventoryVo.getWhInventory();
            Validate.notNull((Object)whInventory, (String)"\u5e93\u5b58\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            TpmInventoryCheck tpmInventoryCheck = new TpmInventoryCheck();
            tpmInventoryCheck.setSourceType("master_data_mdg");
            tpmInventoryCheck.setDateOfReporting(date);
            tpmInventoryCheck.setBusinessUnitCode(code);
            tpmInventoryCheck.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
            tpmInventoryCheck.setInventoryType("BRANCH_WAREHOUSE_INVENTORY");
            tpmInventoryCheck.setDelFlag(normalCode);
            tpmInventoryCheck.setTenantCode(tenantCode);
            if (StringUtils.isEmpty((CharSequence)InventoryVo.getOneThridShelfLifeTime()) && currDate.compareTo(InventoryVo.getOneThridShelfLifeTime()) > 0) {
                tpmInventoryCheck.setDateIsLarge(isYes);
            } else {
                tpmInventoryCheck.setDateIsLarge("0");
            }
            tpmInventoryCheck.setSystemCode(system);
            tpmInventoryCheck.setCustomerRetailerName(system);
            tpmInventoryCheck.setTerminalRegionName(region);
            tpmInventoryCheck.setBranchWarehouse(warehousename);
            tpmInventoryCheck.setProductCode(material);
            tpmInventoryCheck.setProductName(materialname);
            this.productData(material, tpmInventoryCheck);
            Integer productDate = Integer.valueOf(prodDate);
            tpmInventoryCheck.setProdDate(productDate);
            tpmInventoryCheck.setProductionStartDate(this.transition(productDate));
            Double quantity = Double.parseDouble(whInventory);
            tpmInventoryCheck.setQuantity(((Number)quantity).intValue());
            String inventoryWanyuan = InventoryVo.getInventoryWanyuan();
            if (StringUtils.isEmpty((CharSequence)inventoryWanyuan)) {
                tpmInventoryCheck.setInventoryWanyuan(BigDecimal.ZERO);
            } else {
                tpmInventoryCheck.setInventoryWanyuan(new BigDecimal(inventoryWanyuan));
            }
            tpmInventoryCheck.setStorageAgeDay(InventoryVo.getStorageAgeDay());
            tpmInventoryCheck.setIsAbnormal(InventoryVo.getIsAbnormal());
            tpmInventoryCheck.setOneThridShelfLifeTime(InventoryVo.getOneThridShelfLifeTime());
            tpmInventoryCheck.setDeliveryWeeks(InventoryVo.getDeliveryWeeks());
            tpmInventoryCheck.setVerifyCode(tpmInventoryCheck.getBusinessFormatCode() + code + system + region + warehousename + material + prodDate);
            String productionStartDate = tpmInventoryCheck.getProductionStartDate();
            if (StringUtils.isBlank((CharSequence)tpmInventoryCheck.getProductMonth()) && StringUtils.isNotBlank((CharSequence)productionStartDate)) {
                tpmInventoryCheck.setProductMonth(productionStartDate.substring(5, productionStartDate.lastIndexOf("-")));
            }
            tpmInventoryCheck.setId(UUID.randomUUID().toString().replace("-", ""));
            pullList.add(tpmInventoryCheck);
        });
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)systemNameSet) && !org.apache.commons.collections.CollectionUtils.isEmpty((Collection)(customerRetailerVoList = this.customerRetailerVoService.findByNames((List)Lists.newArrayList((Iterable)systemNameSet))))) {
            Map<String, String> customerRetailerMap = customerRetailerVoList.stream().collect(Collectors.toMap(CustomerRetailerVo::getCustomerRetailerName, CustomerRetailerVo::getCustomerRetailerCode, (o, n) -> n));
            for (TpmInventoryCheck tpmInventoryCheck : pullList) {
                String systemName = tpmInventoryCheck.getSystemCode();
                String systemCode = customerRetailerMap.get(systemName);
                if (StringUtils.isEmpty((CharSequence)systemCode)) continue;
                tpmInventoryCheck.setCustomerRetailerCode(systemCode);
                tpmInventoryCheck.setCustomerRetailerName(systemName);
            }
        }
        return pullList;
    }

    private void productData(String material, TpmInventoryCheck tpmInventoryCheck) {
        ProductQueryDto productQueryDto = new ProductQueryDto();
        productQueryDto.setProductCode(material);
        List byQueryDto = this.productVoService.findByQueryDto(productQueryDto);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)byQueryDto)) {
            ProductVo productVo = (ProductVo)byQueryDto.get(0);
            tpmInventoryCheck.setBusinessFormatCode(productVo.getBusinessFormatCode());
            tpmInventoryCheck.setExpirationDate(productVo.getExpirationDate());
        }
    }

    private CowMasterGuestInventoryDto getCowMasterGuestInventoryDto(TpmInventoryCheckDto dto, SimpleDateFormat sdf) {
        CowMasterGuestInventoryDto InventoryDto = new CowMasterGuestInventoryDto();
        String createDateStart = dto.getCreateDateStart();
        String newDate = sdf.format(new Date());
        if (StringUtils.isEmpty((CharSequence)createDateStart)) {
            InventoryDto.setCreateDateStart(this.defaultDate(sdf));
        } else {
            InventoryDto.setCreateDateStart(createDateStart);
        }
        String createDateEnd = dto.getCreateDateEnd();
        if (StringUtils.isEmpty((CharSequence)createDateEnd)) {
            InventoryDto.setCreateDateEnd(this.defaultDate(sdf));
        } else {
            InventoryDto.setCreateDateEnd(createDateEnd);
        }
        InventoryDto.setStoreId(dto.getTerminalCode());
        InventoryDto.setSapCode(dto.getProductCode());
        String productionStartDate = dto.getProductionStartDate();
        if (StringUtils.isNotEmpty((CharSequence)productionStartDate)) {
            String date = productionStartDate.replace("-", "");
            InventoryDto.setProdDate(Integer.valueOf(date));
        }
        return InventoryDto;
    }

    private List<TpmInventoryCheck> InventoryDataValidate(List<CowMasterGuestInventoryVo> inventoryVoList, SimpleDateFormat sdf) {
        ArrayList<TpmInventoryCheck> pullList = new ArrayList<TpmInventoryCheck>();
        String normalCode = DelFlagStatusEnum.NORMAL.getCode();
        String tenantCode = TenantUtils.getTenantCode();
        String isYes = "1";
        ArrayList codeList = new ArrayList(1);
        inventoryVoList.forEach(InventoryVo -> {
            String storeId = InventoryVo.getStoreId();
            String storeName = InventoryVo.getStoreName();
            Validate.notEmpty((CharSequence)storeName, (String)"\u95e8\u5e97\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            String sapCode = InventoryVo.getSapCode();
            Validate.notEmpty((CharSequence)sapCode, (String)"\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            String sapName = InventoryVo.getSapName();
            Validate.notEmpty((CharSequence)sapName, (String)"\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Integer prodDate = InventoryVo.getProdDate();
            Validate.notNull((Object)prodDate, (String)"\u4ea7\u54c1\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Integer giftsNum = InventoryVo.getGiftsNum();
            Integer stockNum = InventoryVo.getStockNum();
            Long createTime = InventoryVo.getCreateTime();
            Validate.notNull((Object)createTime, (String)"\u5e93\u5b58\u63d0\u62a5\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            TpmInventoryCheck tpmInventoryCheck = new TpmInventoryCheck();
            tpmInventoryCheck.setSourceType("cow_master_guest");
            tpmInventoryCheck.setTerminalCode(storeId);
            tpmInventoryCheck.setTerminalName(storeName);
            tpmInventoryCheck.setProductCode(sapCode);
            tpmInventoryCheck.setProductName(sapName);
            tpmInventoryCheck.setProdDate(prodDate);
            tpmInventoryCheck.setProductionStartDate(this.transition(prodDate));
            tpmInventoryCheck.setQuantity(stockNum);
            tpmInventoryCheck.setGiftNumber(giftsNum);
            this.productData(sapCode, tpmInventoryCheck);
            tpmInventoryCheck.setDateOfReporting(java.sql.Date.valueOf(sdf.format(new Date(createTime))));
            tpmInventoryCheck.setVerifyCode(tpmInventoryCheck.getBusinessFormatCode() + tpmInventoryCheck.getBusinessUnitCode() + storeId + sapCode + prodDate);
            tpmInventoryCheck.setTenantCode(tenantCode);
            tpmInventoryCheck.setDelFlag(normalCode);
            tpmInventoryCheck.setDateIsLarge(isYes);
            tpmInventoryCheck.setInventoryType("TERMINAL_INVENTORY");
            tpmInventoryCheck.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
            tpmInventoryCheck.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
            codeList.add(storeId);
            List terminalVos = this.terminalVoService.findDetailsByIdsOrTerminalCodes(null, codeList);
            if (null != terminalVos && terminalVos.size() > 0) {
                TerminalVo terminalVo = (TerminalVo)terminalVos.get(0);
                tpmInventoryCheck.setTerminalRegionCode(terminalVo.getRegionCode());
                tpmInventoryCheck.setTerminalRegionName(terminalVo.getRegionName());
                tpmInventoryCheck.setCustomerRetailerCode(terminalVo.getCustomerRetailerCode());
                tpmInventoryCheck.setCustomerRetailerName(terminalVo.getCustomerRetailerName());
            }
            String productionStartDate = tpmInventoryCheck.getProductionStartDate();
            if (StringUtils.isBlank((CharSequence)tpmInventoryCheck.getProductMonth()) && StringUtils.isNotBlank((CharSequence)productionStartDate)) {
                tpmInventoryCheck.setProductMonth(productionStartDate.substring(5, productionStartDate.lastIndexOf("-")));
            }
            tpmInventoryCheck.setId(UUID.randomUUID().toString().replace("-", ""));
            codeList.clear();
            pullList.add(tpmInventoryCheck);
        });
        return pullList;
    }

    private String transition(Integer prodDate) {
        StringBuffer str = new StringBuffer(String.valueOf(prodDate));
        str.insert(6, "-");
        str.insert(4, "-");
        return String.valueOf(str);
    }

    private String defaultDate(SimpleDateFormat sdf) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(new Date());
        ca.add(5, -1);
        String date = sdf.format(ca.getTime());
        return date;
    }

    private void unLock(String lockKey) {
        if (StringUtils.isEmpty((CharSequence)lockKey)) {
            throw new RuntimeException("\u62c9\u53d6\u5e93\u5b58\u6570\u636e\u89e3\u9501\u5931\u8d25\uff0c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.redisLockService.unlock("inventory_report_lock:lock:" + lockKey);
    }

    private boolean lock(String lockKey) {
        if (StringUtils.isEmpty((CharSequence)lockKey)) {
            throw new RuntimeException("\u62c9\u53d6\u5e93\u5b58\u6570\u636e\u52a0\u9501\u5931\u8d25\uff0c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return this.redisLockService.tryLock("inventory_report_lock:lock:" + lockKey, TimeUnit.HOURS, 12L);
    }

    private void createValidate(TpmInventoryCheckDto dto) {
        Validate.notNull((Object)dto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        dto.setId(UUID.randomUUID().toString().replace("-", ""));
        Validate.notNull((Object)dto.getSourceType(), (String)"\u65b0\u589e\u65f6\uff0c\u6570\u636e\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getInventoryType(), (String)"\u65b0\u589e\u65f6\uff0c\u5e93\u5b58\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getDateIsLarge(), (String)"\u65b0\u589e\u65f6\uff0c\u662f\u5426\u5927\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getBusinessFormatCode(), (String)"\u65b0\u589e\u65f6\uff0c\u4e1a\u6001\u5fc5\u987b\u9009\u62e9\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getBusinessUnitCode(), (String)"\u65b0\u589e\u65f6\uff0c\u4e1a\u52a1\u5355\u5143\u5fc5\u987b\u9009\u62e9\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getSalesOrgName(), (String)"\u65b0\u589e\u65f6\uff0c\u9500\u552e\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getProductName(), (String)"\u65b0\u589e\u65f6\uff0c\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getProductCode(), (String)"\u65b0\u589e\u65f6\uff0c\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if ("BRANCH_WAREHOUSE_INVENTORY".equals(dto.getInventoryType())) {
            Validate.notNull((Object)dto.getBranchWarehouse(), (String)"\u65b0\u589e\u65f6\uff0c\u5206\u4ed3\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            dto.setFieldType("\u5206\u4ed3\u5e93\u5b58");
        } else if ("TERMINAL_INVENTORY".equals(dto.getInventoryType())) {
            Validate.notNull((Object)dto.getTerminalCode(), (String)"\u65b0\u589e\u65f6\uff0c\u95e8\u5e97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)dto.getTerminalName(), (String)"\u65b0\u589e\u65f6\uff0c\u95e8\u5e97\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            dto.setFieldType("\u95e8\u5e97\u5e93\u5b58");
        } else if ("CUSTOMER_INVENTORY".equals(dto.getInventoryType())) {
            Validate.notNull((Object)dto.getCustomerCode(), (String)"\u65b0\u589e\u65f6\uff0c\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)dto.getCustomerName(), (String)"\u65b0\u589e\u65f6\uff0c\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            dto.setFieldType("\u5ba2\u6237\u5e93\u5b58");
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getCustomerRetailerCode())) {
            dto.setFieldType("\u96f6\u552e\u5546");
        }
        Validate.notNull((Object)dto.getProductionStartDate(), (String)"\u65b0\u589e\u65f6\uff0c\u4ea7\u54c1\u65e5\u671f\u5fc5\u987b\u9009\u62e9\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getExpirationDate(), (String)"\u65b0\u589e\u65f6\uff0c\u4fdd\u8d28\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.matchesPattern((CharSequence)String.valueOf(dto.getExpirationDays()), (String)"[+-]?((\\d+\\.?\\d*){1}|(\\d+\\.?){1}|(\\.{1}\\d+){1}){1}([eE]{1}[+-]?\\d+)?", (String)"\u65b0\u589e\u65f6\uff0c\u4fdd\u8d28\u671f\u5269\u4f59\u5929\u6570\u5fc5\u987b\u4e3a\u6570\u503c\uff01", (Object[])new Object[0]);
        Validate.matchesPattern((CharSequence)String.valueOf(dto.getQuantity()), (String)"[+-]?((\\d+\\.?\\d*){1}|(\\d+\\.?){1}|(\\.{1}\\d+){1}){1}([eE]{1}[+-]?\\d+)?", (String)"\u65b0\u589e\u65f6\uff0c\u6570\u91cf\u5fc5\u987b\u4e3a\u6570\u503c\uff01", (Object[])new Object[0]);
        Validate.matchesPattern((CharSequence)String.valueOf(dto.getGiftNumber()), (String)"[+-]?((\\d+\\.?\\d*){1}|(\\d+\\.?){1}|(\\.{1}\\d+){1}){1}([eE]{1}[+-]?\\d+)?", (String)"\u65b0\u589e\u65f6\uff0c\u8d60\u54c1\u6570\u91cf\u5fc5\u987b\u4e3a\u6570\u503c\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getDateOfReporting(), (String)"\u65b0\u589e\u65f6\uff0c\u5e93\u5b58\u63d0\u62a5\u65e5\u671f\u5fc5\u987b\u9009\u62e9\uff01", (Object[])new Object[0]);
        if (dto.getRemark() != null) {
            Validate.isTrue((dto.getRemark().length() < 100 ? 1 : 0) != 0, (String)"\u65b0\u589e\u65f6\uff0c\u6700\u5927\u5907\u6ce8\u957f\u5ea6\u4e3a100", (Object[])new Object[0]);
        }
    }

    private void updateValidate(TpmInventoryCheckDto dto) {
        Validate.notNull((Object)dto, (String)"\u7f16\u8f91\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getId(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)"1".equals(dto.getSourceType()), (String)"\u53ea\u80fd\u5bf9\"\u624b\u5de5\u5f55\u5165\"\u7684\u6570\u636e\u8fdb\u884c\u7f16\u8f91!", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getSourceType(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u6570\u636e\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getInventoryType(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u5e93\u5b58\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getDateIsLarge(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u662f\u5426\u5927\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getBusinessFormatCode(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u4e1a\u6001\u5fc5\u987b\u9009\u62e9\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getBusinessUnitCode(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u4e1a\u52a1\u5355\u5143\u5fc5\u987b\u9009\u62e9\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getSalesOrgName(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u9500\u552e\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getProductName(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getProductCode(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if ("BRANCH_WAREHOUSE_INVENTORY".equals(dto.getInventoryType())) {
            Validate.notNull((Object)dto.getBranchWarehouse(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u5206\u4ed3\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        } else if ("TERMINAL_INVENTORY".equals(dto.getInventoryType())) {
            Validate.notNull((Object)dto.getTerminalCode(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u95e8\u5e97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)dto.getTerminalName(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u95e8\u5e97\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        } else if ("CUSTOMER_INVENTORY".equals(dto.getInventoryType())) {
            Validate.notNull((Object)dto.getCustomerCode(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)dto.getCustomerName(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        }
        Validate.notNull((Object)dto.getProductionStartDate(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u4ea7\u54c1\u65e5\u671f\u5fc5\u987b\u9009\u62e9\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getExpirationDate(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u4fdd\u8d28\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.matchesPattern((CharSequence)String.valueOf(dto.getExpirationDays()), (String)"[+-]?((\\d+\\.?\\d*){1}|(\\d+\\.?){1}|(\\.{1}\\d+){1}){1}([eE]{1}[+-]?\\d+)?", (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u4fdd\u8d28\u671f\u5269\u4f59\u5929\u6570\u5fc5\u987b\u4e3a\u6570\u503c\uff01", (Object[])new Object[0]);
        Validate.matchesPattern((CharSequence)String.valueOf(dto.getQuantity()), (String)"[+-]?((\\d+\\.?\\d*){1}|(\\d+\\.?){1}|(\\.{1}\\d+){1}){1}([eE]{1}[+-]?\\d+)?", (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u6570\u91cf\u5fc5\u987b\u4e3a\u6570\u503c\uff01", (Object[])new Object[0]);
        Validate.matchesPattern((CharSequence)String.valueOf(dto.getGiftNumber()), (String)"[+-]?((\\d+\\.?\\d*){1}|(\\d+\\.?){1}|(\\.{1}\\d+){1}){1}([eE]{1}[+-]?\\d+)?", (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u8d60\u54c1\u6570\u91cf\u5fc5\u987b\u4e3a\u6570\u503c\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getDateOfReporting(), (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u5e93\u5b58\u63d0\u62a5\u65e5\u671f\u5fc5\u987b\u9009\u62e9\uff01", (Object[])new Object[0]);
        if (dto.getRemark() != null) {
            Validate.isTrue((dto.getRemark().length() < 100 ? 1 : 0) != 0, (String)"\u7f16\u8f91\u6570\u636e\u65f6\uff0c\u6700\u5927\u5907\u6ce8\u957f\u5ea6\u4e3a100", (Object[])new Object[0]);
        }
    }

    public Integer getQuantityByCondition(TpmInventoryCheckDto dto) {
        return this.tpmInventoryCheckRepository.getQuantityByCondition(dto);
    }

    public void operateInventoryCheck(List<OperateInventoryCheckDto> operateList) {
        if (CollectionUtils.isEmpty(operateList)) {
            return;
        }
        boolean hasWareHouse = operateList.stream().anyMatch(item -> StringUtils.isNotEmpty((CharSequence)item.getAcWarehouseCode()));
        ArrayList dictTypeCodeList = Lists.newArrayList();
        dictTypeCodeList.add("warehouse_division");
        dictTypeCodeList.add("MDM_CUSTOMIZE_ORG");
        Map dictDataList = this.dictDataVoService.findByDictTypeCodeList((List)dictTypeCodeList);
        if (hasWareHouse) {
            List warehouseDivisionList = (List)dictDataList.get("warehouse_division");
            Map<String, String> warehouseDivisionMap = warehouseDivisionList.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue, (o, n) -> n));
            for (OperateInventoryCheckDto operateInventoryCheckDto : operateList) {
                if (!StringUtils.isNotEmpty((CharSequence)operateInventoryCheckDto.getAcWarehouseCode())) continue;
                operateInventoryCheckDto.setAcWarehouseName(warehouseDivisionMap.get(operateInventoryCheckDto.getAcWarehouseCode()));
            }
        }
        List regionDictList = (List)dictDataList.get("MDM_CUSTOMIZE_ORG");
        Map<String, String> regionDictMap = regionDictList.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue, (o, n) -> n));
        for (OperateInventoryCheckDto operateInventoryCheckDto : operateList) {
            if (!StringUtils.isNotEmpty((CharSequence)operateInventoryCheckDto.getRegion())) continue;
            operateInventoryCheckDto.setRegion(regionDictMap.get(operateInventoryCheckDto.getRegion()));
        }
        List<TpmInventoryCheck> entityList = this.validateOperateInventoryCheck(operateList);
        Map<String, List<TpmInventoryCheck>> entityMap = entityList.stream().collect(Collectors.groupingBy(item -> {
            if ("BRANCH_WAREHOUSE_INVENTORY".equals(item.getInventoryType())) {
                return this.getNotNullStr(item.getBranchWarehouse()) + item.getProductCode();
            }
            if ("TERMINAL_INVENTORY".equals(item.getInventoryType())) {
                return this.getNotNullStr(item.getTerminalCode()) + item.getProductCode();
            }
            throw new RuntimeException("\u672a\u5b9a\u4e49\u7684\u5927\u65e5\u671f\u6765\u6e90\u7c7b\u578b\uff01");
        }));
        String tenantCode = TenantUtils.getTenantCode();
        Boolean throwException = operateList.get(0).getThrowException();
        HashSet updateSet = Sets.newHashSet();
        ArrayList detailList = Lists.newArrayList();
        operateList.sort(Comparator.comparing(OperateInventoryCheckDto::getThisProductProductionDateStr));
        block2: for (OperateInventoryCheckDto operateDto : operateList) {
            String operationType = operateDto.getOperationType();
            String businessCode = operateDto.getBusinessCode();
            StringBuilder businessDesc = new StringBuilder();
            if (StringUtils.isNotEmpty((CharSequence)businessCode)) {
                businessDesc.append("[").append(businessCode).append("]");
            }
            String operationKey = "";
            if ("BRANCH_WAREHOUSE_INVENTORY".equals(operateDto.getInventoryType())) {
                operationKey = this.getNotNullStr(operateDto.getAcWarehouseName()) + operateDto.getProductCode();
                if (StringUtils.isNotEmpty((CharSequence)operateDto.getAcWarehouseName())) {
                    businessDesc.append("\u5206\u4ed3[").append(operateDto.getAcWarehouseName()).append("]");
                }
            } else if ("TERMINAL_INVENTORY".equals(operateDto.getInventoryType())) {
                operationKey = this.getNotNullStr(operateDto.getTerminalCode()) + operateDto.getProductCode();
                if (StringUtils.isNotEmpty((CharSequence)operateDto.getTerminalCode())) {
                    businessDesc.append("\u95e8\u5e97[").append(operateDto.getTerminalCode()).append("]");
                }
            }
            businessDesc.append("\u4ea7\u54c1[").append(operateDto.getProductCode()).append("]");
            businessDesc.append("\u672c\u54c1\u751f\u6210\u65e5\u671f[").append(operateDto.getThisProductProductionDateStr()).append("]");
            List<TpmInventoryCheck> thisEntityList = entityMap.getOrDefault(operationKey, Lists.newArrayList());
            thisEntityList = thisEntityList.stream().filter(item -> item.getProductionStartDate().compareTo(operateDto.getThisProductProductionDateStr()) <= 0).collect(Collectors.toList());
            Integer operationQuantity = operateDto.getOperationQuantity();
            if (org.apache.commons.collections.CollectionUtils.isEmpty(thisEntityList)) {
                if (!InventoryCheckOperationTypeEnum.USE.getCode().equals(operationType)) continue;
                throw new RuntimeException("\u6ca1\u6709\u627e\u5230" + businessDesc + "\u7684\u5927\u65e5\u671f\u5e93\u5b58\u6570\u636e!");
            }
            int totalUsableQuantity = thisEntityList.stream().mapToInt(item -> Optional.ofNullable(item.getUsableQuantity()).orElse(0)).sum();
            if (InventoryCheckOperationTypeEnum.USE.getCode().equals(operationType)) {
                if (operationQuantity > 0 && operationQuantity > totalUsableQuantity) {
                    throw new RuntimeException(businessDesc + "\u5e93\u5b58\u76d8\u70b9\u5269\u4f59\u53ef\u64cd\u4f5c\u6570\u91cf[" + totalUsableQuantity + "]\uff0c\u672c\u6b21\u64cd\u4f5c\u6570\u91cf[" + operationQuantity + "]\uff01");
                }
                thisEntityList.sort(Comparator.comparing(TpmInventoryCheck::getProductionStartDate));
            } else if (InventoryCheckOperationTypeEnum.RETURN.getCode().equals(operationType)) {
                if (operationQuantity < 0 && -operationQuantity.intValue() > totalUsableQuantity) {
                    throw new RuntimeException(businessDesc + "\u5e93\u5b58\u76d8\u70b9\u5269\u4f59\u53ef\u64cd\u4f5c\u6570\u91cf[" + totalUsableQuantity + "]\uff0c\u672c\u6b21\u64cd\u4f5c\u6570\u91cf[" + -operationQuantity.intValue() + "]\uff01");
                }
                thisEntityList.sort(Comparator.comparing(TpmInventoryCheck::getProductionStartDate).reversed());
            } else {
                throw new RuntimeException(businessDesc + "\u5e93\u5b58\u76d8\u70b9\u5360\u7528\u6570\u91cf\u64cd\u4f5c\u7c7b\u578b\u6709\u8bef\uff01");
            }
            for (TpmInventoryCheck entity : thisEntityList) {
                if (operationQuantity == 0) continue block2;
                int usableQuantity = Optional.ofNullable(entity.getUsableQuantity()).orElse(0);
                int usedQuantity = Optional.ofNullable(entity.getUsedQuantity()).orElse(0);
                if (entity.getQuantity() < usableQuantity) {
                    usableQuantity = entity.getQuantity();
                }
                int thisOperationQuantity = operationQuantity;
                if (InventoryCheckOperationTypeEnum.USE.getCode().equals(operationType)) {
                    if (thisOperationQuantity > usableQuantity) {
                        thisOperationQuantity = usableQuantity;
                    }
                    operationQuantity = operationQuantity - thisOperationQuantity;
                } else {
                    if (thisOperationQuantity > usedQuantity) {
                        thisOperationQuantity = usedQuantity;
                    }
                    operationQuantity = operationQuantity - thisOperationQuantity;
                    thisOperationQuantity = -thisOperationQuantity;
                }
                if (thisOperationQuantity == 0) continue;
                TpmInventoryCheckOperation tpmInventoryCheckOperation = new TpmInventoryCheckOperation();
                tpmInventoryCheckOperation.setTenantCode(tenantCode);
                tpmInventoryCheckOperation.setBusinessCode(operateDto.getBusinessCode());
                tpmInventoryCheckOperation.setInventoryCheckId(entity.getId());
                tpmInventoryCheckOperation.setBeforeQuantity(usableQuantity);
                entity.setUsableQuantity(usableQuantity - thisOperationQuantity);
                entity.setUsedQuantity(usedQuantity + thisOperationQuantity);
                tpmInventoryCheckOperation.setOperationQuantity(thisOperationQuantity);
                tpmInventoryCheckOperation.setAfterQuantity(entity.getUsableQuantity());
                tpmInventoryCheckOperation.setAllUsableQuantity(totalUsableQuantity);
                detailList.add(tpmInventoryCheckOperation);
                updateSet.add(entity);
            }
        }
        Boolean doSave = operateList.get(0).getDoSave();
        if (null == doSave || doSave.booleanValue()) {
            if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)updateSet)) {
                this.tpmInventoryCheckRepository.updateBatchById(updateSet);
            }
            if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)detailList)) {
                this.tpmInventoryCheckOperationRepository.saveBatch(detailList);
            }
        }
    }

    private String getNotNullStr(String str) {
        return null == str ? "" : str;
    }

    private List<TpmInventoryCheck> validateOperateInventoryCheck(List<OperateInventoryCheckDto> operateList) {
        for (OperateInventoryCheckDto operateDto : operateList) {
            Validate.notBlank((CharSequence)operateDto.getOperationType(), (String)"\u5e93\u5b58\u76d8\u70b9\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)operateDto.getProductCode(), (String)"\u64cd\u4f5c\u5e93\u5b58\u65f6\uff0c\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)operateDto.getBusinessFormatCode(), (String)"\u64cd\u4f5c\u9884\u7b97\u65f6\uff0c\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)operateDto.getBusinessUnitCode(), (String)"\u64cd\u4f5c\u9884\u7b97\u65f6\uff0c\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)operateDto.getSystemName(), (String)"\u64cd\u4f5c\u9884\u7b97\u65f6\uff0c\u96f6\u552e\u5546\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)operateDto.getRegion(), (String)"\u64cd\u4f5c\u9884\u7b97\u65f6\uff0c\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)operateDto.getThisProductProductionDateStr(), (String)"\u64cd\u4f5c\u9884\u7b97\u65f6\uff0c\u672c\u54c1\u751f\u4ea7\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        }
        OperateInventoryCheckDto operateInventoryCheckDto = new OperateInventoryCheckDto();
        String maxProductDate = operateList.stream().map(OperateInventoryCheckDto::getThisProductProductionDateStr).max(String::compareTo).get();
        operateInventoryCheckDto.setThisProductProductionDateStr(maxProductDate);
        List productCodeList = operateList.stream().map(OperateInventoryCheckDto::getProductCode).distinct().collect(Collectors.toList());
        operateInventoryCheckDto.setProductCodeList(productCodeList);
        List terminalCodeList = operateList.stream().map(OperateInventoryCheckDto::getTerminalCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        operateInventoryCheckDto.setTerminalCodeList(terminalCodeList);
        List warHouseNameList = operateList.stream().map(OperateInventoryCheckDto::getAcWarehouseName).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        operateInventoryCheckDto.setWarHouseNameList(warHouseNameList);
        List regionList = operateList.stream().map(OperateInventoryCheckDto::getRegion).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        operateInventoryCheckDto.setRegionNameList(regionList);
        List systemCodeList = operateList.stream().map(OperateInventoryCheckDto::getSystemName).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        operateInventoryCheckDto.setSystemNameList(systemCodeList);
        List<TpmInventoryCheck> entityList = this.tpmInventoryCheckRepository.findListToOperate(operateInventoryCheckDto);
        for (TpmInventoryCheck entity : entityList) {
            if (null == entity.getUsedQuantity()) {
                entity.setUsedQuantity(0);
            }
            if (null != entity.getUsableQuantity()) continue;
            entity.setUsableQuantity(entity.getInitQuantity());
        }
        return entityList;
    }
}

