package com.biz.crm.tpm.business.inventory.check.manage.sdk.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
public class InventoryDataVerifyDto {
    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "业态[数据字典:mdm_business_format]")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "业务单元[数据字典:mdm_business_unit]")
    private String businessUnitCode;

    /**
     * 销售组织
     */
    @ApiModelProperty(name = "销售组织", notes = "销售组织")
    private String salesOrgCode;

    /**
     * 区域（终端区域）
     */
    @ApiModelProperty(name = "区域（终端区域）", notes = "区域（终端区域）")
    private String terminalRegionName;

    /**
     * 分仓
     */
    @ApiModelProperty(name = "分仓", notes = "分仓")
    private String branchWarehouse;

    /**
     * 客户编码
     */
    @ApiModelProperty(name = "客户编码", notes = "客户编码")
    private String customerCode;

    /**
     * 零售商编码
     */
    @ApiModelProperty(name = "零售商编码", notes = "零售商编码")
    private String customerRetailerCode;

    /**
     * 门店编码(终端编码)
     */
    @ApiModelProperty(name = "门店编码(终端编码)", notes = "门店编码(终端编码)")
    private String terminalCode;

    /**
     * 商品编码(产品编码)
     */
    @ApiModelProperty(name = "商品编码", notes = "商品编码")
    private String productCode;

    /**
     * 校验字段
     */
    private String fieldType;
    /**
     * 字段编码
     */
    private String fieldCode;
    /**
     * 校验编码
     */
    private String verifyCode;
    /**
     * 产品月份
     */
    @ApiModelProperty(name = "产品月份", notes = "产品月份")
    private String productMonth;
}
