package com.biz.crm.tpm.business.inventory.check.manage.sdk.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 库存盘点扣减VO
 * @author wanghaojia
 * @date 2023/6/20 10:21
 */
@Data
public class OperateInventoryCheckDto {

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "业态[数据字典:mdm_business_format]")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "业务单元[数据字典:mdm_business_unit]")
    private String businessUnitCode;

    /**
     * 门店名称
     */
    @ApiModelProperty("门店名称")
    private String terminalCode;

    /**
     * AC分仓编码
     */
    @ApiModelProperty("AC分仓编码")
    private String acWarehouseCode;
    /**
     * AC分仓名称
     */
    @ApiModelProperty("AC分仓名称")
    private String acWarehouseName;

    /**
     * 系统/零售商
     */
    @ApiModelProperty("系统/零售商")
    private String systemCode;
    /**
     * 系统/零售商
     */
    @ApiModelProperty("系统/零售商")
    private String systemName;
    /**
     * 区域
     */
    @ApiModelProperty("区域")
    private String region;

    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    private String productCode;
    /**
     * 本品生产日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String thisProductProductionDateStr;

    /**
     * 业务编码
     */
    @ApiModelProperty("业务编码")
    private String businessCode;

    /**
     * 操作类型
     */
    @ApiModelProperty("操作类型")
    private String operationType;

    /**
     * 库存类型（数据字典：门店库存/客户库存/分仓库存）
     */
    @ApiModelProperty(name = "库存类型（数据字典：门店库存/客户库存/分仓库存）", notes = "库存类型")
    private String inventoryType;

    /**
     * 本次操作数量
     */
    @ApiModelProperty("本次操作数量")
    private Integer operationQuantity;

    /**
     * 是否保存
     */
    @ApiModelProperty("是否保存")
    private Boolean doSave = true;

    /**
     * 是否抛出异常
     */
    @ApiModelProperty("是否抛出异常")
    private Boolean throwException = true;

    /**
     * 区域
     */
    @ApiModelProperty("区域")
    private List<String> regionNameList;
    /**
     * 系统/零售商
     */
    @ApiModelProperty("系统/零售商")
    private List<String> systemNameList;

    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    private List<String> productCodeList;
    /**
     * 门店编码
     */
    @ApiModelProperty("门店编码")
    private List<String> terminalCodeList;
    /**
     * 分仓
     */
    @ApiModelProperty("分仓")
    private List<String> warHouseNameList;


}
