package com.biz.crm.tpm.business.inventory.check.manage.sdk.event.log;

import com.biz.crm.tpm.business.inventory.check.manage.sdk.dto.log.InventoryCheckManageLogEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * @author ：heding
 * @date ：Created in 2022/11/21 17:48:56
 * @description：活动承接配置日志接口
 */
public interface InventoryCheckManageEventListener extends NebulaEvent {
    /**
     * 创建事件
     *
     * @param eventDto
     */
    void onCreate(InventoryCheckManageLogEventDto eventDto);
    /**
     * 删除事件
     *
     * @param eventDto
     */
    void onDelete(InventoryCheckManageLogEventDto eventDto);
    /**
     * 更新日志
     *
     * @param eventDto
     */
    void onUpdate(InventoryCheckManageLogEventDto eventDto);
    /**
     * 启用
     *
     * @param eventDto
     */
    void onEnable(InventoryCheckManageLogEventDto eventDto);
    /**
     * 禁用
     *
     * @param eventDto
     */
    void onDisable(InventoryCheckManageLogEventDto eventDto);
}
