package com.biz.crm.tpm.business.inventory.check.manage.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgBaseDto;
import com.biz.crm.tpm.business.inventory.check.manage.sdk.dto.InventoryDataVerifyDto;
import com.biz.crm.tpm.business.inventory.check.manage.sdk.dto.OperateInventoryCheckDto;
import com.biz.crm.tpm.business.inventory.check.manage.sdk.dto.TpmInventoryCheckDto;
import com.biz.crm.tpm.business.inventory.check.manage.sdk.vo.TpmInventoryCheckVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 库存盘点(TpmInventoryCheck)表服务
 *
 * @author hd
 * @create 2022-11-17 11:41:28
 */
public interface TpmInventoryCheckService {
    /**
     * 新增数据
     *
     * @param dto 实体对象
     * @return 新增结果
     */
    TpmInventoryCheckVo create(TpmInventoryCheckDto dto);

    /**
     * 删除数据
     *
     * @param idList 主键集合
     */
    void delete(List<String> idList);

    /**
     * 编辑数据
     *
     * @param dto 实体对象
     * @return 编辑结果
     */
    TpmInventoryCheckVo update(TpmInventoryCheckDto dto);

    /**
     * 通过主键查询单条数据回显
     *
     * @param id 主键
     * @return 单条数据
     */
    TpmInventoryCheckVo findById(String id);

    /**
     * 批量新增
     *
     * @param importList 对象集合
     * @return 删除结果
     */
    void importSave(List<TpmInventoryCheckDto> importList);

    /**
     * 分页查询数据
     *
     * @param pageable 分页对象
     * @param dto      查询条件实体
     * @return
     */
    Page<TpmInventoryCheckVo> findByConditions(Pageable pageable, TpmInventoryCheckDto dto);

    /**
     * 禁用
     *
     * @param idList 主键集合
     * @return 禁用结果
     */
    void disable(List<String> idList);

    /**
     * 条件查询所有数据
     *
     *
     * @param pageable
     * @param dto 查询条件
     * @return 数据
     */
    Page<TpmInventoryCheckVo> findAllByConditions(Pageable pageable, TpmInventoryCheckDto dto);

    /**
     * 条件查询
     *
     * @param dto
     * @return
     */
    List<TpmInventoryCheckVo> findListByConditions(TpmInventoryCheckDto dto);

    /**
     * 获取匹配的数据总量
     *
     * @param dto 查询条件
     * @return 条数
     */
    Integer getTotalByConditions(TpmInventoryCheckDto dto);

    /**
     * 批量拉取牛要客数据
     *
     * @param dto 查询实体
     * @return
     */
    void pullInventoryDataList(TpmInventoryCheckDto dto);

    /**
     * 校验数据库是否有相同数据
     * 业态+业务单元+销售组织+区域+产品+客户/门店/零售商/分仓
     *
     * @param VerifyDto 校验条件对象
     * @return
     */
    Boolean verifyRepetition(InventoryDataVerifyDto VerifyDto);

    /**
     * 批量拉取分仓大日期库存数据
     *
     * @param dto 查询条件实体
     * @return
     */
    void pullTpmInventoryList(MasterDataMdgBaseDto dto);

    /**
     * 定时批量拉取牛要客数据
     *
     * @return 所有数据
     */
    void pullInventoryDataList();

    /**
     * 定时批量拉取分仓大日期库存数据
     *
     * @return 所有数据
     */
    void pullTpmInventoryList();
    /**
     * 定时更新保质期剩余天数，是否大日期
     */
    void pullUpdateChange();

    /**
     * 根据条件查询库存数量
     */
    Integer getQuantityByCondition(TpmInventoryCheckDto dto);

    void operateInventoryCheck(List<OperateInventoryCheckDto> operateList);

}
