package com.biz.crm.tpm.business.inventory.check.manage.sdk.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.util.Date;

/**
 * @author heding
 * @create 2022-11-16 14:50:12
 * @description：库存盘点vo
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "TpmInventoryCheckDto", description = "TPM-库存盘点管理")
public class TpmInventoryCheckVo extends TenantFlagOpVo {
    /**
     * 数据来源
     */
    @ApiModelProperty(name = "数据来源", notes = "数据来源")
    private String sourceType;
    /**
     * 库存类型（数据字典：门店库存/客户库存/分仓库存）
     */
    @ApiModelProperty(name = "库存类型（数据字典：门店库存/客户库存/分仓库存）", notes = "库存类型")
    private String inventoryType;
    /**
     * 是否大日期(是/否)
     */
    @ApiModelProperty(name = "是否大日期(是/否)", notes = "是否大日期(是/否)")
    private String dateIsLarge;
    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "业态[数据字典:mdm_business_format]")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "业务单元[数据字典:mdm_business_unit]")
    private String businessUnitCode;
    /**
     * 销售组织
     */
    @ApiModelProperty(name = "销售组织",notes = "销售组织")
    private String salesOrgName;
    /**
     * 区域（终端区域）
     */
    @ApiModelProperty(name = "区域（终端区域）",notes ="区域（终端区域）" )
    private String terminalRegionName;
    /**
     * 区域编码
     */
    @ApiModelProperty("区域编码")
    private String terminalRegionCode;
    /**
     * 分仓
     */
    @ApiModelProperty(name = "分仓",notes ="分仓" )
    private String branchWarehouse;
    /**
     * 客户名称
     */
    @ApiModelProperty(name = "客户名称", notes = "客户名称")
    private String customerName;
    /**
     * 客户编码
     */
    @ApiModelProperty(name = "客户编码", notes = "客户编码")
    private String customerCode;
    /**
     * 零售商名称
     */
    @ApiModelProperty(name = "零售商名称", notes = "零售商名称")
    private String customerRetailerName;
    /**
     * 零售商编码
     */
    @ApiModelProperty(name = "零售商编码", notes = "零售商编码")
    private String customerRetailerCode;
    /**
     * 门店编码(终端编码)
     */
    @ApiModelProperty(name = "门店编码(终端编码)", notes = "门店编码(终端编码)")
    private String terminalCode;
    /**
     * 门店名称(终端名称)
     */
    @ApiModelProperty(name = "门店名称(终端名称)", notes = "门店名称(终端名称)")
    private String terminalName;
    /**
     * 商品名称(产品名字)
     */
    @ApiModelProperty(name = "商品名称", notes = "商品名称")
    private String productName;
    /**
     * 商品编码(产品编码)
     */
    @ApiModelProperty(name = "商品编码", notes = "商品编码")
    private String productCode;
    /**
     * 产品日期
     */
    @ApiModelProperty(name = "产品日期", notes = "产品日期")
    private String productionStartDate;
    /**
     * 产品日期（拉取）
     */
    @ApiModelProperty(name = "产品日期（拉取）", notes = "产品日期（拉取）")
    private Integer prodDate;
    /**
     * 保质期
     */
    @ApiModelProperty(name = "保质期", notes = "保质期")
    private Integer expirationDate;
    /**
     * 保质期单位
     */
//    @ApiModelProperty(name = "保质期单位", notes = "保质期单位")
//    private String expirationDateUnits;
    /**
     * 保质期剩余天数
     */
    @ApiModelProperty(name = "保质期剩余天数", notes = "保质期剩余天数")
    private Integer expirationDays;
    /**
     * 数量
     */
    @ApiModelProperty(name = "数量", notes = "数量")
    private Integer quantity;
    /**
     * 赠品数量
     */
    @ApiModelProperty(name = "赠品数量", notes = "赠品数量")
    private Integer giftNumber;
    /**
     * 库存提报日期
     */
    @ApiModelProperty(name = "库存提报日期", notes = "库存提报日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date dateOfReporting;
    /**
     * 品牌编码
     */
    @ApiModelProperty("品牌编码")
    private String productBrandCode;
    /**
     * 品牌名称
     */
    @ApiModelProperty("品牌名称")
    private String productBrandName;
    /**
     * 品类编码
     */
    @ApiModelProperty("品类编码")
    private String productCategoryCode;
    /**
     * 品类名称
     */
    @ApiModelProperty("品类名称")
    private String productCategoryName;
    /**
     * 品项编码
     */
    @ApiModelProperty("品项编码")
    private String productItemCode;
    /**
     * 品项名称
     */
    @ApiModelProperty("品项名称")
    private String productItemName;
    /**
     * 销售组织编码
     */
    @TableField(value = "sales_org_code")
    private String salesOrgCode;
    /**
     * 校验（门店编码+产品编码+产品日期）
     */
    @ApiModelProperty("校验字段")
    private String verifyCode;
    /**
     * 产品月份
     */
    @ApiModelProperty(name = "产品月份", notes = "产品月份")
    private String productMonth;
    /**
     * 渠道编码
     */
    @ApiModelProperty("渠道编码")
    private String channelCode;
    /**
     * 渠道名称
     */
    @ApiModelProperty("渠道名称")
    private String channelName;

    /**
     * 客户ERP编码
     */
    @ApiModelProperty("客户ERP编码")
    private String customerErpCode;

    /**
     * 销售组织ERP编码
     */
    @ApiModelProperty("销售组织ERP编码")
    private String salesOrgErpCode;
}
