package com.biz.crm.tpm.business.inventory.check.manage.sdk.vo.imports;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;


/**
 * @author heding
 * @create 2022-11-17 17:25:35
 */
@Data
@CrmExcelImport(startRow = 2)
@EqualsAndHashCode(callSuper = true)
public class TpmInventoryCheckImportsVo extends CrmExcelVo {

    /**
     * 库存类型（门店/客户/分仓）
     */
    @CrmExcelColumn(value = "库存类型（门店/客户/分仓）")
    private String inventoryType;
    /**
     * 业态（常温/低温/冰品)
     */
    @CrmExcelColumn(value = "业态（常温/低温/冰品)")
    private String businessFormatCode;
    /**
     * 业务单元（主体/分子公司/垂直重客/新零售）
     */
    @CrmExcelColumn(value = "业务单元（主体/分子公司/垂直重客/新零售）")
    private String businessUnitCode;
    /**
     * 渠道编码
     */
    @CrmExcelColumn(value = "渠道编码")
    private String channelCode;
    /**
     * 销售组织编码
     */
    @CrmExcelColumn(value = "销售组织编码")
    private String salesOrgCode;
    /**
     * 区域
     */
    @CrmExcelColumn(value = "区域")
    private String terminalRegionName;
    /**
     * 分仓
     */
    @CrmExcelColumn(value = "分仓")
    private String branchWarehouse;
    /**
     * 客户编码
     */
    @CrmExcelColumn(value = "客户编码")
    private String customerCode;
    /**
     * 零售商编码
     */
    @CrmExcelColumn(value = "零售商编码")
    private String customerRetailerCode;
    /**
     * 门店编码
     */
    @CrmExcelColumn(value = "门店编码")
    private String terminalCode;
    /**
     * 产品编码
     */
    @CrmExcelColumn(value = "产品编码")
    private String productCode;
    /**
     * 数量
     */
    @CrmExcelColumn(value = "数量")
    private Integer quantity;
    /**
     * 赠品数量
     */
    @CrmExcelColumn(value = "赠品数量")
    private Integer giftNumber;
    /**
     * 产品日期
     */
    @CrmExcelColumn(value = "产品日期")
    private String productionStartDate;
    /**
     * 库存提报日期
     */
    @CrmExcelColumn(value = "库存提报日期")
    private String dateOfReporting;
    /**
     * 备注
     */
    @CrmExcelColumn(value = "备注")
    private String remark;
    /**
     * 渠道名称
     */
    private String channelName;
}
