package com.biz.crm.tpm.business.key.indicators.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.base.util.DataTooLongGenerateRespUtil;
import com.biz.crm.tpm.business.key.indicators.local.entity.KeyIndicators;
import com.biz.crm.tpm.business.key.indicators.sdk.dto.KeyIndicatorsDto;
import com.biz.crm.tpm.business.key.indicators.sdk.service.KeyIndicatorsService;
import com.biz.crm.tpm.business.key.indicators.sdk.vo.KeyIndicatorsVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * 关键指标表(tpm_key_indicators) 控制层
 *
 * @author : qiancheng
 * @date : 2022-11-2
 */
@RestController
@RequestMapping("/v1/keyIndicators")
@Slf4j
@Api(tags = "关键指标")
public class KeyIndicatorsController {

    @Autowired
    private KeyIndicatorsService keyIndicatorsService;

    /**
     * 分页查询数据
     *
     * @param pageable      分页对象
     * @param keyIndicators 关键指标信息
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("/findByConditions")
    public Result<Page<KeyIndicatorsVO>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(20) Pageable pageable,
                                                          @ApiParam(name = "keyIndicatorsDto", value = "关键指标信息") KeyIndicatorsDto keyIndicators) {
        try {
            Page<KeyIndicatorsVO> page = this.keyIndicatorsService.findByConditions(pageable, keyIndicators);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 通过主键查询单条数据
     *
     * @param id 主键id
     * @return 单条数据
     */
    @ApiOperation(value = "通过主键查询单条数据")
    @GetMapping("/findById")
    public Result<KeyIndicatorsVO> findById(@RequestParam("id") @ApiParam(name = "id", value = "主键id") String id) {
        try {
            KeyIndicatorsVO keyIndicatorsVO = keyIndicatorsService.findById(id);
            return Result.ok(keyIndicatorsVO);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 查找bean
     *
     * @param beanCode 关键指标编码
     * @param beanTypes 指标类型拼接
     * @return
     */
    @ApiOperation(value = "查找bean")
    @GetMapping("/findBeanByCondition")
    public Result<KeyIndicatorsVO> findBeanByCondition(@RequestParam("beanCode") @ApiParam(name = "beanCode", value = "关键指标编码") String beanCode,
                                                @RequestParam("beanTypes") @ApiParam(name = "beanTypes", value = "指标类型拼接") String beanTypes) {
        try {
            return Result.ok(keyIndicatorsService.findBeanByCondition(beanCode, beanTypes));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 通过bean名称 查询bean路径
     *
     * @param beanName bean名称集合
     * @return
     */
    @ApiOperation(value = "通过bean名称查询bean路径")
    @GetMapping("/findBeanPath")
    public Result<KeyIndicatorsVO> findBeanPath(@RequestParam("beanName") @ApiParam(name = "beanName", value = "bean名称") String beanName) {
        try {
            KeyIndicatorsVO vo = keyIndicatorsService.findBeanPath(beanName);
            return Result.ok(vo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 模糊查询bean名称
     *
     * @param beanName bean名称
     * @return
     */
    @ApiOperation(value = "查询bean名称")
    @GetMapping("/findBeanNames")
    public Result<List<String>> findBeanName(@RequestParam("beanName") @ApiParam(name = "beanName", value = "bean名称") String beanName) {
        try {
            List<String> beanNames = keyIndicatorsService.findBeanName(beanName);
            return Result.ok(beanNames);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 新增数据
     *
     * @param keyIndicators 实体对象
     * @return 新增结果
     */
    @ApiOperation(value = "新增数据")
    @PostMapping()
    public Result<?> create(@ApiParam(name = "keyIndicators", value = "关键指标") @RequestBody KeyIndicatorsDto keyIndicators) {
        try {
            return Result.ok(this.keyIndicatorsService.create(keyIndicators));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(DataTooLongGenerateRespUtil.generateRespStr(e, KeyIndicators.class));
        }
    }


    /**
     * 修改数据
     *
     * @param keyIndicators 实体对象
     * @return 修改结果
     */
    @ApiOperation(value = "修改数据")
    @PatchMapping
    public Result<?> update(@ApiParam(name = "keyIndicators", value = "关键指标") @RequestBody KeyIndicatorsDto keyIndicators) {
        try {
            this.keyIndicatorsService.update(keyIndicators);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(DataTooLongGenerateRespUtil.generateRespStr(e, KeyIndicators.class));
        }
    }

    /**
     * 修改数据
     *
     * @param keyIndicators 实体对象
     * @return 修改结果
     */
    @ApiOperation(value = "修改数据")
    @PostMapping("updatePos")
    public Result<?> updatePos(@ApiParam(name = "keyIndicators", value = "关键指标") @RequestBody KeyIndicatorsDto keyIndicators) {
        try {
            this.keyIndicatorsService.update(keyIndicators);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(DataTooLongGenerateRespUtil.generateRespStr(e, KeyIndicators.class));
        }
    }

    /**
     * 逻辑删除数据
     *
     * @param ids 主键集合
     * @return 删除结果
     */
    @ApiOperation(value = "删除数据")
    @DeleteMapping
    public Result<?> delete(@ApiParam(name = "ids", value = "主键集合") @RequestParam("ids") List<String> ids) {
        try {
            this.keyIndicatorsService.delete(ids);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 逻辑删除数据
     *
     * @param ids 主键集合
     * @return 删除结果
     */
    @ApiOperation(value = "删除数据")
    @PostMapping("deletePos")
    public Result<?> deletePos(@ApiParam(name = "ids", value = "主键集合") @RequestParam("ids") List<String> ids) {
        try {
            this.keyIndicatorsService.delete(ids);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 启用
     *
     * @param ids 主键集合
     * @return 操作结果
     */
    @ApiOperation(value = "启用")
    @PatchMapping("/enable")
    public Result<?> enable(@ApiParam(name = "ids", value = "主键集合") @RequestBody List<String> ids) {
        try {
            this.keyIndicatorsService.updateEnableStatus(ids, EnableStatusEnum.ENABLE.getCode());
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 禁用
     *
     * @param ids 主键集合
     * @return 操作结果
     */
    @ApiOperation(value = "禁用")
    @PatchMapping("/disable")
    public Result<?> disable(@ApiParam(name = "ids", value = "主键集合") @RequestBody List<String> ids) {
        try {
            this.keyIndicatorsService.updateEnableStatus(ids, EnableStatusEnum.DISABLE.getCode());
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
