package com.biz.crm.tpm.business.key.indicators.local.dataview;

import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 *  关键指标 DataView
 *  * @author miaoqiancheng
 *  * @since 2022-11-5
 */
@Component
public class KeyIndicatorsDataViewRegister implements DataviewRegister {

    @Override
    public String code() {
        return "tpm_key_indicators";
    }

    @Override
    public String desc() {
        return "TPM-关键指标";
    }

    @Override
    public String buildSql() {
        return "SELECT t.* FROM tpm_key_indicators t" +
                "  WHERE t.del_flag = '" + EnableStatusEnum.ENABLE.getCode() + "' "+
                "  AND t.tenant_code = :tenantCode ";
    }
}
