package com.biz.crm.tpm.business.key.indicators.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 实体：关键指标表
 *
 * @author miaoqiancheng
 * @since 2022-11-2
 */
@ApiModel(value = "KeyIndicators", description = "关键指标")
@TableName("tpm_key_indicators")
@EqualsAndHashCode(callSuper = false)
@Data
@Entity(name = "tpm_key_indicators")
@org.hibernate.annotations.Table(appliesTo = "tpm_key_indicators", comment = "关键指标")
@Table(name = "tpm_key_indicators", indexes = {@Index(name = "tpm_key_indicators_inx1", columnList = "key_indicators_code", unique = true)})
public class KeyIndicators extends TenantFlagOpEntity {

    /**
     * 数据字典:mdm_business_format
     */
    @ApiModelProperty(name = "业态编码", notes = "业态编码")
    @Column(name = "business_format_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态编码'")
    private String businessFormatCode;

    /**
     * 数据字典:mdm_business_unit
     */
    @ApiModelProperty(name = "业务单元", notes = "业务单元")
    @Column(name = "business_unit_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元'")
    private String businessUnitCode;

    @ApiModelProperty(name = "关键指标编码", notes = "关键指标编码")
    @Column(name = "key_indicators_code", nullable = false, length = 256, columnDefinition = "VARCHAR(256,) COMMENT '关键指标编码'")
    private String keyIndicatorsCode;

    @ApiModelProperty(name = "关键指标名称", notes = "关键指标名称")
    @Column(name = "key_indicators_name", nullable = false, length = 255, columnDefinition = "VARCHAR(255) COMMENT '关键指标名称'")
    private String keyIndicatorsName;

    @ApiModelProperty(name = "指标类型", notes = "指标类型")
    @Column(name = "indicators_type", nullable = false, length = 256, columnDefinition = "VARCHAR(256) COMMENT '指标类型'")
    private String indicatorsType;

    @ApiModelProperty(name = "bean路径", notes = "bean路径")
    @Column(name = "bean_path", length = 2048, columnDefinition = "VARCHAR(2048) COMMENT 'bean路径'")
    private String beanPath;

    @ApiModelProperty(name = "bean名称", notes = "bean名称")
    @Column(name = "bean_name", nullable = false, length = 255, columnDefinition = "VARCHAR(255) COMMENT 'bean名称'")
    private String beanName;

    @ApiModelProperty("测试替代值")
    @Column(name = "test_substitution_value", length = 4, nullable = false, columnDefinition = "int(4) COMMENT '测试替代值'")
    private Integer testSubstitutionValue;

    @ApiModelProperty("排序(值越小越靠前)")
    @Column(name = "sort_index", length = 4, nullable = false, columnDefinition = "int(4) COMMENT '排序(值越小越靠前)'")
    private Integer sortIndex;

    @ApiModelProperty(name = "描述", notes = "描述")
    @Column(name = "description", nullable = true,length = 512, columnDefinition = "VARCHAR(512) COMMENT '描述'")
    private String description;

    @ApiModelProperty(name = "configurable",value = "是否自定义变量",notes = "是否自定义变量")
    @Column(name = "configurable", nullable = true,length = 10, columnDefinition = "VARCHAR(10) COMMENT 'configurable'")
    private String configurable;
}
