package com.biz.crm.tpm.business.key.indicators.local.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang3.StringUtils;

import java.util.HashSet;
import java.util.Set;

public enum IndicatorsTypeEnum {

    HXIND("003","核销指标"),
    CTIND("007","合同指标"),
    YTIND("009","预提指标");

    @EnumValue
    @JsonValue
    private String code;
    private String des;

    private IndicatorsTypeEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return this.code;
    }

    public String getDes() {
        return this.des;
    }

    public static Set<String> codeToSet() {
        Set<String> codes = new HashSet();
        IndicatorsTypeEnum[] var1 = values();
        int var2 = var1.length;

        for(int var3 = 0; var3 < var2; ++var3) {
            IndicatorsTypeEnum indicatorsTypeEnum = var1[var3];
            codes.add(indicatorsTypeEnum.getCode());
        }

        return codes;
    }

    public static IndicatorsTypeEnum codeToEnum(String code) {
        IndicatorsTypeEnum promotionType = null;
        IndicatorsTypeEnum[] var2 = values();
        int var3 = var2.length;

        for(int var4 = 0; var4 < var3; ++var4) {
            IndicatorsTypeEnum indicatorsTypeEnum = var2[var4];
            if (indicatorsTypeEnum.code.equals(code)) {
                promotionType = indicatorsTypeEnum;
            }
        }

        return promotionType;
    }

    public static String getDesc(String code) {
        if (!StringUtils.isEmpty(code)) {
            IndicatorsTypeEnum[] values = values();
            IndicatorsTypeEnum[] var2 = values;
            int var3 = values.length;

            for(int var4 = 0; var4 < var3; ++var4) {
                IndicatorsTypeEnum value = var2[var4];
                if (value.code.equals(code)) {
                    return value.des;
                }
            }
        }

        return null;
    }

    public static boolean contains(String code) {
        if (StringUtils.isEmpty(code)) {
            return false;
        } else {
            IndicatorsTypeEnum[] values = values();
            IndicatorsTypeEnum[] var2 = values;
            int var3 = values.length;

            for(int var4 = 0; var4 < var3; ++var4) {
                IndicatorsTypeEnum value = var2[var4];
                if (value.getCode().equals(code)) {
                    return true;
                }
            }

            return false;
        }
    }


}
