package com.biz.crm.tpm.business.key.indicators.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.key.indicators.local.entity.KeyIndicators;
import com.biz.crm.tpm.business.key.indicators.sdk.dto.KeyIndicatorsDto;
import com.biz.crm.tpm.business.key.indicators.sdk.vo.KeyIndicatorsVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

/**
 * 关键指标(tpm_key_indicators)表数据库访问层
 *
 * @author : qiancheng
 * @date : 2022-11-2
 */
public interface KeyIndicatorsMapper extends BaseMapper<KeyIndicators> {

    /**
     * 分页查询数据
     *
     * @param page 分页对象
     * @param keyIndicators 实体对象
     * @return 分页对象列表
     */
    Page<KeyIndicatorsVO> findByConditions(@Param("page") Page<KeyIndicatorsVO> page, @Param("dto") KeyIndicatorsDto keyIndicators);
}
