package com.biz.crm.tpm.business.key.indicators.local.notifier;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.tpm.business.key.indicators.sdk.dto.KeyIndicatorsDto;
import com.biz.crm.tpm.business.key.indicators.sdk.dto.KeyIndicatorsLogEventDto;
import com.biz.crm.tpm.business.key.indicators.sdk.event.log.KeyIndicatorsLogEventListener;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 关键指标 业务日志监听实现
 *
 * @author : qiancheng
 * @date : 2022-11-2
 */
@Component
public class KeyIndicatorsLogEventListenerImpl implements KeyIndicatorsLogEventListener {

    @Autowired(required = false)
    private CrmBusinessLogVoService crmBusinessLogVoService;

    @Override
    public void onCreate(KeyIndicatorsLogEventDto eventDto) {
        KeyIndicatorsDto newest = eventDto.getNewest();
        KeyIndicatorsDto original = eventDto.getOriginal();
        String onlyKey = newest.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(original);
        crmBusinessLogDto.setNewObject(newest);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    @Override
    public void onDelete(KeyIndicatorsLogEventDto eventDto) {
        KeyIndicatorsDto newest = eventDto.getNewest();
        KeyIndicatorsDto original = eventDto.getOriginal();
        String onlyKey = original.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.DELETE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(original);
        crmBusinessLogDto.setNewObject(newest);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    @Override
    public void onUpdate(KeyIndicatorsLogEventDto eventDto) {
        KeyIndicatorsDto newest = eventDto.getNewest();
        KeyIndicatorsDto original = eventDto.getOriginal();
        String onlyKey = original.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(original);
        crmBusinessLogDto.setNewObject(newest);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    @Override
    public void onDisable(KeyIndicatorsLogEventDto eventDto) {
        //新对象
        KeyIndicatorsDto original = eventDto.getOriginal();
        String onlyKey = original.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        //只需要传启禁用字段
        JSONObject oldObject = new JSONObject();
        JSONObject newObject = new JSONObject();
        oldObject.put("enableStatus", original.getEnableStatus());
        newObject.put("enableStatus", EnableStatusEnum.DISABLE.getCode());
        crmBusinessLogDto.setOldObject(oldObject);
        crmBusinessLogDto.setNewObject(newObject);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    @Override
    public void onEnable(KeyIndicatorsLogEventDto eventDto) {
        //新对象
        KeyIndicatorsDto original = eventDto.getOriginal();
        String onlyKey = original.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        //只需要传启禁用字段
        JSONObject oldObject = new JSONObject();
        JSONObject newObject = new JSONObject();
        oldObject.put("enableStatus", original.getEnableStatus());
        newObject.put("enableStatus", EnableStatusEnum.DISABLE.getCode());
        crmBusinessLogDto.setOldObject(oldObject);
        crmBusinessLogDto.setNewObject(newObject);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

}
