package com.biz.crm.tpm.business.key.indicators.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.key.indicators.local.entity.KeyIndicators;
import com.biz.crm.tpm.business.key.indicators.local.mapper.KeyIndicatorsMapper;
import com.biz.crm.tpm.business.key.indicators.sdk.dto.KeyIndicatorsDto;
import com.biz.crm.tpm.business.key.indicators.sdk.vo.KeyIndicatorsVO;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;
import java.util.Objects;

/**
 * 关键指标表(tpm_key_indicators)数据库访问层
 *
 * @author : qiancheng
 * @date : 2022-11-2
 */
@Component
public class KeyIndicatorsRepository extends ServiceImpl<KeyIndicatorsMapper, KeyIndicators> {

    @Resource
    private KeyIndicatorsMapper keyIndicatorsMapper;

    /**
     * 分页查询数据
     *
     * @param pageable      分页对象
     * @param keyIndicators 实体对象
     */
    public Page<KeyIndicatorsVO> findByConditions(Pageable pageable, KeyIndicatorsDto keyIndicators) {
        if (pageable == null) {
            pageable = PageRequest.of(1, 50);
        }
        Page<KeyIndicatorsVO> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.keyIndicatorsMapper.findByConditions(page, keyIndicators);
    }

    public List<KeyIndicators> findByIds(List<String> ids) {
        return this.lambdaQuery()
                .eq(KeyIndicators::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(KeyIndicators::getTenantCode, TenantUtils.getTenantCode())
                .in(KeyIndicators::getId, ids)
                .list();
    }

    public List<KeyIndicators> findByCode(String keyIndicatorsCode, String delFlagStatus, String enableStatus) {
        return this.lambdaQuery()
                .eq(Objects.nonNull(delFlagStatus), KeyIndicators::getDelFlag, delFlagStatus)
                .eq(StringUtils.isNotEmpty(enableStatus), KeyIndicators::getEnableStatus, enableStatus)
                .eq(KeyIndicators::getTenantCode, TenantUtils.getTenantCode())
                .eq(KeyIndicators::getKeyIndicatorsCode, keyIndicatorsCode)
                .list();
    }

    public KeyIndicators findById(String id) {
        return this.lambdaQuery()
                .eq(KeyIndicators::getId, id)
                .eq(TenantFlagOpEntity::getTenantCode, TenantUtils.getTenantCode())
                .one();
    }
}
